/**
 * 2017
 * 上午9:50:15
 * 2017年5月23日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.budgettransferaudit.in
 * BudgetTransferAuditInVo.java
 * BudgetTransferAuditInVo
 */
package com.chinayanghe.msp.budget.vo.auditbudgettransfer.in;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.auditbudgettransfer.code.AuditBudgetTransferCode;
import com.chinayanghe.msp.budget.vo.auditbudgettransfer.out.AuditBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author yangshuo
 *
 */
public class AuditBudgetTransferInVo extends BaseVo implements AuditBudgetTransferCode {
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -1241346385989973448L;

	/**
	 * 预算转移申请单号   必填
	 */
	private String transferApplyNo;
	
	/**
	 * 审批通过日期必填
	 */
	private Date date;	
	/**
	 * 用户 必填
	 */
	private String user;
	/**
	 * 用户名字
	 */
	private String userName;
	
	/**
	 * 备注	
	 */
	private String remark;
	
	/**
	 * 明细
	 */
	private List<AuditBudgetTransferDetailInVo>  detail;


	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<AuditBudgetTransferOutVo>> validate() {
		if(StringUtils.isBlank(transferApplyNo)){
			return new BizResponseJson<List<AuditBudgetTransferOutVo>>(TRANSFER_APPLY_NO_NULL,null,"<预算转移申请单号>为必须字段，不能为空");
		}
  
		if(null == date){
			return new BizResponseJson<List<AuditBudgetTransferOutVo>>(SUBMMITDATE_NULL,null,"<审批通过日期>为必须字段，不能为空");
		}
 
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<AuditBudgetTransferOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		for(AuditBudgetTransferDetailInVo vo : detail){
			BizResponseJson<List<AuditBudgetTransferOutVo>> l = vo.validate();
			if(l.getCode()!=BizResponseJson.SC_OK){
				return l;
			}
 
		}
		return new BizResponseJson<List<AuditBudgetTransferOutVo>>();
	}

 

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getTransferApplyNo() {
		return transferApplyNo;
	}



	public void setTransferApplyNo(String transferApplyNo) {
		this.transferApplyNo = transferApplyNo;
	}



	public List<AuditBudgetTransferDetailInVo> getDetail() {
		return detail;
	}



	public void setDetail(List<AuditBudgetTransferDetailInVo> detail) {
		this.detail = detail;
	}



	public String getUserName() {
		return userName;
	}



	public void setUserName(String userName) {
		this.userName = userName;
	}

}
