/**
 * 2017 
 * 2017年5月5日  
 * 上午9:40:34
 * BizResponseJson.java
 * com.chinayanghe.msp.budget.vo.out
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.out;

import com.alibaba.fastjson.JSON;

/**
 * 业务层面返回信息
 * @author yangshuo
 *
 */
public class BizResponseJson<T> {
	/**
	 * 1000	执行成功
	 */
	public final static int SC_OK=1000;
	
	/**
	 * 2000 执行失败 预算项目锁定失败
	 */
	public final static int SC_ERROR=2000;
	
	/**
	 * 999 常规失败
	 */
	public final static int NORMAL_ERROR=999;

    /** 状态嘛*/
 
    private int code;
    /** 返回内容*/
 
    private T body;
    /** 消息*/
 
    private String message;

    public BizResponseJson() {
         this.code  = SC_OK;
         this.message = "成功";
    }

    public BizResponseJson(T body) {
        this.message = "成功";
        this.code = SC_OK;
        this.body = body;
    }

    public BizResponseJson(int code, T body, String message) {
        this.code = code;
        this.body = body;
        this.message = message;
    }

    /** 获取 状态嘛*/
    public int getCode() {
        return this.code;
    }

    /** 设置 状态嘛*/
    public void setCode(int code) {
        this.code = code;
    }

    /** 获取 返回内容*/
    public T getBody() {
        return this.body;
    }

    /** 设置 返回内容*/
    public void setBody(T body) {
        this.body = body;
    }

    /** 获取 消息*/
    public String getMessage() {
        return this.message;
    }

    /** 设置 消息*/
    public void setMessage(String message) {
        this.message = message;
    }
	@Override
	public String toString() {
		
		return JSON.toJSONString(this);
	}
}
