/**
 * 2017 
 * 2017年5月18日  
 * 下午5:06:12
 * FrontBudgetRpcService.java
 * com.chinayanghe.msp.budget.rpc
 * budget-rpc
 */
package com.chinayanghe.msp.budget.rpc;

import com.chinayanghe.msp.budget.vo.ReleaseBudgetVo;
import com.chinayanghe.msp.budget.vo.front.changplan.in.ChangePlanMoneyInVo;
import com.chinayanghe.msp.budget.vo.front.isusedmoney.in.IsUsedMoneyInVo;
import com.chinayanghe.msp.budget.vo.front.pushplan.in.PushProjectVo;
import com.chinayanghe.msp.budget.vo.front.transferplan.in.FissionTransferVo;
import com.chinayanghe.msp.budget.vo.front.transferplan.in.TransferIsusedMoneyInVo;
import com.chinayanghe.msp.budget.vo.front.transferplan.in.TransferPlanMoneyInVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 前端管理界面用到的rpc接口
 * @author yangshuo
 *
 */
public interface FrontBudgetRpcService {
	
	/**
	 * QYX_BUD_FUN_0026_调整预算项目计划金额
	 * 调整预算项目计划金额
	 * @param map key:budgetProjet（预算项目的地址code） value：变动金额 分
	 * @return
	 */
	public BizResponseJson<Object> changeBPPlanMoney(ChangePlanMoneyInVo vo);

	/**
	 * QYX_BUD_FUN_0027_预算项目计划金额转移_ 
	 * @param vo
	 * @return
	 */
	public BizResponseJson<Object> transferBPPlanMoney(TransferPlanMoneyInVo vo);
	
	/**
	 * QYX_BUD_FUN_0028_下达预算 
	 * @param vo
	 * @return
	 */
	public BizResponseJson<Object> isUsedMoney(IsUsedMoneyInVo vo);

	/**
	 * QYX_BUD_FUN_0029_预算项目下达金额转移
	 * @return
	 */
	public BizResponseJson<Object> issuedTransferMoney(TransferIsusedMoneyInVo transferIsusedMoneyInVo);

	/**
	 * QYX_BUD_FUN_0030_计划外追加下达预算
	 * @return
	 */
	public BizResponseJson<Object> appendIssuedTransferMoney(IsUsedMoneyInVo vo);

	/**
	 * QYX_BUD_FUN_0032_查询和冲销预算变动单
	 * @return
	 */
	BizResponseJson<Object> pushBudgetService(PushProjectVo vo) ;

	/**
	 * QYX_BUD_FUN_0038_分公司组织裂变-已执行预算
	 * @return
	 */
	BizResponseJson<Object> fissionTransfer(FissionTransferVo vo) ;

	/**
	 * QYX_BUD_FUN_0031_按销售进度释放预算
	 */
	BizResponseJson<Object> releaseBudget(ReleaseBudgetVo vo) ;
	
	
	/**
	 * 生成预算地址code
	 * @param year 预算年度
 
	 * @return
	 */
	String createBudgetCode(String year  );
	
	/**
	 * 生成预算预留单编码
	 * @return
	 */
	String createBudgetBillCode();
	
	/**
	 * 生成预算变动单编码
	 * @return
	 */
	String createBudgetChangeBillCode();
	

}
