/**
 * 2017
 * 下午1:35:01
 * 2017年5月25日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.applybudgettransfer.in
 * ApplyBudgetTransferDetailInVo.java
 * ApplyBudgetTransferDetailInVo
 */
package com.chinayanghe.msp.budget.vo.applybudgettransfer.in;

import java.math.BigDecimal;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudgettransfer.code.ApplyBudgetTransferCode;
import com.chinayanghe.msp.budget.vo.applybudgettransfer.out.ApplyBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 市场活动表单明细
 * @author yangshuo
 *
 */
public class ApplyBudgetTransferDetailInVo extends BaseVo implements ApplyBudgetTransferCode {

	/**
	 * 
	 */
	private static final long serialVersionUID = -3640288032494654578L;
	
	/**
	 * 行号 从1开始
	 */
	private Integer item;
	/**
	 * 转入预算地址
	 */
	private String budgetAddressCodeIn;
	/**
	 * 转出预算地址
	 */
	private String budgetAddressCodeOut;
	
	/**
	 * 转移金额  正数
	 */
	private BigDecimal transferMoney;

	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<ApplyBudgetTransferOutVo>> validate() {
		if(null == item){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(ITEM_NULL,null,"<行项目>为必须字段，不能为空");
		}
 
		if(StringUtils.isBlank(budgetAddressCodeIn)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(BUDGETADDRESSCODE_IN_NULL,null,"<转入预算地址>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(budgetAddressCodeOut)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(BUDGETADDRESSCODE_OUT_NULL,null,"<转出预算地址>为必须字段，不能为空");
		}
		if(budgetAddressCodeIn.equals(budgetAddressCodeOut)){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(BUDGETADDRESSCODE_SAME,null,"<转出预算地址>不能和<转入预算地址>相等");
		}
		if(null == transferMoney || transferMoney.compareTo(BigDecimal.ZERO)<=0){
			return new BizResponseJson<List<ApplyBudgetTransferOutVo>>(TRANSFERMONEY_NULL,null,"<转移金额 >不能为0或负数");
		}
		return new BizResponseJson<List<ApplyBudgetTransferOutVo>>();
	}

	 

	public BigDecimal getTransferMoney() {
		return transferMoney;
	}

	public void setTransferMoney(BigDecimal transferMoney) {
		this.transferMoney = transferMoney;
	}



	public Integer getItem() {
		return item;
	}



	public void setItem(Integer item) {
		this.item = item;
	}



	public String getBudgetAddressCodeIn() {
		return budgetAddressCodeIn;
	}



	public void setBudgetAddressCodeIn(String budgetAddressCodeIn) {
		this.budgetAddressCodeIn = budgetAddressCodeIn;
	}



	public String getBudgetAddressCodeOut() {
		return budgetAddressCodeOut;
	}



	public void setBudgetAddressCodeOut(String budgetAddressCodeOut) {
		this.budgetAddressCodeOut = budgetAddressCodeOut;
	}

	 

}
