/**
 * 2017 
 * 2017年5月17日  
 * 上午9:37:56
 * ApplyBudgetCode.java
 * com.chinayanghe.msp.budget.vo.applybudget.code
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.applybudget.code;

import java.io.Serializable;

/**
 * 返回状态码
 * @author yangshuo
 *
 */
public interface ApplyBudgetCode extends Serializable {

	
	/**
	 * 市场活动申请单号参数为空
	 */
	public final static int MARKETACTIVENO_NULL=1101;
 
	/**
	 * 审批通过日期参数为空
	 */
	public final static int SUBMMITDATE_NULL=1103;
 	
	/**
	 * 用户参数不能为空
	 */
	public final static int USER_NULL=1105;
	
	/**
	 * 市场活动单明细不能为空
	 */
	public final static int MARKETACTIVITYDETAIL_NULL=1106;
	/**
	 * 传入明细的品牌大类+渠道+费用类型有重复
	 */
	public final static int DUPLICATE=1108;
	
	/**
	 * 品牌大类参数为空
	 */
	public final static int BRANDCATEGORY_NULL=1130;
	
	/**
	 * 渠道参数为空
	 */
	public final static int BUDGETCHANNEL_NULL=1131;
	/**
	 * 费用类型参数为空
	 */
	public final static int COSTTYPE_NULL=1132;
	/**
	 * 金额参数为空
	 */
	public final static int AMOUNT_NULL=1133;
	/**
	 * 金额不能为负数，详见返回详细消息
	 */
	public final static int AMOUNT_LESS_ZERO=1183;
	/**
	 * 金额不能为小数，详见返回详细消息
	 */
	public final static int AMOUNT_HAVE_POINT=1184;
	/**********下方是逻辑校验*******/
	/**
	 * i.根据申请单号<申请单号>找不到状态为“审批中”的预算预留单
	 */
	public final static int APPLY_BUDGET_NOTEXITS=1150;
	
	/**
	 * 根据申请单号<申请单号>找到多张状态为 “审批中”的预算预留单
	 */
	public final static int APPLY_BUDGET_MORE_THAN_ONE=1151;
	
	/**
	 * 没有找到对应的预算预留单明细，详见返回详细消息
	 */
	public final static int BUDGETBILLDETAIL_NOTEXITS=1152;
	
	/**
	 * ii.相同品牌大类+渠道+费用类型的预算预留单明细有多行，详见返回详细消息
	 */
	public final static int BUDGETBILLDETAIL_MORE_THAN_ONE=1153;
	
	
	/**
	 * 审核金额大于预算冻结金额，详见返回详细消息
	 */
	public final static int BUDGETBILLDETAIL_MONEY_NOT_ENOUGH=1154;
}
