/**
 * 2017 
 * 2017年5月9日  
 * 上午9:25:10
 * CheckBudgetCode.java
 * com.chinayanghe.msp.budget.vo.checkbudget.code
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.checkbudget.code;

import java.io.Serializable;

/**
 * 市场活动单表头状态
 *  QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
 * 返回状态码
 * @author yangshuo
 *
 */
public interface MarketActiveTitleCode extends Serializable {
	
	/**
	 * 执行方式为检查
	 */
	public final static String EXEC_TYPE_CHECK="1";
	/**
	 * 执行方式为冻结
	 */
	public final static String EXEC_TYPE_LOCK="2";
	/*******************以下是错误返回状态***************/
	/**
	 * 执行方式参数为空
	 */
	public final static int EXECTYPE_NULL=1100;
	/**
	 * 市场活动申请单号参数为空
	 */
	public final static int MARKETACTIVENO_NULL=1101;
	/**
	 * 预算年度参数为空
	 */
	public final static int BUDGETYEAR_NULL=1102;
	/**
	 * 提交审批日期参数为空
	 */
	public final static int SUBMMITDATE_NULL=1103;
	/**
	 * 列支渠道参数为空
	 */
	public final static int BRANCHCHANNELCODE_NULL=1104;
	
	/**
	 * 用户参数不能为空
	 */
	public final static int USER_NULL=1105;
	/**
	 * 市场活动单明细不能为空
	 */
	public final static int MARKETACTIVITYDETAIL_NULL=1106;
	
	/**
	 * 公司，大区，分公司，一级巴，二级巴，一级部门，一级部门，三级部门，四级部门，五级部门不能都为空
	 */
	public final static int COMPANY_ALL_NULL=1107;
	/**
	 * 传入明细的品牌大类+渠道+费用类型有重复
	 */
	public final static int DUPLICATE=1108;
	
	/***************以下是字段内容检查*****************/

	/**
	 * 执行方式只能是1或者2
	 */
	public final static int EXECTYPE_TYPE_ERROR=1150;
	
	/**
	 * 该申请单已经有对应的预算预留单<单号>
	 */
	public final static int MARKET_ACTIVITY_EXIT=1151;
	
	/**
	 * 预算年度不存在
	 */
	public final static int BUDGET_YEAR_NOT_EXIT=1152;
	
	/**
	 * 预算年度<预算年度>在提交审批日期<提交审批日期>不可用
	 */
	public final static int BUDGET_YEAR_AUDIT_NOT_USE=1153;
	
	/**
	 * 预算年度<预算年度>在当前系统日期<当前日期>不可用
	 */
	public final static int BUDGET_YEAR_CURENT_NOT_USE=1154;
	
	/**
	 * 列支渠道不存在
	 */
	public final static int BUDGET_BRANCH_CHANNEL_NOT_EXIT=1155;
	
	/**
	 * 列支渠道<编码>-<名称>没有维护对应的预算类型
	 */
	public final static int BUDGETTYPECODE_NOT_EXIT=1156;
	
	/**
	 * 列支渠道<编码>-<名称>没有维护对应的预算对象
	 */
	public final static int BUDGETOBJTYPE_NOT_EXIT=1157;
	
	/**
	 * 经销商不存在
	 */
	public final static int FRANCHISER_NOT_EXIT=1158;
	
	/**
	 * 经销商没有主经销商号
	 */
	public final static int FRANCHISER_NOT_MASTERCODE=1159;
	
	/**
	 * 公司<编码>不存在
	 */
	public final static int COMPANY_NOT_EXIT=1160;
	
	/**
	 * 大区<编码>不存在
	 */
	public final static int DISTRIC_NOT_EXIT=1161;
	/**
	 * 分公司<编码>不存在
	 */
	public final static int SUBCOMPANY_NOT_EXIT=1162;
	
	
	/**
	 * 一级巴<编码>不存在
	 */
	public final static int ONEBAR_NOT_EXIT=1163;
	
	/**
	 * 二级巴<编码>不存在
	 */
	public final static int TWOBAR_NOT_EXIT=1164;
	
	/**
	 * 一级部门<编码>不存在
	 */
	public final static int ONEDEPARTMENT_NOT_EXIT=1165;
	/**
	 * 二级部门<编码>不存在
	 */
	public final static int TWODEPARTMENT_NOT_EXIT=1166;
	/**
	 * 三级部门<编码>不存在
	 */
	public final static int THREEDEPARTMENT_NOT_EXIT=1167;
	/**
	 * 四级部门<编码>不存在
	 */
	public final static int FOURDEPARTMENT_NOT_EXIT=1168;
	/**
	 * 五级部门<编码>不存在
	 */
	public final static int FIVEDEPARTMENT_NOT_EXIT=1169;
	
	/********************以下错误描述为转换错误****************************/
	/**
	 * a)列支渠道<编码>-<名称>使用公司预算，但传入的公司为空
	 */
	public final static int COMPANY_NULL=1200;
	
	/**
	 * a)列支渠道<编码>-<名称>使用大区预算，但传入的大区为空
	 */
	public final static int DISTRICT_NULL=1201;
	/**
	 * a)列支渠道<编码>-<名称>使用分公司预算，但传入的分公司为空
	 */
	public final static int SUBCOMPANY_NULL=1202;
	/**
	 * 列支渠道<编码>-<名称>使用一级巴预算，但传入的一级巴为空
	 */
	public final static int ONEBAR_NULL=1203;
	/**
	 * 列支渠道<编码>-<名称>使用二级巴预算，但传入的二级巴为空
	 */
	public final static int TWOBAR_NULL = 1204;
	/**
	 *  列支渠道<编码>-<名称>使用一级部门预算，但传入的一级部门为空
	 */
	public static final int ONEDEPARTMENT_NULL = 1205;
	
	/**
	 * 列支渠道<编码>-<名称>使用二级部门预算，但传入的二级部门为空
	 */
	public static final int TWODEPARTMENT_NULL = 1206;
	/**
	 * 列支渠道<编码>-<名称>使用三级部门预算，但传入的三级部门为空
	 * 
	 */
	public static final int THREEDEPARTMENT_NULL = 1207;
	/**
	 * 列支渠道<编码>-<名称>使用四级部门预算，但传入的四级部门为空
	 * 
	 */
	public static final int FOURDEPARTMENT_NULL = 1208;
	/**
	 * 列支渠道<编码>-<名称>使用五级部门预算，但传入的五级部门为空
	 * 
	 */
	public static final int FIVEDEPARTMENT_NULL = 1209;
	
	/**
	 * 列支渠道<编码>-<名称>使用经销商预算，但传入的分公司为空
	 */
	public final static int FRANCHISER_SUBCOMPANY_NULL=1210;
	/**
	 * 列支渠道<编码>-<名称>使用经销商预算，但传入的经销商为空
	 */
	public final static int FRANCHISER_NULL=1211;
	/**
	 * 列支渠道<编码>-<名称>使用新江苏预算，但传入的经销商为空
	 */
	public final static int FRANCHISER_NEW_JIANGSU_NULL=1212;
	/**
	 * 列支渠道<编码>-<名称>使用新江苏预算，但传入的分公司为空
	 */
	public final static int FRANCHISER_NEW_JIANGSU_SUBCOMPANY_NULL=1213;
	
	/**
	 * 无法确定新江苏类型
	 */
	public final static int NOT_NEW_JIANGSU_SUBCOMPANY_SD_CODE=1214;
	/**
	 * <新江苏类型衍生规则表>中 如果没有找到，则返回消息：无法确定新江苏类型
	 */
	public final static int NOT_NEW_JIANGSU_SUBCOMPANY=1215;
	
	/**
	 * 经销商<编码>-<名称>没有找到对应<一般新江苏/老名酒新江苏>的新江苏组织编码
	 * 
	 * 备注：此规则是通过预算表的本地新江苏规则没有查找到新江苏
	 */
	public final static int NOT_NEW_JIANGSU_LOCAL=1216;
	/*****************下面错误为寻址范围和优先级 返回消息代码范围为1300~1399***********/
	/**
	 * 列支渠道<编码>-<名称>没有维护寻址范围和优先级
	 */
	public final static int BRANCH_CHANEL_NO_SEEK=1300;
	
	/**
	 * 预算地址组合<编码>没有维护规则
	 */
	public final static int BUDGET_NO_ADDRESS=1301;
	/********************以下为查找预算项目的时候出的错误 返回消息代码范围为1400~1499*********************************/
	/**
	 * 有<行数>个行项目找不到预算项目，详见返回详细信息
	 */
	public final static int NOT_FIND_BUDGET_PROJECT = 1400;
	
	/**
	 * b)找到了多个不同的预算项目，一张申请单只能有一个预算项目，详见返回详细信息
	 */
	public final static int FIND_MORE_BUDGET_PROJECT = 1401;
	
	/**
	 * 预算不足，详见返回详细信息
	 */
	public final static int NOT_ENOUGH_BUDGET_PROJECT = 1402;
}
