package com.chinayanghe.msp.budget.vo.auditbudgettransfer.in;

import java.math.BigDecimal;
import java.util.List;

import com.chinayanghe.msp.budget.vo.auditbudgettransfer.code.AuditBudgetTransferCode;
import com.chinayanghe.msp.budget.vo.auditbudgettransfer.out.AuditBudgetTransferOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

public class AuditBudgetTransferDetailInVo  extends BaseVo implements AuditBudgetTransferCode{

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -4341493290201011996L;
	
	/**
	 * 行号 从1开始
	 */
	private Integer item;
 	
	/**
	 * 审核金额  正数
	 */
	private BigDecimal transferMoney;

	@Override
	public BizResponseJson<List<AuditBudgetTransferOutVo>> validate() {
		if(null == item){
			return new BizResponseJson<List<AuditBudgetTransferOutVo>>(ITEM_NULL,null,"<行项目>为必须字段，不能为空");
		}

		if(null == transferMoney || transferMoney.compareTo(BigDecimal.ZERO)<=0){
			return new BizResponseJson<List<AuditBudgetTransferOutVo>>(TRANSFERMONEY_NULL,null,"<转移金额 >不能为0或负数");
		}
		return new BizResponseJson<List<AuditBudgetTransferOutVo>>();
	}

	public Integer getItem() {
		return item;
	}

	public void setItem(Integer item) {
		this.item = item;
	}

	public BigDecimal getTransferMoney() {
		return transferMoney;
	}

	public void setTransferMoney(BigDecimal transferMoney) {
		this.transferMoney = transferMoney;
	}

}
