package com.chinayanghe.msp.mdm.dto.franchiser;

import com.chinayanghe.msp.mdm.enums.PositionFranchiseDuty;
import com.chinayanghe.msp.mdm.vo.position.PositionInformationVo;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/5/5
 */
public class FranchisePositionRelationDto implements Serializable{

    private static final long serialVersionUID = -6541034365723300605L;

    private String id;

    //别名
    private String name;

    private Date createDate;

    private Date updateDate;

    /**
     * 创建人用户名
     */
    private String createUsername;

    /**
     * 更新人用户名
     */
    private String updateUsername;

    /**
     * 启用禁用状态
     */
    private Boolean enable;

    /**
     * 经销商编码
     */
    private String franchiserCode;

    /**
     * 岗位组织关系
     * 只存在岗位编码和组织编码
     */
    private PositionInformationVo position;

    /**
     * 岗位职责关系
     */
    private List<PositionFranchiseDuty> positionDuties;

    public String getFranchiserCode() {
        return franchiserCode;
    }

    public void setFranchiserCode(String franchiserCode) {
        this.franchiserCode = franchiserCode;
    }

    public PositionInformationVo getPosition() {
        return position;
    }

    public void setPosition(PositionInformationVo position) {
        this.position = position;
    }

    public List<PositionFranchiseDuty> getPositionDuties() {
        return positionDuties;
    }

    public void setPositionDuties(List<PositionFranchiseDuty> positionDuties) {
        this.positionDuties = positionDuties;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Date getUpdateDate() {
        return updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    public String getCreateUsername() {
        return createUsername;
    }

    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    public String getUpdateUsername() {
        return updateUsername;
    }

    public void setUpdateUsername(String updateUsername) {
        this.updateUsername = updateUsername;
    }

    public Boolean getEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }
}
