package com.chinayanghe.msp.mdm.dto.franchiser;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 经销商vo
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public class FranchiserDto implements Serializable{

    private static final long serialVersionUID = 1772782687507490918L;

    private String id;

    /***
     * 经销商编码
     */
    private String franchiserCode;

    /***
     * 经销商名称
     */
    private String franchiserName;

    /**
     * 经销商类型/称谓：
     * 公司/个人
     */
    private String franchiserType;

    /**
     * 资金能力
     */
    private String bankrollLevel;

    /**
     * 客户类型编码
     */
    private String customerTypeCode;

    /**
     * 客户类型名称
     */
    private String customerTypeName;

    /**
     * 主客户编码:
     * 子客户和主客户共用一个经销商协议，在费用申请和经销商下单时使用
     */
    private String masterCustomerCode;

    /**
     * 冻结状态
     */
    private Integer status;

    /**
     * SAP创建时间
     */
    private Date createDate;

    /**
     * 创建用户
     * SAP账号
     */
    private String createUsername;

    /**
     * 销售范围
     */
    private List<SaleRangeDto> saleRanges;

    /**
     * 经销商银行账号
     */
    private List<FranchiserBankDto> franchiserBanks;

    /**
     * 经销商联系人
     */
    private List<FranchiserContactsDto> franchiserContacts;


    public String getFranchiserCode() {
        return franchiserCode;
    }

    public void setFranchiserCode(String franchiserCode) {
        this.franchiserCode = franchiserCode;
    }

    public String getFranchiserName() {
        return franchiserName;
    }

    public void setFranchiserName(String franchiserName) {
        this.franchiserName = franchiserName;
    }

    public String getFranchiserType() {
        return franchiserType;
    }

    public void setFranchiserType(String franchiserType) {
        this.franchiserType = franchiserType;
    }

    public String getBankrollLevel() {
        return bankrollLevel;
    }

    public void setBankrollLevel(String bankrollLevel) {
        this.bankrollLevel = bankrollLevel;
    }

    public String getCustomerTypeCode() {
        return customerTypeCode;
    }

    public void setCustomerTypeCode(String customerTypeCode) {
        this.customerTypeCode = customerTypeCode;
    }

    public String getCustomerTypeName() {
        return customerTypeName;
    }

    public void setCustomerTypeName(String customerTypeName) {
        this.customerTypeName = customerTypeName;
    }

    public String getMasterCustomerCode() {
        return masterCustomerCode;
    }

    public void setMasterCustomerCode(String masterCustomerCode) {
        this.masterCustomerCode = masterCustomerCode;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getCreateUsername() {
        return createUsername;
    }

    public void setCreateUsername(String createUsername) {
        this.createUsername = createUsername;
    }

    public List<SaleRangeDto> getSaleRanges() {
        return saleRanges;
    }

    public void setSaleRanges(List<SaleRangeDto> saleRanges) {
        this.saleRanges = saleRanges;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<FranchiserBankDto> getFranchiserBanks() {
        return franchiserBanks;
    }

    public void setFranchiserBanks(List<FranchiserBankDto> franchiserBanks) {
        this.franchiserBanks = franchiserBanks;
    }

    public List<FranchiserContactsDto> getFranchiserContacts() {
        return franchiserContacts;
    }

    public void setFranchiserContacts(List<FranchiserContactsDto> franchiserContacts) {
        this.franchiserContacts = franchiserContacts;
    }


}
