package com.chinayanghe.msp.mdm.dto.franchiser;

import java.io.Serializable;
import java.util.List;

/**
 * 经销商销售范围(分公司，销售渠道，产品组)定义一个销售范围
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public class SaleRangeDto implements Serializable{

    private static final long serialVersionUID = 1440119578749972272L;

    private String id;

    /**
     * 经销商id
     */
    private String franchiserId;

    /**
     * 子公司/下级办事处编码
     *
     */
    private String filialeCode;

    /**
     * 子公司/下级办事处名称
     */
    private String filialeName;

    /**
     * 分销渠道编码
     */
    private String channelCode;

    /**
     * 分销渠道名称
     */
    private String channelName;

    /**
     * 产品组编码
     */
    private String productGroupCode;

    /**
     * 产品组名称
     */
    private String productGroupName;

    /**
     * 合作伙伴：
     * 售达方，收票方，付款方，送达方，外勤业务人员
     */
    private List<String> partners;

    /**
     * 启用状态
     */
    private Integer enableState;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFilialeCode() {
        return filialeCode;
    }

    public void setFilialeCode(String filialeCode) {
        this.filialeCode = filialeCode;
    }

    public String getFilialeName() {
        return filialeName;
    }

    public void setFilialeName(String filialeName) {
        this.filialeName = filialeName;
    }

    public String getChannelCode() {
        return channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public String getChannelName() {
        return channelName;
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public String getProductGroupCode() {
        return productGroupCode;
    }

    public void setProductGroupCode(String productGroupCode) {
        this.productGroupCode = productGroupCode;
    }

    public String getProductGroupName() {
        return productGroupName;
    }

    public void setProductGroupName(String productGroupName) {
        this.productGroupName = productGroupName;
    }

    public List<String> getPartners() {
        return partners;
    }

    public void setPartners(List<String> partners) {
        this.partners = partners;
    }

    public Integer getEnableState() {
        return enableState;
    }

    public void setEnableState(Integer enableState) {
        this.enableState = enableState;
    }

    public String getFranchiserId() {
        return franchiserId;
    }

    public void setFranchiserId(String franchiserId) {
        this.franchiserId = franchiserId;
    }
}
