package com.chinayanghe.msp.mdm.rpc;

import com.chinayanghe.msp.mdm.enums.PositionFranchiseDuty;
import com.chinayanghe.msp.mdm.vo.franchiser.*;

import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/5/4
 */
public interface FranchiserRpcService {

    /**
     * 查询经销商
     * @param franchiserCode 经销商编码
     * @param customerTypeCode 客户类型编码
     * @param filterFreeze 是否过滤冻结经销商
     * @return
     */
    List<FranchiserVo> findFranchiserDetails(String franchiserCode, String customerTypeCode, Boolean filterFreeze);

    /**
     * 查找组织下所关联的经销商
     * @param ordCode 组织编码
     * @param franchiserCode 经销商编码
     * @param franchiserName 经销商名称
     * @return
     */
    List<FranchiserVo> findFranchiserDetailsFromOrg(String ordCode, String franchiserCode, String franchiserName);

    /**
     * 根据经销商编码查询经销商供货区域
     * @param franchiserCode 经销商编码
     * @param  includeNotActive 是否包含失效的供货区域
     * @return
     */
    List<FranchiseSaleAreaVo> findFranchiseSaleAreasByFranchiserCode(String franchiserCode, Boolean includeNotActive);

    /**
     * 根据经销商编码查询经销商销售范围
     * @param franchiserCode 经销商编码
     * @return
     */
    List<SaleRangeVo> findFranchiseSaleRangeByFranchiserCode(String franchiserCode);

    /**
     * 根据经销商编码、分公司组织类型查询销售范围
     * @param franchiserCode 经销商编码
     * @param sdFranchiserType 新公司类型
     * @return
     */
    List<SaleRangeVo> findSaleRange(String franchiserCode, String sdFranchiserType);

    /**
     * 根据经销商编码、分公司组织类型、分公司编码查询销售范围
     * @param franchiserCode 经销商编码
     * @param sdFranchiserType 新公司类型
     * @param filialeCode 分公司编码
     * @return
     */
    List<SaleRangeVo> findSaleRange(String franchiserCode, String sdFranchiserType,String filialeCode);

    /**
     * 查询经销商协议
     * @param franchiserCode 经销商编码
     * @param filialeCode 分公司/办事处组织代码
     * @param materielCode 物料编码
     * @return
     */
    List<FranchiseProtocolVo> findFranchiseProtocolDetails(String franchiserCode, String filialeCode, String materielCode);

    /**
     * 查询岗位经销商关系
     * @param franchiserCode 经销商编码
     * @param positionCode 岗位编码
     * @param duties 岗位职责
     * @return
     */
    List<FranchisePositionRelationVo> findFranchisePositionRelations(String franchiserCode, String positionCode, List<PositionFranchiseDuty> duties);

    /**
     * 获取经销商各类型产品价格信息
     * @param franchiserCode 经销商编码
     * @param productCode 物料编码
     * @param priceTypeCode 价格类型
     * @return
     */
    List<FranchiserProductPriceVo> findFranchiseProductPricesInfoList(String franchiserCode, String productCode, String priceTypeCode);

    /**
     * 获取经销商各类型产品价格信息
     * @param companyCode 公司编码
     * @param productCode 物料编码
     * @param priceTypeCode 价格类型
     * @return
     */
    List<CompanyProductPriceVo> findFranchiseProductPriceDetailList(String companyCode, String productCode, String priceTypeCode);

    /**
     * 查询经销商协议
     * @param franchiserCode 经销商编码
     * @param filialeCode 分公司/办事处组织代码
     * @param materielCode 物料编码
     * @param materielName 物料名称
     * @return
     */
    List<FranchiseProtocolVo> findFranchiseProtocolDetails(String franchiserCode, String filialeCode, String materielCode,String materielName);
}
