package com.chinayanghe.msp.mdm.rpc;

import java.util.List;

import com.chinayanghe.msp.mdm.vo.franchiser.CompanyProductPriceVo;
import com.chinayanghe.msp.mdm.vo.franchiser.FranchiseMaterielVo;
import com.chinayanghe.msp.mdm.vo.franchiser.FranchiseProtocolVo;
import com.chinayanghe.msp.mdm.vo.franchiser.FranchiseSaleAreaVo;
import com.chinayanghe.msp.mdm.vo.franchiser.FranchiserPositonVo;
import com.chinayanghe.msp.mdm.vo.franchiser.FranchiserProductPriceVo;
import com.chinayanghe.msp.mdm.vo.franchiser.FranchiserVo;
import com.chinayanghe.msp.mdm.vo.franchiser.ProductSettlePriceVo;
import com.chinayanghe.msp.mdm.vo.franchiser.SaleRangeVo;
import com.chinayanghe.msp.mdm.vo.user.UserBasicInformationVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/5/4
 */
public interface FranchiserRpcService {

    /**
     * 查询经销商
     * @param franchiserCode 经销商编码
     * @param customerTypeCode 客户类型编码
     * @param filterFreeze 是否过滤冻结经销商，为false时才不过滤。null或true过滤
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiserDetailsPageFromOrg(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiserVo> findFranchiserDetails(String franchiserCode, String customerTypeCode, Boolean filterFreeze);

    /**
     * 查找组织下所关联的经销商,会过滤冻结经销商
     * @param ordCode 组织编码 eq
     * @param franchiserCode 经销商编码 eq
     * @param franchiserName 经销商名称 like
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiserDetailsPageFromOrg(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiserVo> findFranchiserDetailsFromOrg(String ordCode, String franchiserCode, String franchiserName);

    /**
     * 查找组织下所关联的经销商,会过滤冻结经销商
     * @param ordCode 组织编码 eq
     * @param franchiserCode 经销商编码 eq
     * @param franchiserName 经销商名称 like
     * @param franchiserCodeOrName  经销商编码或名称 like
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiserDetailsPageFromOrg(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiserVo> findFranchiserDetailsFromOrg(String ordCode, String franchiserCode, String franchiserName,String franchiserCodeOrName);

    /**
     * 分页查找组织下所关联的经销商
     * @param pageable 分页信息 queryCondition key->ordCode(组织编码：精确),franchiserCode(经销商编码：精确),franchiserName(经销商名称：模糊),franchiserCodeOrName(经销商编码或名称：模糊),
     *                 orgCodes(组织编码集合：精确),filterFreeze (是否过滤冻结经销商,为false时才不过滤。null或true过滤),customerTypeCode (客户类型编码:eq),positionCode4Cost(岗位编码，费用用，岗位与经销商费用关系)
     * @return
     */
    Page<FranchiserVo> findFranchiserDetailsPageFromOrg(Pageable pageable);

    /**
     * 根据经销商编码查询经销商供货区域
     * @param franchiserCode 经销商编码
     * @param  includeNotActive 是否包含失效的供货区域(为true时才包含，null或false不包含)
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiseSaleAreasByFranchiserCodePage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiseSaleAreaVo> findFranchiseSaleAreasByFranchiserCode(String franchiserCode, Boolean includeNotActive);

    /**
     * 根据经销商编码分页查询经销商供货区域
     * @param pageable 分页信息 queryCondition key->：franchiserCode （String 经销商编码）、includeNotActive (是否包含失效的供货区域,为true时才包含，null或false不包含)
     * @return
     */
    Page<FranchiseSaleAreaVo> findFranchiseSaleAreasByFranchiserCodePage(Pageable pageable);

    /**
     * 根据经销商编码查询经销商销售范围
     * @param franchiserCode 经销商编码
     * @return
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findSaleRangePage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<SaleRangeVo> findFranchiseSaleRangeByFranchiserCode(String franchiserCode);

    /**
     * 根据岗位编码查询经销商销售范围
     * @param positionCode 岗位编码
     * @return
     */
    List<SaleRangeVo> findSaleRangeByPositionCode(String positionCode);
    /**
     * 根据经销商编码、分公司组织类型查询销售范围
     * @param franchiserCode 经销商编码
     * @param sdFranchiserType 新公司类型
     * @return
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findSaleRangePage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<SaleRangeVo> findSaleRange(String franchiserCode, String sdFranchiserType);

    /**
     * 根据经销商编码、分公司组织类型、分公司编码查询销售范围
     * @param franchiserCode 经销商编码
     * @param sdFranchiserType 新公司类型
     * @param filialeCode sd分公司编码
     * @return
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findSaleRangePage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<SaleRangeVo> findSaleRange(String franchiserCode, String sdFranchiserType,String filialeCode);

    /**
     * 分页查询经销商销售范围
     * @param pageable 分页信息 queryCondition key->：franchiserCode (经销商编码)、sdFranchiserType （新公司类型）、filialeCode （组织sd编码）
     * @return
     */
    Page<SaleRangeVo> findSaleRangePage(Pageable pageable);

    /**
     * 查询经销商协议
     * @param franchiserCode 经销商编码
     * @param filialeCode sd分公司/办事处组织代码
     * @param materielCode 物料编码
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiseProtocolDetailsPage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiseProtocolVo> findFranchiseProtocolDetails(String franchiserCode, String filialeCode, String materielCode);

    /**
     * 获取经销商各类型产品价格信息
     * @param franchiserCode 经销商编码
     * @param productCode 物料编码
     * @param priceTypeCode 价格类型
     * @return
     */
    List<FranchiserProductPriceVo> findFranchiseProductPricesInfoList(String franchiserCode, String productCode, String priceTypeCode);

    /**
     * 获取经销商各类型产品价格信息
     * @param companyCode 公司编码
     * @param productCode 物料编码
     * @param priceTypeCode 价格类型
     * @return
     */
    List<CompanyProductPriceVo> findFranchiseProductPriceDetailList(String companyCode, String productCode, String priceTypeCode);

    /**
     * 查询经销商协议
     * @param franchiserCode 经销商编码
     * @param sdFilialeCode 分公司/办事处sd组织代码
     * @param materielCode 物料编码
     * @param materielName 物料名称
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiseProtocolDetailsPage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiseProtocolVo> findFranchiseProtocolDetails(String franchiserCode, String sdFilialeCode, String materielCode,String materielName);

    /**
     * 查询经销商协议
     * @param franchiserCode 经销商编码
     * @param sdFilialeCode 分公司/办事处sd组织代码
     * @param materielCode 物料编码
     * @param materielName 物料名称
     * @param filialeOrgCode 分公司/办事处／阿米巴组织代码
     * @return
     * @warn 不传参数将返回所有
     * @deprecated 过时、请调用分页接口 {@link FranchiserRpcService#findFranchiseProtocolDetailsPage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<FranchiseProtocolVo> findFranchiseProtocolDetails(String franchiserCode, String sdFilialeCode, String materielCode,String materielName,String filialeOrgCode);

    /**
     * 分页查询经销商协议
     * @param pageable 分页信息 queryCondition key->：franchiserCode （经销商编码）、sdFilialeCode （分公司/办事处sd组织代码）、materielCode （商品编码 eq）、materielName （商品名称）、filialeOrgCode （分公司/办事处／阿米巴组织代码）
     * @return
     */
    Page<FranchiseProtocolVo> findFranchiseProtocolDetailsPage(Pageable pageable);
    /**
     * 获取产品结算价
     * @param franchiserCode 经销商编码
     * @param companyCode 公司编码
     * @param filialeOrgCode hr分公司组织代码
     * @param productCode 产品编码
     * @param priceTypeCode 价格类型编码
     * @return
     */
    ProductSettlePriceVo findFranchiseProductSettlePrice(String franchiserCode, String companyCode, String filialeOrgCode, String productCode, String priceTypeCode);

    /**
     * 样品酒获取产品价格
     * @param franchiserCode 经销商编码
     * @param companyCode 公司编码
     * @param filialeOrgCode hr分公司组织代码
     * @param productCode 产品编码
     * @param priceTypeCode 价格类型编码
     * @return
     */
    ProductSettlePriceVo findSampleWineSettlePrice(String franchiserCode, String companyCode, String filialeOrgCode, String productCode, String priceTypeCode);

    /**
     * 分页查询经销商产品
     * @param pageable 分页信息 queryCondition key-> franchiserCode 经销商编码、sdFilialeCode 分公司/办事处sd组织代码、filialeOrgCode hr分公司组织代码、materielCode 物料编码、materielName 物料名称、
     *                 productSaleCodeOrName 商品编码及名称（编码精确，名称模糊）、productGroupCode 产品组编码（精确）、productTypeCode 品类编码（精确，商品层级1）、productBrandCode 品牌编码（精确，商品层级2）、
     *                 seriesCode 系列编码（精确，商品层级3）、bigLevelCode 大类编码（精确，商品层级4）、smallLevelCode 细类编码（精确，商品层级5）、filterFrozen 是否过滤冻结状态商品（精确，boolean）、commonKeyWold 通用搜索关键词
     * @return
     */
    Page<FranchiseMaterielVo> findFranchiseMaterielPage(Pageable pageable);
    
    /**
     * 查询岗位经销商关系(根据岗位找经销商、或根据经销商找岗位)
     * @param franchiserCode 经销商编码
     * @param positionCode 岗位编码
     * @return
     */
    FranchiserPositonVo findFranchisePositionRelations(String franchiserCode, String positionCode);

    /**
     * 根据经销商编码和经销商用户角色编码查找经销商用户
     * @param franchiser
     * @param roleCode
     * @return
     */
    List<UserBasicInformationVo> findUserInfoByFranchiseAndRoleCode(String franchiser,List<String> roleCode);
}
