package com.chinayanghe.msp.mdm.rpc.org;



import java.util.List;
import java.util.Map;
import java.util.Set;

import com.chinayanghe.msp.mdm.enums.OrgBlockType;
import com.chinayanghe.msp.mdm.enums.OrgType;
import com.chinayanghe.msp.mdm.vo.org.OrgBasicInformationVo;
import com.chinayanghe.msp.mdm.vo.org.OrgComplilationVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

/**
 * Created by danDy on 2017/5/9.
 */
public interface OrgMessageService {
    /**
     * 根据组织编码获取组织下岗位编制信息
     * @param orgCode
     * @return
     */
    List<OrgComplilationVo> getOrgComlilationList(String orgCode);

    /**
     * 根据组织编码，数据权限，启用状态查询组织基本信息
     * @param orgCode
     * @param power "04"会查询所有下级组织，其他则没有，不能为null
     * @param enableStatus
     * @return
     */
    List<OrgBasicInformationVo>getOrgBasicInformationList(String orgCode,String power,Integer enableStatus);

    /**
     * 根据组织编码查询组织信息
     * @param orgCode
     * @return
     */
    OrgBasicInformationVo findByOrgCode(String orgCode);

    /**
     * 查找组织的组织树路径
     * @param orgCode 组织编码
     * @param positionCode 岗位编码 （优先组织编码）
     * @param orgTypes 截断组织类型（为null时查询为全路径）
     * @param orgBlockType 截断方式
     * @return
     */
    OrgBasicInformationVo findOrgPath(String orgCode, String positionCode,  OrgBlockType orgBlockType,OrgType... orgTypes );

    /**
     * 根据预算标识去查询组织信息
     * @param budgetFlag
     * @return
     * @deprecated 过时、情调分页接口 {@link OrgMessageService#findOrgPage(cn.com.bizunited.cp.common.pagination.Pageable)}
     */
    @Deprecated
    List<OrgBasicInformationVo>findByBudgetFlag(String budgetFlag);

    /**
     *
     * 如果当前岗位所在组织或组织层级在查找层级之上，则往下查找指定层级组织
     * 如果当前岗位所在组织或组织层级在查找层级之下，则往上查找指定层级组织
     * @param orgType 组织层级类型 必填
     * @param positionCode 岗位编码 可输
     * @param orgCode 组织编码 可输优先组织
     * @return
     */
    List<OrgBasicInformationVo> findOrgInfosByHierarchy(OrgType orgType, String positionCode, String orgCode);

    /**
     * 批量查询--》根据岗位编码、组织编码，查找指定层级的组织。
     * 如果当前岗位所在组织或组织层级在查找层级之上，则往下查找指定层级组织
     * 如果当前岗位所在组织或组织层级在查找层级之下，则往上查找指定层级组织
     * @param positionCodes 岗位编码 可输
     * @param orgCodes 组织编码 可输优先组织
     * @param orgType 组织层级类型 必填
     * @return key-->>输入组织编码或者输入岗位对应组织编码，value-->>获得到的组织
     */
    Map<String,List<OrgBasicInformationVo>> findOrgInfosByHierarchyBatch(Set<String> positionCodes, Set<String> orgCodes, OrgType... orgType);

    /**
     * 根据上级节点id查询同属这一组织的组织信息
     * @param parentId
     * @return
     */
    List<OrgBasicInformationVo> findByParentId(String parentId);

    /**
     * 查询组织code下的所有子组织编码（包含自己）
     * @param orgCode
     * @return
     */
    Set<String> findAllChildOrgsByCode(String orgCode);

    /**
     * 查询组织code下的所有子组织（包含自己）
     * @param orgCode
     * @return
     */
    List<OrgBasicInformationVo> findAllChildsByCode(String orgCode);

    /**
     * 分页查询组织信息
     * @param pageable cn.com.bizunited.cp.common.pagination.Pageable#queryCondition 说明-->orgName（ 组织名称 like）、orgCode （组织编码 eq）、orgNameOrCode  （组织编码或名称 like）、budgetFlag （预算标示 eq）、parentOrgCode(父组织编码，如果存在，只查询该组织下级组织)、
     *                 orgTypes(组织层级类型{@link com.chinayanghe.msp.mdm.enums.OrgType}集合or数组 eq)、orgTypeCodes(组织层级类型编码{@link com.chinayanghe.msp.mdm.enums.OrgType#orgHierarchyCode}集合or数组 eq)、sdOrgCodes(sd组织代码集合or数组，eq)、wildOrgCode 根据此参数查询这个组织下的所有自组织(不包含此组织)
     * @return
     */
    Page<OrgBasicInformationVo> findOrgPage(Pageable pageable);
    
    /**
     * 同步组织信息
     * @param vo
     */
    void synchronizOrgInfo(OrgBasicInformationVo vo);

    /**
     * 根据分管区域查找指定组织（由区县->市->省顺序查找，返回第一个组织）
     * 只查找parentOrgCode的下一层组织
     * @param parentOrgCode 上级组织
     * @param provinceCode 省级编码
     * @param cityCode 市级编码
     * @param countyCode 区级编码
     * @return
     */
    OrgBasicInformationVo findOrgByChargeArea(String parentOrgCode,String provinceCode,String cityCode,String countyCode);

}
