package com.chinayanghe.msp.mdm.vo.terminal.resp;

import com.chinayanghe.msp.mdm.enums.ActivitiState;
import com.chinayanghe.msp.mdm.enums.ChannelType;
import com.chinayanghe.msp.mdm.enums.EnableStatus;
import com.chinayanghe.msp.mdm.enums.TerminalType;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 终端分配岗位详细信息vo
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/11/15
 */
public class TerminalRPositionDetailInfoVo implements Serializable {

    private static final long serialVersionUID = -1973633070270808659L;

    /**
     * 分配岗位所属大区编码
     */
    private String regionCode;

    /**
     * 分配岗位所属大区名称
     */
    private String regionName;

    /**
     * 分配岗位所属分公司、办事处编码
     */
    private String filialeCode;

    /**
     * 分配岗位所属分公司、办事处名称
     */
    private String filialeName;

    /**
     * 分配岗位所属一级阿米巴编码
     */
    private String amibaLv1Code;

    /**
     * 分配岗位所属一级阿米巴名称
     */
    private String amibaLv1Name;

    /**
     * 分配岗位所属二级阿米巴编码
     */
    private String amibaLv2Code;

    /**
     * 分配岗位所属二级阿米巴名称
     */
    private String amibaLv2Name;

    /**
     * 终端编码
     */
    private String terminalCode;

    /**
     * 终端名称
     */
    private String terminalName;

    /**
     * 终端类型名称
     */
    private String terminalTypeName;

    /**
     * 终端类型编码
     * {@link TerminalType#code}
     */
    private String terminalTypeCode;

    /**
     * 终端渠道类型名称
     */
    private String terminalChannelName;

    /**
     * 终端渠道类型编码
     * {@link ChannelType#code}
     */
    private String terminalChannelCode;

    /**
     * 分配岗位编码
     */
    private String relationPositionCode;

    /**
     * 分配岗位名称
     */
    private String relationPositionName;

    /**
     * 分配业务员编码
     */
    private String relationUsername;

    /**
     * 分配业务员真实姓名
     */
    private String relationUserRealName;

    /**
     * 分配岗位所属组织编码
     */
    private String relationPositionOrgCode;

    /**
     * 分配岗位所属组织名称
     */
    private String relationPositionOrgName;

    /**
     * 分配岗位所属组织层级编码
     */
    private String relationPositionOrgHierarchyCode;

    /**
     * 分配岗位所属组织层级名称
     */
    private String relationPositionOrgHierarchyName;

    /**
     * 终端所属省编码
     */
    private String provinceCode;

    /**
     * 终端所属省名称
     */
    private String provinceName;

    /**
     * 终端所属市编码
     */
    private String cityCode;

    /**
     * 终端所属市名称
     */
    private String cityName;

    /**
     * 终端所属区/县编码
     */
    private String districtCode;

    /**
     * 终端所属区/县名称
     */
    private String districtName;

    /**
     * 终端详细地址
     */
    private String detailAddress;

    /**
     * 关键联系人
     */
    private String linkman;

    /**
     * 关键联系人电话
     */
    private String linkmanMobile;

    /**
     * 终端营业执照编码
     */
    private String terminalBizLicense;

    /**
     * 终端状态{@link EnableStatus}
     */
    private Integer terminalEnableStatus;

    /**
     * 终端状态描述
     */
    private String terminalEnableStatusDesc;

    /**
     * 分配关系状态{@link EnableStatus}
     */
    private Integer relationEnableStatus;

    /**
     * 分配关系状态描述
     */
    private String relationEnableStatusDesc;
    /**
     * 终端审批状态{@link ActivitiState}
     */
    private Integer terminalAuditStatus;

    /**
     * 终端审批状态描述
     */
    private String terminalAuditStatusDesc;

    /**
     * 终端创建时间
     */
    private Date createDate;

    /**
     * 终端经度
     */
    private BigDecimal longitude;
    /**
     * 终端纬度
     */
    private BigDecimal latitude;

    public String getRegionCode() {
        return regionCode;
    }

    public void setRegionCode(String regionCode) {
        this.regionCode = regionCode;
    }

    public String getRegionName() {
        return regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getFilialeCode() {
        return filialeCode;
    }

    public void setFilialeCode(String filialeCode) {
        this.filialeCode = filialeCode;
    }

    public String getFilialeName() {
        return filialeName;
    }

    public void setFilialeName(String filialeName) {
        this.filialeName = filialeName;
    }

    public String getAmibaLv1Code() {
        return amibaLv1Code;
    }

    public void setAmibaLv1Code(String amibaLv1Code) {
        this.amibaLv1Code = amibaLv1Code;
    }

    public String getAmibaLv1Name() {
        return amibaLv1Name;
    }

    public void setAmibaLv1Name(String amibaLv1Name) {
        this.amibaLv1Name = amibaLv1Name;
    }

    public String getAmibaLv2Code() {
        return amibaLv2Code;
    }

    public void setAmibaLv2Code(String amibaLv2Code) {
        this.amibaLv2Code = amibaLv2Code;
    }

    public String getAmibaLv2Name() {
        return amibaLv2Name;
    }

    public void setAmibaLv2Name(String amibaLv2Name) {
        this.amibaLv2Name = amibaLv2Name;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public String getTerminalName() {
        return terminalName;
    }

    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    public String getTerminalTypeName() {
        return terminalTypeName;
    }

    public void setTerminalTypeName(String terminalTypeName) {
        this.terminalTypeName = terminalTypeName;
    }

    public String getTerminalTypeCode() {
        return terminalTypeCode;
    }

    public void setTerminalTypeCode(String terminalTypeCode) {
        this.terminalTypeCode = terminalTypeCode;
    }

    public String getTerminalChannelName() {
        return terminalChannelName;
    }

    public void setTerminalChannelName(String terminalChannelName) {
        this.terminalChannelName = terminalChannelName;
    }

    public String getTerminalChannelCode() {
        return terminalChannelCode;
    }

    public void setTerminalChannelCode(String terminalChannelCode) {
        this.terminalChannelCode = terminalChannelCode;
    }

    public String getRelationPositionCode() {
        return relationPositionCode;
    }

    public void setRelationPositionCode(String relationPositionCode) {
        this.relationPositionCode = relationPositionCode;
    }

    public String getRelationPositionName() {
        return relationPositionName;
    }

    public void setRelationPositionName(String relationPositionName) {
        this.relationPositionName = relationPositionName;
    }

    public String getRelationUsername() {
        return relationUsername;
    }

    public void setRelationUsername(String relationUsername) {
        this.relationUsername = relationUsername;
    }

    public String getRelationUserRealName() {
        return relationUserRealName;
    }

    public void setRelationUserRealName(String relationUserRealName) {
        this.relationUserRealName = relationUserRealName;
    }

    public String getRelationPositionOrgCode() {
        return relationPositionOrgCode;
    }

    public void setRelationPositionOrgCode(String relationPositionOrgCode) {
        this.relationPositionOrgCode = relationPositionOrgCode;
    }

    public String getRelationPositionOrgName() {
        return relationPositionOrgName;
    }

    public void setRelationPositionOrgName(String relationPositionOrgName) {
        this.relationPositionOrgName = relationPositionOrgName;
    }

    public String getRelationPositionOrgHierarchyCode() {
        return relationPositionOrgHierarchyCode;
    }

    public void setRelationPositionOrgHierarchyCode(String relationPositionOrgHierarchyCode) {
        this.relationPositionOrgHierarchyCode = relationPositionOrgHierarchyCode;
    }

    public String getRelationPositionOrgHierarchyName() {
        return relationPositionOrgHierarchyName;
    }

    public void setRelationPositionOrgHierarchyName(String relationPositionOrgHierarchyName) {
        this.relationPositionOrgHierarchyName = relationPositionOrgHierarchyName;
    }

    public String getProvinceCode() {
        return provinceCode;
    }

    public void setProvinceCode(String provinceCode) {
        this.provinceCode = provinceCode;
    }

    public String getProvinceName() {
        return provinceName;
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    public String getCityCode() {
        return cityCode;
    }

    public void setCityCode(String cityCode) {
        this.cityCode = cityCode;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getDistrictCode() {
        return districtCode;
    }

    public void setDistrictCode(String districtCode) {
        this.districtCode = districtCode;
    }

    public String getDistrictName() {
        return districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getDetailAddress() {
        return detailAddress;
    }

    public void setDetailAddress(String detailAddress) {
        this.detailAddress = detailAddress;
    }

    public String getLinkman() {
        return linkman;
    }

    public void setLinkman(String linkman) {
        this.linkman = linkman;
    }

    public String getLinkmanMobile() {
        return linkmanMobile;
    }

    public void setLinkmanMobile(String linkmanMobile) {
        this.linkmanMobile = linkmanMobile;
    }

    public String getTerminalBizLicense() {
        return terminalBizLicense;
    }

    public void setTerminalBizLicense(String terminalBizLicense) {
        this.terminalBizLicense = terminalBizLicense;
    }

    public Integer getTerminalEnableStatus() {
        return terminalEnableStatus;
    }

    public void setTerminalEnableStatus(Integer terminalEnableStatus) {
        this.terminalEnableStatus = terminalEnableStatus;
    }

    public String getTerminalEnableStatusDesc() {
        return terminalEnableStatusDesc;
    }

    public void setTerminalEnableStatusDesc(String terminalEnableStatusDesc) {
        this.terminalEnableStatusDesc = terminalEnableStatusDesc;
    }

    public Integer getTerminalAuditStatus() {
        return terminalAuditStatus;
    }

    public void setTerminalAuditStatus(Integer terminalAuditStatus) {
        this.terminalAuditStatus = terminalAuditStatus;
    }

    public String getTerminalAuditStatusDesc() {
        return terminalAuditStatusDesc;
    }

    public void setTerminalAuditStatusDesc(String terminalAuditStatusDesc) {
        this.terminalAuditStatusDesc = terminalAuditStatusDesc;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public BigDecimal getLongitude() {
        return longitude;
    }

    public void setLongitude(BigDecimal longitude) {
        this.longitude = longitude;
    }

    public BigDecimal getLatitude() {
        return latitude;
    }

    public void setLatitude(BigDecimal latitude) {
        this.latitude = latitude;
    }

    public Integer getRelationEnableStatus() {
        return relationEnableStatus;
    }

    public void setRelationEnableStatus(Integer relationEnableStatus) {
        this.relationEnableStatus = relationEnableStatus;
    }

    public String getRelationEnableStatusDesc() {
        return relationEnableStatusDesc;
    }

    public void setRelationEnableStatusDesc(String relationEnableStatusDesc) {
        this.relationEnableStatusDesc = relationEnableStatusDesc;
    }
}
