package com.chinayanghe.msp.mdm.rpc.org;



import com.chinayanghe.msp.mdm.enums.OrgType;
import com.chinayanghe.msp.mdm.vo.org.OrgBasicInformationVo;
import com.chinayanghe.msp.mdm.vo.org.OrgComplilationVo;
import java.util.List;

/**
 * Created by danDy on 2017/5/9.
 */
public interface OrgMessageService {
    /**
     * 根据组织编码获取组织下岗位编制信息
     * @param orgCode
     * @return
     */
    List<OrgComplilationVo> getOrgComlilationList(String orgCode);

    /**
     * 根据组织编码，数据权限，启用状态查询组织基本信息
     * @param orgCode
     * @param power
     * @param enableStatus
     * @return
     */
    List<OrgBasicInformationVo>getOrgBasicInformationList(String orgCode,String power,Integer enableStatus);

    /**
     * 根据组织编码查询组织信息
     * @param orgCode
     * @return
     */
    OrgBasicInformationVo findByOrgCode(String orgCode);

    /**
     * 根据预算标识去查询组织信息
     * @param budgetFlag
     * @return
     */
    List<OrgBasicInformationVo>findByBudgetFlag(String budgetFlag);

    /**
     * 根据岗位编码、组织编码，查找指定层级的组织。
     * 如果当前岗位所在组织或组织层级在查找层级之上，则往下查找指定层级组织
     * 如果当前岗位所在组织或组织层级在查找层级之下，则往上查找指定层级组织
     * @param orgType 组织层级类型 必填
     * @param positionCode 岗位编码 可输
     * @param orgCode 组织编码 可输
     * @return
     */
    List<OrgBasicInformationVo> findOrgInfosByHierarchy(OrgType orgType, String positionCode, String orgCode);
}
