package com.chinayanghe.msp.mdm.rpc.terminal;

import java.util.Date;
import java.util.List;

import com.chinayanghe.msp.mdm.enums.ActivitiState;
import com.chinayanghe.msp.mdm.enums.ChannelType;
import com.chinayanghe.msp.mdm.enums.EnableStatus;
import com.chinayanghe.msp.mdm.enums.OptCode;
import com.chinayanghe.msp.mdm.enums.TerminalChannelType;
import com.chinayanghe.msp.mdm.enums.TerminalType;
import com.chinayanghe.msp.mdm.vo.terminal.TmRTermCustPosBGVo;
import com.chinayanghe.msp.mdm.vo.terminal.TmTerminalVo;
import com.chinayanghe.msp.mdm.vo.terminal.req.AddressVo;
import com.chinayanghe.msp.mdm.vo.terminal.req.TerminalAuditApplyVo;
import com.chinayanghe.msp.mdm.vo.terminal.req.TmTerminalApplyVo;
import com.chinayanghe.msp.mdm.vo.terminal.req.TmTerminalReqVo;
import com.chinayanghe.msp.mdm.vo.terminal.resp.TerminalAuditApplyRespVo;
import com.chinayanghe.msp.mdm.vo.terminal.resp.TerminalChannelTypeRatioRespVo;
import com.chinayanghe.msp.mdm.vo.terminal.resp.TerminalRPositionDetailInfoVo;
import com.chinayanghe.msp.mdm.vo.terminal.resp.TmTerminalRespVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

/**
 * Created by isshu on 2017/5/15.
 */
public interface TerminalRpcService {

    /**
     * 查询终端信息(参数全为非必须，全空则返回所有)（数据库）
     * @param terminalCode 终端编码
     * @param terminalName 终端名称
     * @param channelType 渠道类型
     * @param extChar1 营业执照编码
     * @param extChar10 身份证号
     * @param addressVos 省市区集合
     * @param extNumber1 是否专卖店 1 是 0 不是
     * @return
     * @deprecated 过时调用，请com.chinayanghe.msp.mdm.rpc.terminal.TerminalRpcService#getTmTerminals(cn.com.bizunited.cp.common.pagination.Pageable)
     */
    @Deprecated
    List<TmTerminalRespVo> getTmTerminals(String terminalCode, String terminalName,
                                          String channelType, String extChar1,
                                          String extChar10,
                                          List<AddressVo> addressVos,
                                          Integer extNumber1);

    /**
     * 分页查询终端信息
     * @param pageable queryCondition-->> terminalCode 终端编码 eq,terminalName 终端名称 like,channelType 渠道类型 eq,extChar1 营业执照编码 eq,extChar10 身份证号 eq
     *                 addressVos 省市区{@link com.chinayanghe.msp.mdm.vo.terminal.req.AddressVo 集合or数组 eq},terminalCodeOrName 终端编码或名称，extNumber1 是否为专卖店（1是，0不是）
     * @return
     */
    Page<TmTerminalRespVo> getTmTerminals(Pageable pageable);

    /**
     * 分公司--阿米巴--岗位联动查询终端基本信息不包含联系人和岗位关联关系，如果需要的话修改sql（分公司必传）(复杂条件走数据库)
     * @param keyWordLike 关键词模糊查询（目前是名称和地址）
     * @param branchCode 分公司编码（组织）
     * @param amoebaCode 阿米巴编码（组织）
     * @param positionCode 岗位编码
     * @param pageable
     * @return
     */
    Page<TmTerminalRespVo> getTmTerminalsLinkagePage(String keyWordLike,
                                              String branchCode,
                                              String amoebaCode,
                                              String positionCode,
                                              Pageable pageable);
    /**
     * 根据终端编码或是岗位编码查询终端岗位关系（数据库）
     * @param codeFlag 为1时，第二个参数code是终端编码。其他为岗位编码
     * @param code 终端编码或是岗位编码
     * @param relStatus 终端岗位关系状态（0启用 1停用）
     * @return
     */
    List<TmRTermCustPosBGVo> getTmRTermCustPosBGs(Integer codeFlag, String code, String relStatus);

    /**
     * 终端岗位关联
     * @param terminalCode 终端编码
     * @param positionCode 岗位编码
     */
    void relationTermPos(String terminalCode, String positionCode);

    /**
     * 新增或是修改申请（数据库）
     *（新增数据终端网点状态为新增申请，修改数据终端网点状态为修改申请）
     * 需要更新es中终端信息
     * @param tmTerminalVo
     * @param optCode 01：新增申请   02：修改申请
     * @return 正常返回终端id
     */
    String applySaveOrUpdate(TmTerminalReqVo tmTerminalVo, OptCode optCode);

    /**
     * 终端审批（数据库）
     * @param tmTerminalApplyVo
     * @return
     */
    String auditTerminal(TmTerminalApplyVo tmTerminalApplyVo);

    /**
     * 启停申请（数据库）
     * @param terminalCode 终端编码
     * @param extChar14 备注
     * @param updateDate 提交时间
     * @param updateName 提交人
     * @param positionCodeUp 更新岗位
     * @param optCode 操作
     * @return
     */
    String applyEnableOrNot(String terminalCode, String extChar14,
                            Date updateDate, String updateName,
                            String positionCodeUp,
                            OptCode optCode);

    /**
     * 按终端编码批量精确查询（es）
     * @param terminalCodes
     * @return
     */
    List<TmTerminalRespVo> findByTerminalCodes(String... terminalCodes);

    /**
     * 查询附近终端(es)
     * @param enableStatus 启用状态 0 启用， 1 停用(非必需)
     * @param latitude 纬度
     * @param longitude 经度
     * @param distance 距离范围（有默认值,单位默认为km）
     * @param terminalName 终端名称
     * @param keyWordLike 关键词模糊查询（目前是名称和地址）
     * @param pageable 分页信息queryCondition->( limitPosition[boolean 判断限制是否是分配给这个岗位的终端 默认true]、excludeTerminalCodes->排除某些终端编码[Iterable or array]、positionCode->分配岗位编码[为空时查询所有，不为空时查询分配给这个岗位的终端] 、
     *                 includeManagePositions[是否包含子组织岗位：如果岗位是管理岗位，则带出所在组织及以下组织岗位，非管理岗位只能带出自己 默认false])
     * @return
     */
    Page<TmTerminalRespVo> findNearTerminalPage(Integer enableStatus,
                                                double latitude,
                                                double longitude,
                                                Double distance,
                                                String terminalName,
                                                String keyWordLike,
                                                Pageable pageable);
    /**
     * 根据终端编码将数据库中的终端信息同步到es中(从数据库中加载终端信息)
     * @param terminalCode
     */
    void syncTerminalByCode(String terminalCode);

    /**
     * 根据关联岗位更新终端数据（需要验证该岗位是否有关联终端）
     * @param positionCode
     */
    void syncTerminalByPositionCode(String positionCode);
    //主要是eisp使用
    void syncTerminal(TmTerminalVo tmTerminalVo);
    /**
     * 根据终端编码将es中的终端删除
     * @param terminalCode
     */
    void deleteTerminalByCode(String terminalCode);

    /**
     * 删除所有终端相关数据
     * @param terminalCode
     */
    void deleteTerminalAllDataByCode(String terminalCode);
    /**
     * 修改时备份终端数据
     * @param terminalCode
     */
    void bakTerminalByCode(String terminalCode);
    //主要是eisp使用
    void bakTerminal(TmTerminalVo tmTerminalVo);

    /**
     * 从备份中拉取终端数据恢复（修改审批失败恢复修改之前的数据）
     * @param applyId
     * @param termEsId
     */
    void recoverTerminalByApply(String applyId, String termEsId);

    /**
     * 查询终端信息(es)
     * @param positionCode 终端分配岗位编码
     * @param terminalCode 终端编码
     * @param terminalName 终端名称
     * @param terminalAddress 终端地址
     * @param terminalType 终端类型  {@link TerminalType#code}
     * @param channelType 终端渠道类型  {@link TerminalChannelType#value}
     * @param includeManagePosition 是否包含管理岗位（岗位是管理岗位则包含管理岗位分配的终端）
     * @param forceIncludeSubOrg 强制包含岗位所在组织的子组织岗位分配的终端
     * @return
     */
    List<TmTerminalRespVo> findTerminalInfo(String positionCode, String terminalCode, String terminalName, String terminalAddress, String terminalType,String channelType,Boolean includeManagePosition,Boolean forceIncludeSubOrg);

    /**
     * 用于eisp端发起终端流程审批
     * @param terminalAuditApplyVo
     */
    void launchTerminalProcess(TerminalAuditApplyVo terminalAuditApplyVo);

    /**
     * 工作流回调
     * @param auditId 审批单号
     * @param activitiState 状态
     * @param activitiCode 工作流
     * @param jsonString 业务数据
     */
    void activitiCallBack(String auditId, ActivitiState activitiState, String activitiCode, String jsonString);

    /**
     * 提供给工作流获取查询每个版本的终端数据
     * @param auditId
     * @return
     */
    TmTerminalRespVo getTerminalForactivity(String auditId);

    /**
     * 查找终端信息(不搜索的条件可以为null)
     * @param enableStatus  终端状态 0-启用 (必传)
     * @param positionCode  岗位编码
     * @param orgCode       组织编码
     * @param startTime     开始时间
     * @param endTime       结束时间
     * @return
     */
    List<TmTerminalRespVo> findByLastVisitTimeAndEnableStatus(Integer enableStatus, String positionCode, String orgCode, Long startTime,Long endTime);

    /**
     * 根据岗位编码查询终端信息
     * @param positionCode
     * @return
     */
    List<TmTerminalRespVo> findTerminalByPositionCode(String positionCode);
    /**
     * 查询终端信息分页(es)
     * @param terminalName 终端名称
     * @param terminalCode 终端编码
     * @param startTime
     * @param endTime
     * @param pageable      分页参数
     * @return
     */
    Page<TmTerminalRespVo> findTerminalPage(String terminalName, String terminalCode, Long startTime, Long endTime, Pageable pageable);

    /**
     * es终端查询(通过岗位编码)
     * @param positionCode      岗位编码
     * @param auditType         审批类型（新增，修改，启，停）
     * @param auditStatus       数据审批状态
     * @param startTime         开始时间
     * @param endTime           结束时间
     * @param termName
     * @param termExt18
     * @param mainLinkMobile
     * @param searchFlag 1.终端名称和详细地址组合2.关键联系人和地址3.关键联系人和地址
     * @return
     */
    List<TmTerminalRespVo> findListByPositionCode(String positionCode, Integer auditType, Integer auditStatus, Long startTime,Long endTime,Integer searchFlag,
                                                  String termName,
                                                  String termExt18,
                                                  String mainLinkMobile);
    
    
    /**
     * 根据组织编码查找该组织下所有终端的渠道类型比例
     * @param orgCode
     * @return
     */
    TerminalChannelTypeRatioRespVo findAllTerminalByCurrOrgCode(String orgCode);

    /**
     * 通过岗位编码与状态查询
     * @param positionCode
     * @param relationState (0,启动 1,停用)
     * @return
     */
    List<TmRTermCustPosBGVo> findTmRTermByPosiAndState(String positionCode, String relationState);

    /**
     * 从数据库查询for终端校验
     * @param searchFlag 1.终端名称和详细地址组合2.关键联系人和地址3.关键联系人和终端名称
     * @param termName
     * @param termExt18
     * @param mainLinkMobile
     * @return
     */
    List<TmTerminalRespVo> findForValidateTerm(Integer searchFlag,
                                               String termName,
                                               String termExt18,
                                               String mainLinkMobile);

    /**
     * 分页查询岗位分配信息
     * @param pageable {@link Pageable#queryCondition}-->>{orgCode 搜索分配岗位所属组织 String}、{terminalName like String 终端名称}、{channelType eq String 渠道类型编码{@link ChannelType#code}}、
     *             {terminalType eq String 终端类型编码{@link TerminalType#code}}、{relationUser String 终端分配业务员 fullname like、username eq}、{provinceCode String 省编码 eq}、{cityCode String 市编码 eq}、{districtCode String 区、县编码 eq}、
     *             {detailAddress like String 详细地址}、{enableStatus eq Integer 启用禁用编码{@link EnableStatus#code}}、{createDateStart\createDateEnd 终端新增时间区间 between Date }
     * @return
     */
    Page<TerminalRPositionDetailInfoVo> findTerminalRPositionDetailInfoPage(Pageable pageable);
    
    /**
     * 终端流程查询
     * @param id
     * @return
     */
    TerminalAuditApplyRespVo findTerminalAuditById(String id);
}
