package com.chinayanghe.msp.mdm.enums;

import java.util.Arrays;
import java.util.List;

/**
 * SFA APP 角色
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/6/22
 */
public enum SFAAppRoles {

    SALE_ROLE("销售员角色","saleRole", Arrays.asList(OrgType.REGION),Arrays.asList("10002062","10002063","10051770","10002061","10050083","10005423"),AppRoleOrgDiffType.BOTH),

    INSPECTION_ROLE("督察员角色","inspectionRole",null,Arrays.asList("10002054"),AppRoleOrgDiffType.ORG_CODE),

    JUDGE_ROLE("秩序员角色","judgeRole",null,Arrays.asList("10002065"),AppRoleOrgDiffType.ORG_CODE),

    FRANCHISER_ROLE("经销商角色","franchiserRole",null,Arrays.asList("10101011"),AppRoleOrgDiffType.ORG_CODE)
    ;
    private String roleName;

    private String roleCode;

    private List<OrgType> orgTypes;

    private List<String> orgCodes;

    private AppRoleOrgDiffType diffType;

    public String getRoleName() {
        return roleName;
    }

    public String getRoleCode() {
        return roleCode;
    }

    public List<OrgType> getOrgTypes() {
        return orgTypes;
    }

    public List<String> getOrgCodes() {
        return orgCodes;
    }

    public AppRoleOrgDiffType getDiffType() {
        return diffType;
    }

    SFAAppRoles(String roleName, String roleCode, List<OrgType> orgTypes, List<String> orgCodes, AppRoleOrgDiffType diffType) {
        this.roleName = roleName;
        this.roleCode = roleCode;
        this.orgTypes = orgTypes;
        this.orgCodes = orgCodes;
        this.diffType = diffType;
    }

    public static final String SFA_POSITION_ROLE_SYNC_QUEUE_NAME = "sfa.role.position.sync.queue";

    public enum AppRoleOrgDiffType{
        ORG_TYPE,ORG_CODE,BOTH
    }
}
