/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.msp.mdm.asserts;

import com.chinayanghe.msp.mdm.constant.ExceptionType;
import com.chinayanghe.msp.mdm.exception.BusinessException;
import java.util.Collection;
import java.util.Map;

public class SystemAsserts {
    private SystemAsserts() {
    }

    public static void isTrue(boolean expression) {
        SystemAsserts.isTrue(expression, "\u8868\u8fbe\u5f0f\u503c\u5fc5\u987b\u4e3atrue", new Object[0]);
    }

    public static void isTrue(boolean expression, String msg, Object ... args) {
        if (!expression) {
            String exmsg = String.format(msg, args);
            throw new BusinessException(exmsg);
        }
    }

    public static void isTrue(boolean expression, ExceptionType exceptionType, String extMsg) {
        if (!expression) {
            String exmsg = String.valueOf(exceptionType != null ? exceptionType.getDesc() : "") + extMsg;
            throw new BusinessException(exmsg);
        }
    }

    public static void notNull(Object object) {
        SystemAsserts.notNull(object, "\u53c2\u6570\u4e0d\u80fd\u4e3anull", new Object[0]);
    }

    public static void notNull(Object object, String msg, Object ... args) {
        if (object == null) {
            String exmsg = String.format(msg, args);
            throw new BusinessException(exmsg);
        }
    }

    public static void notEmpty(Object[] arr) {
        SystemAsserts.notEmpty(arr, "\u53c2\u6570\u4e0d\u80fd\u4e3aempty", new Object[0]);
    }

    public static void notEmpty(Object[] arr, String msg, Object ... args) {
        if (arr == null || arr.length == 0) {
            String exmsg = String.format(msg, args);
            throw new BusinessException(exmsg);
        }
    }

    public static void notEmpty(Collection<?> collection) {
        SystemAsserts.notEmpty(collection, "\u53c2\u6570\u4e0d\u80fd\u4e3aempty", new Object[0]);
    }

    public static void notEmpty(Collection<?> collection, String msg, Object ... args) {
        if (collection == null || collection.isEmpty()) {
            String exmsg = String.format(msg, args);
            throw new BusinessException(exmsg);
        }
    }

    public static void notEmpty(Map<?, ?> map) {
        SystemAsserts.notEmpty(map, "\u53c2\u6570\u4e0d\u80fd\u4e3aempty", new Object[0]);
    }

    public static void notEmpty(Map<?, ?> map, String msg, Object ... args) {
        if (map == null || map.isEmpty()) {
            String exmsg = String.format(msg, args);
            throw new BusinessException(exmsg);
        }
    }

    public static void hasText(String text, String msg, Object ... args) {
        if (text == null || "".equals(text)) {
            String exmsg = String.format(msg, args);
            throw new BusinessException(exmsg);
        }
    }

    public static void hasText(String text) {
        SystemAsserts.hasText(text, "\u6587\u672c\u4e0d\u80fd\u4e3a\u7a7a\u767d", new Object[0]);
    }
}

