package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
* @author zhangqiang:
* @version 创建时间：2017年11月14日 下午3:37:57
* portal主数据同步
*/
public enum MasterDataSyncMethod {
	user_sync("1","用户主数据"),
	position_sync("2","岗位主数据"),
	org_sync("3","组织主数据"),
	user_position_sync("4","人岗关系"),
	role_sync("5","角色主数据"),
	role_master_sync("6","角色与主数据关系"),
	function_sync("7","菜单同步"),
	role_function_sync("8","角色和菜单关联关系同步");
	
	private String method;
	
	private String desc;
	private static Map<String, String> map = null;
	
	static {
		map = new HashMap<>();
		MasterDataSyncMethod[] values = MasterDataSyncMethod.values();
		for(MasterDataSyncMethod v :values){
			map.put(v.getMethod(), v.getDesc());
		}
	}

	public static String getMethodDesc(String method){
		return map.get(method);
	}
	
	public String getMethod() {
		return method;
	}

	public void setMethod(String method) {
		this.method = method;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	private MasterDataSyncMethod(String method, String desc) {
		this.method = method;
		this.desc = desc;
	}

	private MasterDataSyncMethod() {
	}

}
