package com.chinayanghe.msp.mdm.rpc.user;

import java.util.List;
import java.util.Set;

import com.chinayanghe.msp.mdm.vo.user.UserBasicInformationVo;
import com.chinayanghe.msp.mdm.vo.user.UserMainPositionVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

/**
 * Created by Administrator on 2017/5/3 0003.
 */
public interface UserBasicInformationService  {
    /**
     * 获取人员信息.
     * <p>根据登录账号、人员编码和人员启用状态获取有效的人员集合信息
     * @author grover
     * @return 人员集合
     * @throws com.chinayanghe.msp.mdm.exception.BusinessException 运行过程中可能出现的异常
     */
    public List<UserBasicInformationVo> getUserByPernr(String userName, String pernr);

    /**
     * 获取人员信息
     * @param userName 用户名
     * @param pernr 用户编码
     * @param realName 真实姓名
     * @return
     */
    List<UserBasicInformationVo> findUserInfos(String userName, String pernr,String realName);

    /**
     * 获取当前登陆人所在的分公司下的所有员工
     * @param pageable 分页信息 queryCondition key->loginPosCode(登录人职位编码),searchUserCode(人员编码),searchUserName(人员名称),searchPositionName(岗位名称),searchPositionCode(岗位编码)
     * @return
     */
    Page<UserBasicInformationVo> findSubUserByPosOrUser(Pageable pageable);

    /**
     * 查询所有用户信息
     * @param pageable 分页信息 queryCondition key->searchWord(搜索关键字)
     * @return
     */
    Page<UserBasicInformationVo> findAllUserInfos(Pageable pageable);

    /**
     * 获取当前登陆人所在的分公司下的所有员工包含岗位信息
     * @param pageable 分页信息 queryCondition key->loginPosCode(登录人职位编码),searchUserCode(人员编码),searchUserName(人员名称),searchPositionName(岗位名称),searchPositionCode(岗位编码),justSFAPosition(是否只查询sfa岗位角色)
     * @return
     */
    Page<UserBasicInformationVo> findSubUserByPosOrUserWithPositionInfo(Pageable pageable);

    /**
     * 获取当前登陆人所在的组织下或指定组织的所有员工包含岗位信息（优先查岗位）(如果登录岗位是管理岗位，则带出所在组织及以下组织岗位人员，非管理岗位只能带出自己)
     * @param pageable 分页信息 queryCondition key->loginPosCode(登录人职位编码),searchUserCode(人员编码),searchUserName(人员名称),searchPositionName(岗位名称),searchPositionCode(岗位编码),justSFAPosition(是否只查询sfa岗位角色),
     *                 commonSearchValue(人员名称或岗位名称 like,人员编码或岗位编码 eq),orgCode(组织编码)
     * @return
     */
    Page<UserBasicInformationVo> findSubOrgUsersByPosOrUserWithPositionInfo(Pageable pageable);

//    /**
//     * 检查用户名密码
//     * @param userNameOrPernr 用户名或者人员编码
//     * @param sourcePassword 密码（未加密）
//     * @return
//     */
//    UserBasicInformationVo checkUserPassword(String userNameOrPernr,String sourcePassword);

    /**
     * 检查用户名密码
     * @param userNameOrPernr 用户名或者人员编码
     * @param sourcePassword 密码（未加密）
     * @param justSfaPosition 是否只包含移动访销
     * @return
     */
    UserBasicInformationVo checkUserPassword(String userNameOrPernr,String sourcePassword,Boolean justSfaPosition);

    /**
     * 查找用户
     * @param userNameOrPernr eq
     * @param justSfaPosition 是否只包含移动访销
     * @return
     */
    UserBasicInformationVo findByUserNameOrPernr(String userNameOrPernr, Boolean justSfaPosition);

    /**
     * 更新用户密码
     * @param userNameOrPernr
     * @param newSourcePassword
     * @param oldSourcePassword
     * @param justSfaPosition 是否只包含移动访销
     */
    void updatePassword(String userNameOrPernr,String newSourcePassword,String oldSourcePassword, Boolean justSfaPosition);

    /**
     * 强制更新用户密码
     * @param userNameOrPernr
     * @param newSourcePassword
     * @param justSfaPosition 是否只包含移动访销
     */
    void updatePasswordForce(String userNameOrPernr,String newSourcePassword, Boolean justSfaPosition);

    /**
     * 绑定用户手机号
     * @param mobile
     * @param userCode
     */
    void bindUserMobile(String mobile,String userCode);

    /**
     * 绑定用户手机号
     * @param mobile
     * @param userCode
     * @param syncSAP 是否同步sap
     */
    void bindUserMobile(String mobile,String userCode,boolean syncSAP);

    /**
     * 根据岗位编码查询人员
     * @param positionCode
     * @return
     */
    UserBasicInformationVo findByPositionCode(String positionCode);

    /**
     * 查询组织下所有岗位的人员
     * @param positionCodes
     * @return
     */
    List<UserBasicInformationVo> finByPositionCodes(Set<String> positionCodes);

    /**
     * 检查用户名密码 返回用户信息包含岗位和角色信息
     * 用户名类型
     * (1)正常账号如09004127
     * (2)账号对呀字母如lidejun
     * (3)经销商账号 去前面所有0 如000256  --> 256  
     * 匹配时 数据库username去前所有0与参数去前所有0匹配
     * @param userName
     * @param sourcePassword
     * @return
     */
    UserBasicInformationVo findUserInfoByUserPassword(String userName,String sourcePassword);

    /**
     * 工作流H5页面查询
     * @param userName
     * @param fullName
     * @return
     */
	public List<UserMainPositionVo> getUserByPernrOrFullName(String userName, String fullName);
}
