package com.chinayanghe.msp.mdm.exception;

import com.chinayanghe.msp.mdm.constant.ExceptionType;

/**
 * 业务异常，继承于RuntimeException<br>
 * 使用场景：<br>
 * 在业务操作中，如果操作错误，想回滚操作数据时，可以使用BusinessExcepiton
 * @author isshu
 */
public class BusinessException extends RuntimeException {
	private static final long serialVersionUID = 1L;

	/**
	 * 当code = 1000时，表示异常信息直接展示给用户看（适配手机端)
	 */
	private int code;

	//单独使用，通常封装1000code
	public BusinessException(String message, int code){

		super(message);
		this.code = code;
	}
	public BusinessException(ExceptionType exceptionType){

		super(exceptionType.getDesc());
		this.code = exceptionType.getCode();
	}
	public BusinessException(ExceptionType exceptionType, String extMsg){

		super(exceptionType.getDesc()+extMsg);
		this.code = exceptionType.getCode();
	}
	public BusinessException(String message) {
		super(message);
	}

	public BusinessException(Throwable cause) {
		super(cause);
	}

	public BusinessException(String message, Throwable cause) {
		super(message, cause);
	}

	public int getCode() {
		return code;
	}

	public void setCode(int code) {
		this.code = code;
	}
}
