package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/7/3
 */
public enum TerminalChannelType {
    //传统
    HOTEL("11","酒店"),
    MARKET("12","商超"),
    STORE("13","烟酒店"),
    ESHOP("14","电商"),
    @Deprecated
    HOTEL_STORE("15","酒店、烟酒店"),
    @Deprecated
    MARKET_STORE("16","商超、烟酒店"),
    @Deprecated
    HOTEL_MARKET_STORE("17","酒店、商超、烟酒店"),

    //团购
    @Deprecated
    GROUP_PURCHASE("21","专业团购商"),
    @Deprecated
    BIG_GROUP_PURCHASE("22","大型专业团购商"),
    @Deprecated
    NORMAL_GROUP_PURCHASE("23","常规专业团购商"),
    @Deprecated
    SPECIAL_GROUP_PURCHASE("24","特约烟酒店团购商"),
    //直销
    //新型
    @Deprecated
    GAS_STATION_STORE("41","加油站便利店"),
    @Deprecated
    COMMERCE("42", "电商"),
    @Deprecated
    TAX_FREE_STORE("43","免税店"),

    GROUP_PURCHASE_NEW("50","团购"),

    OTHER("60","其他渠道");

//    STORE_OLD("12", "商超渠道"),
//    CIRCULATION_OLD("10", "流通渠道"),
//    STORE("store", "商超"),
//    ORDINARY("ordinary", "普通"),
//    CIRCULATION("circulation", "流通"),
//    NOT_FOR_SALE("not_for_sale", "非卖品"),
//    JUDGE("judge", "品鉴"),
//    COMMERCE("commerce", "电商"),
//    OTHER("other", "其他"),
//    HOTEL("hotel", "酒店"),
//    TEST_OLD("13", "test渠道");

    private String value;

    private String desc;

    private static Map<String,TerminalChannelType> map = null;

    TerminalChannelType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static String fromValue2Desc(String value){
        TerminalChannelType terminalChannelType = fromValue2ChannelType(value);
        return terminalChannelType==null?null:terminalChannelType.desc;
    }

    public static TerminalChannelType fromValue2ChannelType(String value){
        if (map==null){
            map = new HashMap<>();
            TerminalChannelType[] values = TerminalChannelType.values();
            for (TerminalChannelType type :values){
                map.put(type.getValue(),type);
            }
        }
        return map.get(value);
    }

}
