package com.chinayanghe.msp.mdm.rpc.terminal;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.enums.OptCode;
import com.chinayanghe.msp.mdm.vo.terminal.*;

import java.util.Date;
import java.util.List;

/**
 * Created by isshu on 2017/5/15.
 */
public interface TerminalRpcService {

    /**
     * 查询终端信息(参数全为非必须，全空则返回所有)
     * @param terminalCode 终端编码
     * @param terminalName 终端名称
     * @param channelType 渠道类型
     * @param extChar1 营业执照编码
     * @param extChar10 身份证号
     * @param addressVos 省市区集合
     * @return
     */
    List<TmTerminalVo> getTmTerminals(String terminalCode, String terminalName,
                                      String channelType, String extChar1,
                                      String extChar10,
                                      List<AddressVo> addressVos);

    /**
     * 根据终端编码或是岗位编码查询终端岗位关系
     * @param codeFlag 为1时，第二个参数code是终端编码。其他为岗位编码
     * @param code 终端编码或是岗位编码
     * @param relStatus 终端岗位关系（01：认领待审核  Enable：正常可用     Disable：停用）
     * @return
     */
    List<TmRTermCustPosBGVo> getTmRTermCustPosBGs(Integer codeFlag, String code, String relStatus);

    /**
     * 新增或是修改申请（新增数据终端网点状态为新增申请，修改数据终端网点状态为修改申请）
     * @param tmTerminalVo
     * @param optCode 01：新增申请   02：修改申请
     * @return 正常返回终端id
     */
    String applySaveOrUpdate(TmTerminalVo2 tmTerminalVo, OptCode optCode);

    /**
     * 终端审批
     * @param tmTerminalApplyVo
     * @return
     */
    String auditTerminal(TmTerminalApplyVo tmTerminalApplyVo);

    /**
     * 启停申请
     * @param terminalCode 终端编码
     * @param extChar14 备注
     * @param updateDate 提交时间
     * @param updateName 提交人
     * @param positionCodeUp 更新岗位
     * @param optCode 操作
     * @return
     */
    String applyEnableOrNot(String terminalCode, String extChar14,
                            Date updateDate, String updateName,
                            String positionCodeUp,
                            OptCode optCode);

    /**
     * 查询附近终端
     * @param enableStatus 启用状态 0 启用， 1 停用
     * @param latitude 纬度
     * @param longitude 经度
     * @param distance 距离范围（有默认值,单位默认为km）
     * @param pageable 分页信息
     * @return
     */
    Page<TmTerminalVo> findNearTerminalPage(Integer enableStatus,
                                            double latitude,
                                            double longitude,
                                            Double distance,
                                            Pageable pageable);

    /**
     * 查询终端信息
     * @param positionCode 终端分配岗位编码
     * @param terminalCode 终端编码
     * @param terminalName 终端名称
     * @param terminalAddress 终端地址
     * @param terminalType 终端类型  01：核心  02：非核心
     * @return
     */
    List<TmTerminalVo> findTerminalInfo(String positionCode,String terminalCode,String terminalName,String terminalAddress,String terminalType);
}
