package com.chinayanghe.msp.mdm.rpc.position;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.vo.position.PositionInformationVo;
import java.util.List;

/**
 * Created by danDy on 2017/4/27.
 */
public interface PositionInformationService  {
    /**
     * 根据岗位编码，数据权限，启用状态查询岗位基本信息
     * @param positionCode
     * @param power "04":要,"05":不要
     * @param enableStatus 0:启用,1:停用,可以不填
     * @return
     * @throws Exception
     */
    public List<PositionInformationVo> getPositionMessage(String positionCode, String power, Integer enableStatus);

    /**
     * 根据当前组织查询当前组织以及其子组织下的所有岗位
     * @param orgCode
     * @param pageable
     * @param enableStatus 0:启用,1:停用
     * @return
     */
    Page<PositionInformationVo> findAllPositionByCurrOrg(String orgCode, Integer enableStatus, Pageable pageable);
}
