package com.chinayanghe.msp.mdm.rpc.user;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.vo.user.UserBasicInformationVo;

import java.util.List;

/**
 * Created by Administrator on 2017/5/3 0003.
 */
public interface UserBasicInformationService  {
    /**
     * 获取人员信息.
     * <p>根据登录账号、人员编码和人员启用状态获取有效的人员集合信息
     * @author grover
     * @return 人员集合
     * @throws com.chinayanghe.msp.mdm.exception.BusinessException 运行过程中可能出现的异常
     */
    public List<UserBasicInformationVo> getUserByPernr(String userName, String pernr);

    /**
     * 获取当前登陆人所在的分公司下的所有员工
     * @param pageable 分页信息 queryCondition key->loginPosCode(登录人职位编码),searchUserCode(人员编码),searchUserName(人员名称),searchPositionName(岗位名称),searchPositionCode(岗位编码)
     * @return
     */
    Page<UserBasicInformationVo> findSubUserByPosOrUser(Pageable pageable);

    /**
     * 获取当前登陆人所在的分公司下的所有员工包含岗位信息
     * @param pageable 分页信息 queryCondition key->loginPosCode(登录人职位编码),searchUserCode(人员编码),searchUserName(人员名称),searchPositionName(岗位名称),searchPositionCode(岗位编码)
     * @return
     */
    Page<UserBasicInformationVo> findSubUserByPosOrUserWithPositionInfo(Pageable pageable);

//    /**
//     * 检查用户名密码
//     * @param userNameOrPernr 用户名或者人员编码
//     * @param sourcePassword 密码（未加密）
//     * @return
//     */
//    UserBasicInformationVo checkUserPassword(String userNameOrPernr,String sourcePassword);

    /**
     * 检查用户名密码
     * @param userNameOrPernr 用户名或者人员编码
     * @param sourcePassword 密码（未加密）
     * @param justSfaPosition 是否只包含移动访销
     * @return
     */
    UserBasicInformationVo checkUserPassword(String userNameOrPernr,String sourcePassword,Boolean justSfaPosition);

    /**
     * 查找用户
     * @param userNameOrPernr eq
     * @param justSfaPosition 是否只包含移动访销
     * @return
     */
    UserBasicInformationVo findByUserNameOrPernr(String userNameOrPernr, Boolean justSfaPosition);

    /**
     * 更新用户密码
     * @param userNameOrPernr
     * @param newSourcePassword
     * @param oldSourcePassword
     * @param justSfaPosition 是否只包含移动访销
     */
    void updatePassword(String userNameOrPernr,String newSourcePassword,String oldSourcePassword, Boolean justSfaPosition);

    /**
     * 强制更新用户密码
     * @param userNameOrPernr
     * @param newSourcePassword
     * @param justSfaPosition 是否只包含移动访销
     */
    void updatePasswordForce(String userNameOrPernr,String newSourcePassword, Boolean justSfaPosition);

    /**
     * 绑定用户手机号
     * @param mobile
     * @param userCode
     */
    void bindUserMobile(String mobile,String userCode);

    /**
     * 根据岗位编码查询人员
     * @param positionCode
     * @return
     */
    UserBasicInformationVo findByPositionCode(String positionCode);
}
