package com.chinayanghe.msp.mdm.rpc.position;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.vo.position.PositionInformationVo;
import java.util.List;

/**
 * Created by danDy on 2017/4/27.
 */
public interface PositionInformationService  {
    /**
     * 根据岗位编码，数据权限，启用状态查询岗位基本信息
     * @param positionCode
     * @param power "04":要,"05":不要
     * @param enableStatus 0:启用,1:停用,可以不填
     * @return
     * @throws Exception
     */
    public List<PositionInformationVo> getPositionMessage(String positionCode, String power, Integer enableStatus);

    /**
     * 根据当前组织查询当前组织以及其子组织下的所有岗位
     * @param orgCode
     * @param pageable
     * @param enableStatus 0:启用,1:停用
     * @return
     */
    Page<PositionInformationVo> findAllPositionByCurrOrg(String orgCode, Integer enableStatus, Pageable pageable);

    /**
     * 根据当前组织查询当前组织以及其子组织下的所有岗位(没分页)
     * @param orgCode
     * @param enableStatus 0:启用,1:停用
     * @return
     */
    List<PositionInformationVo> findAllPositionByCurrOrg(String orgCode, Integer enableStatus);

    /**
     * 根据当前岗位编码查询所在组织及所有下级组织岗位（）
     * @param positionCode 当前岗位编码
     * @param justManage 为true时，如果不是管理岗位，则只返回自己，为管理岗位时返回所有下级岗位；为false时这没有这一限制
     * @return
     */
    List<PositionInformationVo> findAllPositionByCurrPosition(String positionCode,boolean justManage);

    /**
     * 根据岗位编码获取岗位信息
     * @param positionCode
     * @return
     */
    PositionInformationVo findPositionByCode(String positionCode);

    /**
     * 根据组织id和是否是岗位管理者查询岗位
     * @param orgId 必输
     * @param administration 可输
     * @return
     */
    List<PositionInformationVo> findByOrgIdAndAdministation(String orgId,String administration);

    /**
     * 查询当前组织下的岗位
     * @param orgCode
     * @return
     */
    List<PositionInformationVo> findPositionsByOrgCode(String orgCode);
}
