package com.chinayanghe.msp.mdm.rpc.user;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.vo.user.UserBasicInformationVo;

import java.util.List;

/**
 * Created by Administrator on 2017/5/3 0003.
 */
public interface UserBasicInformationService  {
    /**
     * 获取人员信息.
     * <p>根据登录账号、人员编码和人员启用状态获取有效的人员集合信息
     * @author grover
     * @return 人员集合
     * @throws com.chinayanghe.msp.mdm.exception.BusinessException 运行过程中可能出现的异常
     */
    public List<UserBasicInformationVo> getUserByPernr(String userName, String pernr);

    /**
     * 获取当前登陆人所在的分公司下的所有员工
     * @param posCode 职位编码
     * @param userName 登陆人
     * @param pageable 分页信息
     * @return
     */
    Page<UserBasicInformationVo> findSubUserByPosOrUser(String posCode, String userName, Pageable pageable);
}
