package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/7/3
 */
public enum TerminalChannelType {

    STORE_OLD("12", "商超渠道"),
    CIRCULATION_OLD("10", "流通渠道"),
    STORE("store", "商超"),
    ORDINARY("ordinary", "普通"),
    CIRCULATION("circulation", "流通"),
    NOT_FOR_SALE("not_for_sale", "非卖品"),
    JUDGE("judge", "品鉴"),
    COMMERCE("commerce", "电商"),
    OTHER("other", "其他"),
    HOTEL("hotel", "酒店"),
    TEST_OLD("13", "test渠道");

    private String value;

    private String desc;

    private static Map<String,String> map = null;

    TerminalChannelType(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public String getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    public static String fromValue2Desc(String value){
        if (map==null){
            map = new HashMap<>();
            TerminalChannelType[] values = TerminalChannelType.values();
            for (TerminalChannelType type :values){
                map.put(type.getValue(),type.getValue());
            }
        }
        return map.get(value);
    }

}
