package com.chinayanghe.msp.mdm.rpc.product;


import com.chinayanghe.msp.mdm.vo.product.ProductHierarchySimpleVo;
import com.chinayanghe.msp.mdm.vo.product.ProductLevelVo;
import com.chinayanghe.msp.mdm.vo.product.ProductVo;

import java.util.List;

/**
 * 物料层级保存更新
 * @author guof.xi
 * @usage
 * @reviewer
 * @since 2017/4/26
 */
public interface ProductRpcService {


    /**
     * 根据产品编码查询产品所有层级信息
     * @param productCode
     * @return
     * @throws Exception
     */
    List<ProductVo> findProductInfo(String productCode) throws Exception;

    /**
     * 查询所有商品层级信息（已包含层级父子关系）
     * @return
     */
    List<ProductHierarchySimpleVo> findAllProductHierarchies();

    /**
     * 查询所有商品层级信息
     * @return
     */
    List<ProductLevelVo> findAllProductLevel();
}
