package com.chinayanghe.msp.mdm.rpc.terminal;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.enums.ActivitiState;
import com.chinayanghe.msp.mdm.enums.OptCode;
import com.chinayanghe.msp.mdm.vo.terminal.*;
import com.chinayanghe.msp.mdm.vo.terminal.req.AddressVo;
import com.chinayanghe.msp.mdm.vo.terminal.req.TmTerminalApplyVo;
import com.chinayanghe.msp.mdm.vo.terminal.req.TmTerminalReqVo;
import com.chinayanghe.msp.mdm.vo.terminal.resp.TmTerminalRespVo;

import java.util.Date;
import java.util.List;

/**
 * Created by isshu on 2017/5/15.
 */
public interface TerminalRpcService {

    /**
     * 查询终端信息(参数全为非必须，全空则返回所有)（数据库）
     * @param terminalCode 终端编码
     * @param terminalName 终端名称
     * @param channelType 渠道类型
     * @param extChar1 营业执照编码
     * @param extChar10 身份证号
     * @param addressVos 省市区集合
     * @return
     */
    List<TmTerminalRespVo> getTmTerminals(String terminalCode, String terminalName,
                                          String channelType, String extChar1,
                                          String extChar10,
                                          List<AddressVo> addressVos);

    /**
     * 分公司--阿米巴--岗位联动查询终端基本信息不包含联系人和岗位关联关系，如果需要的话修改sql（分公司必传）(复杂条件走数据库)
     * @param keyWordLike 关键词模糊查询（目前是名称和地址）
     * @param branchCode 分公司编码（组织）
     * @param amoebaCode 阿米巴编码（组织）
     * @param positionCode 岗位编码
     * @param pageable
     * @return
     */
    Page<TmTerminalRespVo> getTmTerminalsLinkagePage(String keyWordLike,
                                              String branchCode,
                                              String amoebaCode,
                                              String positionCode,
                                              Pageable pageable);
    /**
     * 根据终端编码或是岗位编码查询终端岗位关系（数据库）
     * @param codeFlag 为1时，第二个参数code是终端编码。其他为岗位编码
     * @param code 终端编码或是岗位编码
     * @param relStatus 终端岗位关系状态（0启用 1停用）
     * @return
     */
    List<TmRTermCustPosBGVo> getTmRTermCustPosBGs(Integer codeFlag, String code, String relStatus);

    /**
     * 终端岗位关联
     * @param terminalCode 终端编码
     * @param positionCode 岗位编码
     */
    void relationTermPos(String terminalCode, String positionCode);

    /**
     * 新增或是修改申请（数据库）
     *（新增数据终端网点状态为新增申请，修改数据终端网点状态为修改申请）
     * 需要更新es中终端信息
     * @param tmTerminalVo
     * @param optCode 01：新增申请   02：修改申请
     * @return 正常返回终端id
     */
    String applySaveOrUpdate(TmTerminalReqVo tmTerminalVo, OptCode optCode);

    /**
     * 终端审批（数据库）
     * @param tmTerminalApplyVo
     * @return
     */
    String auditTerminal(TmTerminalApplyVo tmTerminalApplyVo);

    /**
     * 启停申请（数据库）
     * @param terminalCode 终端编码
     * @param extChar14 备注
     * @param updateDate 提交时间
     * @param updateName 提交人
     * @param positionCodeUp 更新岗位
     * @param optCode 操作
     * @return
     */
    String applyEnableOrNot(String terminalCode, String extChar14,
                            Date updateDate, String updateName,
                            String positionCodeUp,
                            OptCode optCode);

    /**
     * 按终端编码批量精确查询（es）
     * @param terminalCodes
     * @return
     */
    List<TmTerminalRespVo> findByTerminalCodes(String... terminalCodes);

    /**
     * 查询附近终端(es)
     * @param enableStatus 启用状态 0 启用， 1 停用(非必需)
     * @param latitude 纬度
     * @param longitude 经度
     * @param distance 距离范围（有默认值,单位默认为km）
     * @param terminalName 终端名称
     * @param keyWordLike 关键词模糊查询（目前是名称和地址）
     * @param pageable 分页信息queryCondition->( limitPosition[boolean 判断限制是否是分配给这个岗位的终端 默认true]、excludeTerminalCodes->排除某些终端编码[Iterable or array]、positionCode->分配岗位编码[为空时查询所有，不为空时查询分配给这个岗位的终端] 、
     *                 includeManagePositions[是否包含子组织岗位：如果岗位是管理岗位，则带出所在组织及以下组织岗位，非管理岗位只能带出自己 默认false])
     * @return
     */
    Page<TmTerminalRespVo> findNearTerminalPage(Integer enableStatus,
                                                double latitude,
                                                double longitude,
                                                Double distance,
                                                String terminalName,
                                                String keyWordLike,
                                                Pageable pageable);
    /**
     * 根据终端编码将数据库中的终端信息同步到es中(从数据库中加载终端信息)
     * @param terminalCode
     */
    void syncTerminalByCode(String terminalCode);
    /**
     * 根据终端编码将es中的终端删除
     * @param terminalCode
     */
    void deleteTerminalByCode(String terminalCode);

    /**
     * 修改是备份终端数据
     * @param terminalCode
     */
    void bakTerminalByCode(String terminalCode);

    /**
     * 从备份中拉取终端数据恢复（修改审批失败恢复修改之前的数据）
     * @param terminalCode
     */
    void recoverTerminalByCode(String terminalCode);

    /**
     * 查询终端信息(es)
     * @param positionCode 终端分配岗位编码
     * @param terminalCode 终端编码
     * @param terminalName 终端名称
     * @param terminalAddress 终端地址
     * @param terminalType 终端类型  01：核心  02：非核心
     * @return
     */
    List<TmTerminalRespVo> findTerminalInfo(String positionCode, String terminalCode, String terminalName, String terminalAddress, String terminalType,String channelType);

    /*boolean applyTerminalProcess();*/

    /**
     * 工作流回调
     * @param auditId 审批单号
     * @param activitiState 状态
     * @param activitiCode 工作流名称
     * @param jsonString 业务数据
     */
    void activitiCallBack(String auditId, ActivitiState activitiState, String activitiCode, String jsonString);
}
