package com.chinayanghe.msp.mdm.vo.franchiser;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 经销商协议vo
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/4/18
 */
public class FranchiseProtocolVo implements Serializable{

    private static final long serialVersionUID = -3916557418132880931L;

    /**
     * 数据库中的id
     */
    private String id;

    /**
     * 经销协议编码
     */
    private String protocolCode;

    /**
     * 协议内容
     */
    private String protocolContent;

    /**
     * 经销商编码
     */
    private String franchiserCode;

    /**
     * 经销商id
     */
    private String franchiserId;

    /**
     * 经销商名称
     */
    private String franchiserName;

    /**
     * 协议生效时间
     */
    private Date startDate;

    /**
     * 协议失效时间
     */
    private Date endDate;

    /**
     * 冻结状态
     */
    private Integer status;

    /**
     * 销售范围
     */
    private SaleRangeVo saleRange;

    /**
     * 物料组
     */
    private List<FranchiseMaterielVo> materiels;

    /**
     * 销售区域
     */
    private List<FranchiseSaleAreaVo> saleAreas;

    /**
     * 二级渠道编码
     */
    private String subChannelCode;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getProtocolCode() {
        return protocolCode;
    }

    public void setProtocolCode(String protocolCode) {
        this.protocolCode = protocolCode;
    }

    public String getProtocolContent() {
        return protocolContent;
    }

    public void setProtocolContent(String protocolContent) {
        this.protocolContent = protocolContent;
    }

    public String getFranchiserCode() {
        return franchiserCode;
    }

    public void setFranchiserCode(String franchiserCode) {
        this.franchiserCode = franchiserCode;
    }

    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getFranchiserName() {
        return franchiserName;
    }

    public void setFranchiserName(String franchiserName) {
        this.franchiserName = franchiserName;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public SaleRangeVo getSaleRange() {
        return saleRange;
    }

    public void setSaleRange(SaleRangeVo saleRange) {
        this.saleRange = saleRange;
    }

    public List<FranchiseMaterielVo> getMateriels() {
        return materiels;
    }

    public void setMateriels(List<FranchiseMaterielVo> materiels) {
        this.materiels = materiels;
    }

    public List<FranchiseSaleAreaVo> getSaleAreas() {
        return saleAreas;
    }

    public void setSaleAreas(List<FranchiseSaleAreaVo> saleAreas) {
        this.saleAreas = saleAreas;
    }

    public String getSubChannelCode() {
        return subChannelCode;
    }

    public void setSubChannelCode(String subChannelCode) {
        this.subChannelCode = subChannelCode;
    }

    public String getFranchiserId() {
        return franchiserId;
    }

    public void setFranchiserId(String franchiserId) {
        this.franchiserId = franchiserId;
    }
}
