package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by isshu on 2017/6/14.
 * 终端类型
 */
public enum TerminalType {

    GROUP_PURCHASE_COMPANY("17","团购单位"),

    VIP_STORE("14","核心烟酒店"),

    NORMAL_STORE("13","非核心烟酒店"),

    MARKET_A("15","A类商超"),

    MARKET_B("16","B类商超"),

    VIP_HOTEL("11","核心酒店"),

    NORMAL_HOTEL("10","非核心酒店");

    private String code;
    private String desc;

    private static final Map<String,TerminalType> objMap = new HashMap<>();

    public static TerminalType getObj(String code){

        if(objMap.isEmpty()){

            TerminalType[] values = TerminalType.values();
            for (TerminalType terminalType : values
                    ) {

                objMap.put(terminalType.getCode(),terminalType);
            }
        }
        return objMap.get(code);
    }

    TerminalType(String code, String desc){

        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
