package com.chinayanghe.msp.mdm.rpc.position;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.vo.position.PositionInformationVo;
import com.chinayanghe.msp.mdm.vo.position.PositionReqVo;
import com.chinayanghe.msp.mdm.vo.position.PositionUserReqVo;
import com.chinayanghe.msp.mdm.vo.position.PositionUserVo;
import com.chinayanghe.msp.mdm.vo.position.PositionFranchiserRespVo;
import java.util.List;
import java.util.Map;
import java.util.Set;


/**
 * Created by danDy on 2017/4/27.
 */
public interface PositionInformationService  {
    /**
     * 根据岗位编码，数据权限，启用状态查询岗位基本信息
     * @param positionCode
     * @param power "04":要,"05":不要
     * @param enableStatus 0:启用,1:停用,可以不填
     * @return
     * @throws Exception
     */
     List<PositionInformationVo> getPositionMessage(String positionCode, String power, Integer enableStatus);

    /**
     * 根据当前组织查询当前组织以及其子组织下的所有岗位
     * @param orgCode 当前组织
     * @param pageable（advancedSearch  -- 》（fullName 用户名称 positionCode岗位编码 positionName 岗位名称 orgName 组织名称模糊查询 justSfa[boolean] 是否只是sfa角色岗位））
     * @param enableStatus 0:启用,1:停用
     * @return
     */
    Page<PositionInformationVo> findAllPositionByCurrOrg(String orgCode, Integer enableStatus, Pageable pageable);

    /**
     * 根据当前组织查询当前组织以及其子组织下的所有岗位(没分页)
     * @param orgCode
     * @param enableStatus 0:启用,1:停用
     * @return
     */
    List<PositionInformationVo> findAllPositionByCurrOrg(String orgCode, Integer enableStatus);

    /**
     * 根据当前岗位编码查询所在组织及所有下级组织岗位（）
     * @param positionCode 当前岗位编码
     * @param justManage 为true时，如果不是管理岗位，则只返回自己，为管理岗位时返回所有下级岗位；为false时这没有这一限制
     * @return
     */
    List<PositionInformationVo> findAllPositionByCurrPosition(String positionCode,boolean justManage);

    /**
     * 根据岗位编码获取岗位信息
     * @param positionCode
     * @return
     */
    PositionInformationVo findPositionByCode(String positionCode);

    /**
     * 根据组织id和是否是岗位管理者查询岗位
     * @param orgId 必输
     * @param administration 可输
     * @return
     */
    List<PositionInformationVo> findByOrgIdAndAdministation(String orgId,String administration);

    /**
     * 查询当前组织下的岗位
     * @param orgCode
     * @return
     */
    List<PositionInformationVo> findPositionsByOrgCode(String orgCode);
    
    /**
	 * 获取当前岗位所属分公司下的所有岗位人员和与分公司有对应关系的经销商人员的岗位 
	 * （根据经销商经销范围查找）,可排除输入岗位
	 * @param reqVo 请求参数
	 * @return
	 */
    Page<PositionInformationVo> findPositionsBySaleRange(PositionReqVo reqVo,Pageable pageable);
    
    /**
     * 根据岗位获取分公司下所有岗位信息接口
     * 根据岗位编码 查询该岗位对应分公司（或办事处）下所有岗位信息及相应人员信息,
     * 且支持按岗位编码,人员编码精确搜索,按岗位名称,人员名称模糊查找。
     * @param reqVo
     * @param pageable
     * @return
     */
    Page<PositionUserVo> findHierarchyPositionsByPositionPage(PositionUserReqVo reqVo,Pageable pageable);
    
    
    
    /**
     * 通过输入经销商编码和经销商角色编码，返回对应的经销商虚拟岗位编码和人员编码.
     * @param franchiserCode 经销商编码
     * @param roleCode 角色编码
     * @param pageable
     * @return
     */
    Page<PositionFranchiserRespVo> findPositionFranchiserInfo(String franchiserCode,String roleCode,Pageable pageable);

    /**
     * 根据角色编码查询当前岗位所在大区下的53组织下的相应角色岗位
     * @param currentPosition
     * @return
     */
    List<String> findSfa53PositionByRole(String currentPosition, String findRole);


    /**
     * 查询组织下的岗位
     * @param orgCodes
     * @return
     */
    List<PositionInformationVo> findPositionsByOrgCodes(List<String> orgCodes);

    /**
     * 根据人员编码查询岗位信息
     * @param userName
     * @return
     */
    PositionInformationVo findPositionByUserName(String userName);

    /**
     *  根据秩序管理部查询办事处负责人岗位信息
     * @param parentId
     * @param administation
     * @return
     */
    List<PositionInformationVo> findByParentIdAndAdministation(String parentId , String administation);

    /**
     * 根据角色编码查询岗位信息
     * @param roleCode
     * @return
     */
    List<PositionInformationVo> findByRoleCode(String roleCode);

    /**
     * 根据组织编码查询拥有岗位编码
     * @param orgCode 组织编码
     * @param includeChildOrg 是否包含下级组织
     * @param justSfa 是否只是sfa角色岗位
     * @return key,岗位编码;value,岗位名称
     */
    Map<String,String> findPositionCodesByOrgCode(String orgCode, Boolean includeChildOrg, Boolean justSfa);
}
