package com.chinayanghe.msp.mdm.rpc;

import com.chinayanghe.msp.mdm.dto.franchiser.*;
import com.chinayanghe.msp.mdm.enums.PositionFranchiseDuty;

import java.util.List;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/5/4
 */
public interface FranchiserRpcService {

    /**
     * 查询经销商
     * @param franchiserCode 经销商编码
     * @param customerTypeCode 客户类型编码
     * @param filterFreeze 是否过滤冻结经销商
     * @return
     */
    List<FranchiserDto> findFranchiserDetails(String franchiserCode,String customerTypeCode,Boolean filterFreeze);

    /**
     * 根据经销商编码查询经销商供货区域
     * @param franchiserCode 经销商编码
     * @param  includeNotActive 是否包含失效的供货区域
     * @return
     */
    List<FranchiseSaleAreaDto> findFranchiseSaleAreasByFranchiserCode(String franchiserCode, Boolean includeNotActive);

    /**
     * 根据经销商编码查询经销商销售范围
     * @param franchiserCode 经销商编码
     * @return
     */
    List<SaleRangeDto> findFranchiseSaleRangeByFranchiserCode(String franchiserCode);

    /**
     * 查询经销商协议
     * @param franchiserCode 经销商编码
     * @param filialeCode 分公司/办事处组织代码
     * @param materielCode 物料编码
     * @return
     */
    List<FranchiseProtocolDto> findFranchiseProtocolDetails(String franchiserCode,String filialeCode,String materielCode);

    /**
     * 查询岗位经销商关系
     * @param franchiserCode 经销商编码
     * @param positionCode 岗位编码
     * @param duties 岗位职责
     * @return
     */
    List<FranchisePositionRelationDto> findFranchisePositionRelations(String franchiserCode,String positionCode,List<PositionFranchiseDuty> duties);
}
