
package com.chinayanghe.tpm.cost.rpc;

import java.util.List;

import com.chinayanghe.tpm.cost.vo.out.CostRegisterEvidenceResVo;
import com.chinayanghe.tpm.cost.vo.out.CostRegisterFormResVo;

/**
 * 费用表单接口类
 * @author arthur
 *
 */
public interface CostFormRpcService {

	final String ACTIVITYENUM_PRE="activity";
	/**
	 * 开发编号 QYX_TPM_INTF_0005 获取登记取证字段
	 * @param registerNo 登记单号
	 * @param registerTitle 登记单标题
	 * @param terminalCodeList 终端编码-传终端编码Code
	 * @return
	 */
	CostRegisterFormResVo findCostRegisterFormItems(String registerNo,String registerTitle,List<String> terminalCodeList);
	

	
	/**
	 *开发编号 QYX_TPM_INTF_0005  获取登记取证字段
	 *@param registerNo 登记单号
	 *@param ltemNo  行号
	* @return
	 */
	CostRegisterEvidenceResVo getCostRegisterEvidence(String registerNo,String ltemNo);
	
	
	 /**
     * 根据岗位获取表单
     * 只查询未审核
     * @param positionCode 岗位编号
     * @param type 表单类型
     * @return  List<ActivityBaseInfoVo>
     */
    public List<CostRegisterFormResVo> getFormsByPosition(String positionCode, String type);

    /**
     * 根据表单编号获取表单头信息
     * @param formNo 表单编号
     * @return com.chinayanghe.tpm.cost.vo.ActivityBaseInfoVo
     */
    public CostRegisterFormResVo findByFormNo(String formNo);
}
