package com.chinayanghe.tpm.cost.rpc;


import com.chinayanghe.tpm.cost.vo.out.BizResponseJson;

/**
 * Created by wanggq on 2017/6/8.
 */
public interface CostFromActRpcService {


    /***
     * 修改表单状态
     * @param formNo 表单编号
     * @param status 状态
     * @return BizResponseJson
     */
    BizResponseJson updateFormStatus(String formNo,int status);

    /***
     * 修改宴会申请表
     * @param managerForm  管理信息
     * @param activityForm 活动信息
     * @param financialForm 财务信息
     * @param activityItemJson 表单体
     * @param isIndividualPromote 是否促销
     * @param regionMktValue  区域市场
     * @param status  状态
     * @param deleteIds 删除ids
     * @param userId  登陆人帐号
     * @return  BizResponseJson
     */
    BizResponseJson updateConsumerApply(String managerForm, String activityForm, String financialForm,
                                        String activityItemJson, Integer isIndividualPromote,
                                        String regionMktValue, Integer status, String deleteIds,String userId);



    /**
     *  冻结预算余额
     * @param formNo 活动表单
     * @param userId 登陆人帐号
     */
    BizResponseJson  freezeBudget(String formNo,String userId);

    /**
     * 释放预算余额
     * @param formNo 表单编号
     * @param status 流程状态
     * @param currentUser 当前操作人
     */
    BizResponseJson freeBudget(String formNo,String currentUser,int status);


    /**
     * 关闭
     * @param formNo 表单编号
     * @param currentUser 当前操作人
     * @param isProcessClose 是否流程关闭
     */
    BizResponseJson closeBudget(String formNo,String currentUser,Boolean isProcessClose);

    /**
     * 审批通过
     * @param formNo 活动信息
     * @param userId 当前操作人
     */
    BizResponseJson payPass(String formNo, String userId);

    /**
     * 核报
     * @param formNo
     * @param userId
     */
    BizResponseJson auditPass(String formNo,String userId);


}
