package com.chinayanghe.tpm.cost.rpc;


import com.chinayanghe.tpm.cost.vo.in.CostPageFormVo;
import com.chinayanghe.tpm.cost.vo.out.BizResponseJson;

/**
 * Created by wanggq on 2017/6/8.
 */
public interface CostWfRpcService {


    int cancleApplyBudget(String formNo,String actId,String userId);


    /***
     * 修改表单状态
     * @param formNo 表单编号
     * @param status 状态
     * @return BizResponseJson
     */
    BizResponseJson updateFormStatus(String formNo, int status);

    /***
     * 更新表单
     * @param costPageFormVo
     * @return
     */
    BizResponseJson updateForm(CostPageFormVo costPageFormVo);


    /**
     *  冻结预算余额
     * @param formNo 活动表单
     * @param userId 登陆人帐号
     */
    BizResponseJson  freezeBudget(String formNo, String userId);


    /**
     * 释放预算余额
     * @param formNo 表单编号
     * @param status 流程状态
     * @param currentUser 当前操作人
     */
    BizResponseJson freeBudget(String formNo, String currentUser, int status);



    /**
     * 关闭
     * @param formNo 表单编号
     * @param currentUser 当前操作人
     * @param isProcessClose 是否流程关闭
     */
    BizResponseJson closeBudget(String formNo, String currentUser, Boolean isProcessClose);




}
