package com.chinayanghe.tpm.cost.vo.out.datadetail.regist;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 酒店个性化奖励登记
 * HotelAwardRegistVo
 * 数据库表：hotel_award_regist
 */
public class HotelAwardRegistVo implements Serializable {

    /**
     * ID
     * 表字段 : hotel_award_regist.id
     */
    private Integer id;

    /**
     * 登记单号
     * 表字段 : hotel_award_regist.regist_no
     */
    private String registNo;

    /**
     * 申请单号
     * 表字段 : hotel_award_regist.apply_no
     */
    private String applyNo;

    /**
     * 申请单行项目ID
     * 表字段 : hotel_award_regist.apply_item_id
     */
    private Integer applyItemId;

    /**
     * 申请单行项目号
     * 表字段 : hotel_award_regist.item_no
     */
    private String applyItemNo;
    /**
     * 行项目号
     */
    private String itemNo;

    /**
     * 开始时间
     * 表字段 : hotel_award_regist.s_date
     */
    private Date sDate;

    /**
     * 结束时间
     * 表字段 : hotel_award_regist.e_date
     */
    private Date eDate;

    /**
     * 费用类型编码
     * 表字段 : hotel_award_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : hotel_award_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 奖励类型id
     * 表字段 : hotel_award_regist.award_type_id
     */
    private String awardTypeId;

    /**
     * 奖励类型名称
     * 表字段 : hotel_award_regist.award_type_name
     */
    private String awardTypeName;

    /**
     * 终端编号
     * 表字段 : hotel_award_regist.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : hotel_award_regist.terminal_name
     */
    private String terminalName;

    /**
     * 终端详细地址
     * 表字段 : hotel_award_regist.address_detail
     */
    private String addressDetail;

    /**
     * 产品编码
     * 表字段 : hotel_award_regist.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : hotel_award_regist.product_name
     */
    private String productName;

    /**
     * 登记数量
     * 表字段 : hotel_award_regist.buy_num
     */
    private Integer buyNum;

    /**
     * 结算价(分)
     * 表字段 : hotel_award_regist.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 厂方承担比例
     * 表字段 : hotel_award_regist.company_scale
     */
    private Double companyScale;

    /**
     * 厂方承担金额(分)
     * 表字段 : hotel_award_regist.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 负责人
     * 表字段 : hotel_award_regist.company_contact
     */
    private String companyContact;

    /**
     * 联系人职务
     * 表字段 : hotel_award_regist.contact_position
     */
    private String contactPosition;

    /**
     * 固定电话
     * 表字段 : hotel_award_regist.tel
     */
    private String tel;

    /**
     * 移动电话
     * 表字段 : hotel_award_regist.mobile_phone
     */
    private String mobilePhone;

    /**
     * 实际产生金额(分)
     * 表字段 : hotel_award_regist.total_amount
     */
    private BigDecimal totalAmount;

    /**
     * 备注
     * 表字段 : hotel_award_regist.notes
     */
    private String notes;

    /**
     * 行项目余额
     * 表字段 : hotel_award_regist.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 督查意见
     * 表字段 : hotel_award_regist.audit_notes
     */
    private String auditNotes;

    /**
     * 采购网点id
     * 表字段 : hotel_award_regist.procurement_store
     */
    private String procurementStore;

    /**
     * 采购网点名称
     * 表字段 : hotel_award_regist.procurement_store_name
     */
    private String procurementStoreName;

    /**
     * 网点联系人
     * 表字段 : hotel_award_regist.store_contact
     */
    private String storeContact;

    /**
     * 网点联系人电话
     * 表字段 : hotel_award_regist.store_contact_tel
     */
    private String storeContactTel;

    /**
     * 网点地址
     * 表字段 : hotel_award_regist.store_address
     */
    private String storeAddress;

    /**
     * 采购商品名称
     * 表字段 : hotel_award_regist.store_product_name
     */
    private String storeProductName;

    /**
     * 单位
     * 表字段 : hotel_award_regist.unit
     */
    private String unit;

    /**
     * 产品单价(分)
     * 表字段 : hotel_award_regist.product_price
     */
    private BigDecimal productPrice;

    /**
     * 产品型号
     * 表字段 : hotel_award_regist.product_model
     */
    private String productModel;

    /**
     * 
     * 表字段 : hotel_award_regist.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : hotel_award_regist.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : hotel_award_regist.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : hotel_award_regist.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : hotel_award_regist.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : hotel_award_regist.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table hotel_award_regist
     *
     * @mbggenerated Mon Jun 12 15:30:46 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:hotel_award_regist.id
     *
     * @return hotel_award_regist.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:hotel_award_regist.id
     *
     * @param id the value for hotel_award_regist.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 登记单号 字段:hotel_award_regist.regist_no
     *
     * @return hotel_award_regist.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:hotel_award_regist.regist_no
     *
     * @param registNo the value for hotel_award_regist.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 申请单号 字段:hotel_award_regist.apply_no
     *
     * @return hotel_award_regist.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:hotel_award_regist.apply_no
     *
     * @param applyNo the value for hotel_award_regist.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 申请单行项目ID 字段:hotel_award_regist.apply_item_id
     *
     * @return hotel_award_regist.apply_item_id, 申请单行项目ID
     */
    public Integer getApplyItemId() {
        return applyItemId;
    }

    /**
     * 设置 申请单行项目ID 字段:hotel_award_regist.apply_item_id
     *
     * @param applyItemId the value for hotel_award_regist.apply_item_id, 申请单行项目ID
     */
    public void setApplyItemId(Integer applyItemId) {
        this.applyItemId = applyItemId;
    }

    /**
     * 获取 申请单行项目号 字段:hotel_award_regist.item_no
     *
     * @return hotel_award_regist.item_no, 申请单行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 申请单行项目号 字段:hotel_award_regist.item_no
     *
     * @param itemNo the value for hotel_award_regist.item_no, 申请单行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 开始时间 字段:hotel_award_regist.s_date
     *
     * @return hotel_award_regist.s_date, 开始时间
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始时间 字段:hotel_award_regist.s_date
     *
     * @param sDate the value for hotel_award_regist.s_date, 开始时间
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结束时间 字段:hotel_award_regist.e_date
     *
     * @return hotel_award_regist.e_date, 结束时间
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结束时间 字段:hotel_award_regist.e_date
     *
     * @param eDate the value for hotel_award_regist.e_date, 结束时间
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 费用类型编码 字段:hotel_award_regist.cost_type_id
     *
     * @return hotel_award_regist.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:hotel_award_regist.cost_type_id
     *
     * @param costTypeId the value for hotel_award_regist.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:hotel_award_regist.cost_type_name
     *
     * @return hotel_award_regist.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:hotel_award_regist.cost_type_name
     *
     * @param costTypeName the value for hotel_award_regist.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 奖励类型id 字段:hotel_award_regist.award_type_id
     *
     * @return hotel_award_regist.award_type_id, 奖励类型id
     */
    public String getAwardTypeId() {
        return awardTypeId;
    }

    /**
     * 设置 奖励类型id 字段:hotel_award_regist.award_type_id
     *
     * @param awardTypeId the value for hotel_award_regist.award_type_id, 奖励类型id
     */
    public void setAwardTypeId(String awardTypeId) {
        this.awardTypeId = awardTypeId;
    }

    /**
     * 获取 奖励类型名称 字段:hotel_award_regist.award_type_name
     *
     * @return hotel_award_regist.award_type_name, 奖励类型名称
     */
    public String getAwardTypeName() {
        return awardTypeName;
    }

    /**
     * 设置 奖励类型名称 字段:hotel_award_regist.award_type_name
     *
     * @param awardTypeName the value for hotel_award_regist.award_type_name, 奖励类型名称
     */
    public void setAwardTypeName(String awardTypeName) {
        this.awardTypeName = awardTypeName;
    }

    /**
     * 获取 终端编号 字段:hotel_award_regist.terminal_id
     *
     * @return hotel_award_regist.terminal_id, 终端编号
     */
    public String getTerminalId() {
        return terminalId;
    }

    /**
     * 设置 终端编号 字段:hotel_award_regist.terminal_id
     *
     * @param terminalId the value for hotel_award_regist.terminal_id, 终端编号
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 获取 终端名称 字段:hotel_award_regist.terminal_name
     *
     * @return hotel_award_regist.terminal_name, 终端名称
     */
    public String getTerminalName() {
        return terminalName;
    }

    /**
     * 设置 终端名称 字段:hotel_award_regist.terminal_name
     *
     * @param terminalName the value for hotel_award_regist.terminal_name, 终端名称
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 获取 终端详细地址 字段:hotel_award_regist.address_detail
     *
     * @return hotel_award_regist.address_detail, 终端详细地址
     */
    public String getAddressDetail() {
        return addressDetail;
    }

    /**
     * 设置 终端详细地址 字段:hotel_award_regist.address_detail
     *
     * @param addressDetail the value for hotel_award_regist.address_detail, 终端详细地址
     */
    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    /**
     * 获取 产品编码 字段:hotel_award_regist.product_id
     *
     * @return hotel_award_regist.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:hotel_award_regist.product_id
     *
     * @param productId the value for hotel_award_regist.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:hotel_award_regist.product_name
     *
     * @return hotel_award_regist.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:hotel_award_regist.product_name
     *
     * @param productName the value for hotel_award_regist.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 登记数量 字段:hotel_award_regist.buy_num
     *
     * @return hotel_award_regist.buy_num, 登记数量
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 登记数量 字段:hotel_award_regist.buy_num
     *
     * @param buyNum the value for hotel_award_regist.buy_num, 登记数量
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取 结算价(分) 字段:hotel_award_regist.settlement_price
     *
     * @return hotel_award_regist.settlement_price, 结算价(分)
     */
    public BigDecimal getSettlementPrice() {
    	 if( this.settlementPrice != null) {
	          return (this.settlementPrice.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.settlementPrice;
    }

    /**
     * 设置 结算价(分) 字段:hotel_award_regist.settlement_price
     *
     * @param settlementPrice the value for hotel_award_regist.settlement_price, 结算价(分)
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 获取 厂方承担比例 字段:hotel_award_regist.company_scale
     *
     * @return hotel_award_regist.company_scale, 厂方承担比例
     */
    public Double getCompanyScale() {
        return companyScale;
    }

    /**
     * 设置 厂方承担比例 字段:hotel_award_regist.company_scale
     *
     * @param companyScale the value for hotel_award_regist.company_scale, 厂方承担比例
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }

    /**
     * 获取 厂方承担金额(分) 字段:hotel_award_regist.company_amount
     *
     * @return hotel_award_regist.company_amount, 厂方承担金额(分)
     */
    public BigDecimal getCompanyAmount() {
    	 if( this.companyAmount != null) {
	          return (this.companyAmount.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.companyAmount;
    }

    /**
     * 设置 厂方承担金额(分) 字段:hotel_award_regist.company_amount
     *
     * @param companyAmount the value for hotel_award_regist.company_amount, 厂方承担金额(分)
     */
    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 获取 负责人 字段:hotel_award_regist.company_contact
     *
     * @return hotel_award_regist.company_contact, 负责人
     */
    public String getCompanyContact() {
        return companyContact;
    }

    /**
     * 设置 负责人 字段:hotel_award_regist.company_contact
     *
     * @param companyContact the value for hotel_award_regist.company_contact, 负责人
     */
    public void setCompanyContact(String companyContact) {
        this.companyContact = companyContact;
    }

    /**
     * 获取 联系人职务 字段:hotel_award_regist.contact_position
     *
     * @return hotel_award_regist.contact_position, 联系人职务
     */
    public String getContactPosition() {
        return contactPosition;
    }

    /**
     * 设置 联系人职务 字段:hotel_award_regist.contact_position
     *
     * @param contactPosition the value for hotel_award_regist.contact_position, 联系人职务
     */
    public void setContactPosition(String contactPosition) {
        this.contactPosition = contactPosition;
    }

    /**
     * 获取 固定电话 字段:hotel_award_regist.tel
     *
     * @return hotel_award_regist.tel, 固定电话
     */
    public String getTel() {
        return tel;
    }

    /**
     * 设置 固定电话 字段:hotel_award_regist.tel
     *
     * @param tel the value for hotel_award_regist.tel, 固定电话
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 获取 移动电话 字段:hotel_award_regist.mobile_phone
     *
     * @return hotel_award_regist.mobile_phone, 移动电话
     */
    public String getMobilePhone() {
        return mobilePhone;
    }

    /**
     * 设置 移动电话 字段:hotel_award_regist.mobile_phone
     *
     * @param mobilePhone the value for hotel_award_regist.mobile_phone, 移动电话
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    /**
     * 获取 实际产生金额(分) 字段:hotel_award_regist.total_amount
     *
     * @return hotel_award_regist.total_amount, 实际产生金额(分)
     */
    public BigDecimal getTotalAmount() {
	   	 if( this.totalAmount != null) {
	         return (this.totalAmount.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	     }
	     return this.totalAmount;
    }

    /**
     * 设置 实际产生金额(分) 字段:hotel_award_regist.total_amount
     *
     * @param totalAmount the value for hotel_award_regist.total_amount, 实际产生金额(分)
     */
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * 获取 备注 字段:hotel_award_regist.notes
     *
     * @return hotel_award_regist.notes, 备注
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注 字段:hotel_award_regist.notes
     *
     * @param notes the value for hotel_award_regist.notes, 备注
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取 行项目余额 字段:hotel_award_regist.item_balance
     *
     * @return hotel_award_regist.item_balance, 行项目余额
     */
    public BigDecimal getItemBalance() {
     	 if( this.itemBalance != null) {
	         return (this.itemBalance.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	     }
	     return this.itemBalance;
    }

    /**
     * 设置 行项目余额 字段:hotel_award_regist.item_balance
     *
     * @param itemBalance the value for hotel_award_regist.item_balance, 行项目余额
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 督查意见 字段:hotel_award_regist.audit_notes
     *
     * @return hotel_award_regist.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:hotel_award_regist.audit_notes
     *
     * @param auditNotes the value for hotel_award_regist.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取 采购网点id 字段:hotel_award_regist.procurement_store
     *
     * @return hotel_award_regist.procurement_store, 采购网点id
     */
    public String getProcurementStore() {
        return procurementStore;
    }

    /**
     * 设置 采购网点id 字段:hotel_award_regist.procurement_store
     *
     * @param procurementStore the value for hotel_award_regist.procurement_store, 采购网点id
     */
    public void setProcurementStore(String procurementStore) {
        this.procurementStore = procurementStore;
    }

    /**
     * 获取 采购网点名称 字段:hotel_award_regist.procurement_store_name
     *
     * @return hotel_award_regist.procurement_store_name, 采购网点名称
     */
    public String getProcurementStoreName() {
        return procurementStoreName;
    }

    /**
     * 设置 采购网点名称 字段:hotel_award_regist.procurement_store_name
     *
     * @param procurementStoreName the value for hotel_award_regist.procurement_store_name, 采购网点名称
     */
    public void setProcurementStoreName(String procurementStoreName) {
        this.procurementStoreName = procurementStoreName;
    }

    /**
     * 获取 网点联系人 字段:hotel_award_regist.store_contact
     *
     * @return hotel_award_regist.store_contact, 网点联系人
     */
    public String getStoreContact() {
        return storeContact;
    }

    /**
     * 设置 网点联系人 字段:hotel_award_regist.store_contact
     *
     * @param storeContact the value for hotel_award_regist.store_contact, 网点联系人
     */
    public void setStoreContact(String storeContact) {
        this.storeContact = storeContact;
    }

    /**
     * 获取 网点联系人电话 字段:hotel_award_regist.store_contact_tel
     *
     * @return hotel_award_regist.store_contact_tel, 网点联系人电话
     */
    public String getStoreContactTel() {
        return storeContactTel;
    }

    /**
     * 设置 网点联系人电话 字段:hotel_award_regist.store_contact_tel
     *
     * @param storeContactTel the value for hotel_award_regist.store_contact_tel, 网点联系人电话
     */
    public void setStoreContactTel(String storeContactTel) {
        this.storeContactTel = storeContactTel;
    }

    /**
     * 获取 网点地址 字段:hotel_award_regist.store_address
     *
     * @return hotel_award_regist.store_address, 网点地址
     */
    public String getStoreAddress() {
        return storeAddress;
    }

    /**
     * 设置 网点地址 字段:hotel_award_regist.store_address
     *
     * @param storeAddress the value for hotel_award_regist.store_address, 网点地址
     */
    public void setStoreAddress(String storeAddress) {
        this.storeAddress = storeAddress;
    }

    /**
     * 获取 采购商品名称 字段:hotel_award_regist.store_product_name
     *
     * @return hotel_award_regist.store_product_name, 采购商品名称
     */
    public String getStoreProductName() {
        return storeProductName;
    }

    /**
     * 设置 采购商品名称 字段:hotel_award_regist.store_product_name
     *
     * @param storeProductName the value for hotel_award_regist.store_product_name, 采购商品名称
     */
    public void setStoreProductName(String storeProductName) {
        this.storeProductName = storeProductName;
    }

    /**
     * 获取 单位 字段:hotel_award_regist.unit
     *
     * @return hotel_award_regist.unit, 单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 设置 单位 字段:hotel_award_regist.unit
     *
     * @param unit the value for hotel_award_regist.unit, 单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }

    /**
     * 获取 产品单价(分) 字段:hotel_award_regist.product_price
     *
     * @return hotel_award_regist.product_price, 产品单价(分)
     */
    public BigDecimal getProductPrice() {
	   	 if( this.productPrice != null) {
	         return (this.productPrice.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	     }
	     return this.productPrice;
    }

    /**
     * 设置 产品单价(分) 字段:hotel_award_regist.product_price
     *
     * @param productPrice the value for hotel_award_regist.product_price, 产品单价(分)
     */
    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    /**
     * 获取 产品型号 字段:hotel_award_regist.product_model
     *
     * @return hotel_award_regist.product_model, 产品型号
     */
    public String getProductModel() {
        return productModel;
    }

    /**
     * 设置 产品型号 字段:hotel_award_regist.product_model
     *
     * @param productModel the value for hotel_award_regist.product_model, 产品型号
     */
    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    /**
     * 获取  字段:hotel_award_regist.create_id
     *
     * @return hotel_award_regist.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:hotel_award_regist.create_id
     *
     * @param createId the value for hotel_award_regist.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:hotel_award_regist.create_name
     *
     * @return hotel_award_regist.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:hotel_award_regist.create_name
     *
     * @param createName the value for hotel_award_regist.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:hotel_award_regist.create_date
     *
     * @return hotel_award_regist.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:hotel_award_regist.create_date
     *
     * @param createDate the value for hotel_award_regist.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:hotel_award_regist.modify_id
     *
     * @return hotel_award_regist.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:hotel_award_regist.modify_id
     *
     * @param modifyId the value for hotel_award_regist.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:hotel_award_regist.modify_name
     *
     * @return hotel_award_regist.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:hotel_award_regist.modify_name
     *
     * @param modifyName the value for hotel_award_regist.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:hotel_award_regist.modify_date
     *
     * @return hotel_award_regist.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:hotel_award_regist.modify_date
     *
     * @param modifyDate the value for hotel_award_regist.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

	public String getApplyItemNo() {
		return applyItemNo;
	}

	public void setApplyItemNo(String applyItemNo) {
		this.applyItemNo = applyItemNo;
	}
    
}