package com.chinayanghe.tpm.cost.vo.out.datadetail.regist;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 渠道宣传费登记Vo
 * MarketChannelRegistDto
 * 数据库表：market_channel_regist
 */
public class MarketChannelRegistVo implements Serializable {

    /**
     * ID
     * 表字段 : market_channel_regist.id
     */
    private Integer id;

    /**
     * 临时报备单号
     * 表字段 : market_channel_regist.reported_no
     */
    private String reportedNo;

    /**
     * 登记单号
     * 表字段 : market_channel_regist.regist_no
     */
    private String registNo;

    /**
     * 申请单号
     * 表字段 : market_channel_regist.apply_no
     */
    private String applyNo;

    /**
     * 申请单行项目ID
     * 表字段 : market_channel_regist.apply_item_id
     */
    private Integer applyItemId;

    /**
     * 临时报备单行项目ID
     * 表字段 : market_channel_regist.reported_item_id
     */
    private Integer reportedItemId;

    /**
     * 申请单行项目号
     * 表字段 : market_channel_regist.item_no
     */
    private String itemNo;

    /**
     * 费用类型名称
     * 表字段 : market_channel_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 费用类型ID
     * 表字段 : market_channel_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 开始日期
     * 表字段 : market_channel_regist.s_date
     */
    private Date sDate;

    /**
     * 结束日期
     * 表字段 : market_channel_regist.e_date
     */
    private Date eDate;

    /**
     * 终端编号
     * 表字段 : market_channel_regist.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : market_channel_regist.terminal_name
     */
    private String terminalName;

    /**
     * 省份编码
     * 表字段 : market_channel_regist.province_id
     */
    private String provinceId;

    /**
     * 省份名称
     * 表字段 : market_channel_regist.province_name
     */
    private String provinceName;

    /**
     * 市编码
     * 表字段 : market_channel_regist.city_id
     */
    private String cityId;

    /**
     * 市名称
     * 表字段 : market_channel_regist.city_name
     */
    private String cityName;

    /**
     * 区编码
     * 表字段 : market_channel_regist.region_id
     */
    private String regionId;

    /**
     * 区名称
     * 表字段 : market_channel_regist.region_name
     */
    private String regionName;

    /**
     * 具体地址
     * 表字段 : market_channel_regist.address_detail
     */
    private String addressDetail;

    /**
     * 推广品牌编码
     * 表字段 : market_channel_regist.brand_id
     */
    private String brandId;

    /**
     * 推广品牌名称
     * 表字段 : market_channel_regist.brand_name
     */
    private String brandName;

    /**
     * 数量
     * 表字段 : market_channel_regist.num
     */
    private Integer num;

    /**
     * 单瓶日投入
     * 表字段 : market_channel_regist.day_price
     */
    private BigDecimal dayPrice;

    /**
     * 陈列瓶数
     * 表字段 : market_channel_regist.display_num
     */
    private Integer displayNum;

    /**
     * 负责人
     * 表字段 : market_channel_regist.company_contact
     */
    private String companyContact;

    /**
     * 联系人职务
     * 表字段 : market_channel_regist.contact_position
     */
    private String contactPosition;

    /**
     * 固定电话
     * 表字段 : market_channel_regist.tel
     */
    private String tel;

    /**
     * 移动电话
     * 表字段 : market_channel_regist.mobile_phone
     */
    private String mobilePhone;

    /**
     * 实际金额(分)
     * 表字段 : market_channel_regist.actual_amount
     */
    private BigDecimal actualAmount;

    /**
     * 厂方承担金额/元
     * 表字段 : market_channel_regist.compay_amount
     */
    private BigDecimal compayAmount;

    /**
     * 厂方承担比例
     * 表字段 : market_channel_regist.compay_scale
     */
    private Double compayScale;

    /**
     * 行项目余额
     * 表字段 : market_channel_regist.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 备注
     * 表字段 : market_channel_regist.notes
     */
    private String notes;

    /**
     * 督查意见
     * 表字段 : market_channel_regist.audit_notes
     */
    private String auditNotes;

    /**
     * 状态
     * 表字段 : market_channel_regist.status
     */
    private Integer status;

    /**
     * 
     * 表字段 : market_channel_regist.create_id
     */
    private String createId;

    /**
     * 创建者姓名
     * 表字段 : market_channel_regist.create_name
     */
    private String createName;

    /**
     * 创建时间
     * 表字段 : market_channel_regist.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : market_channel_regist.modify_id
     */
    private String modifyId;

    /**
     * 修改人姓名
     * 表字段 : market_channel_regist.modify_name
     */
    private String modifyName;

    /**
     * 修改时间
     * 表字段 : market_channel_regist.modify_date
     */
    private Date modifyDate;

    /**
     * 登记类型（0，常规 1临时）
     * 表字段 : market_channel_regist.type
     */
    private Boolean type;

    /**
     * 备用字段1
     * 表字段 : market_channel_regist.applyItemNo
     */
    private String applyItemNo;

    /**
     * 备用字段2
     * 表字段 : market_channel_regist.str2
     */
    private String str2;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table market_channel_regist
     *
     * @mbggenerated Thu Jun 15 22:00:35 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:market_channel_regist.id
     *
     * @return market_channel_regist.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:market_channel_regist.id
     *
     * @param id the value for market_channel_regist.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 临时报备单号 字段:market_channel_regist.reported_no
     *
     * @return market_channel_regist.reported_no, 临时报备单号
     */
    public String getReportedNo() {
        return reportedNo;
    }

    /**
     * 设置 临时报备单号 字段:market_channel_regist.reported_no
     *
     * @param reportedNo the value for market_channel_regist.reported_no, 临时报备单号
     */
    public void setReportedNo(String reportedNo) {
        this.reportedNo = reportedNo;
    }

    /**
     * 获取 登记单号 字段:market_channel_regist.regist_no
     *
     * @return market_channel_regist.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:market_channel_regist.regist_no
     *
     * @param registNo the value for market_channel_regist.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 申请单号 字段:market_channel_regist.apply_no
     *
     * @return market_channel_regist.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:market_channel_regist.apply_no
     *
     * @param applyNo the value for market_channel_regist.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 申请单行项目ID 字段:market_channel_regist.apply_item_id
     *
     * @return market_channel_regist.apply_item_id, 申请单行项目ID
     */
    public Integer getApplyItemId() {
        return applyItemId;
    }

    /**
     * 设置 申请单行项目ID 字段:market_channel_regist.apply_item_id
     *
     * @param applyItemId the value for market_channel_regist.apply_item_id, 申请单行项目ID
     */
    public void setApplyItemId(Integer applyItemId) {
        this.applyItemId = applyItemId;
    }

    /**
     * 获取 临时报备单行项目ID 字段:market_channel_regist.reported_item_id
     *
     * @return market_channel_regist.reported_item_id, 临时报备单行项目ID
     */
    public Integer getReportedItemId() {
        return reportedItemId;
    }

    /**
     * 设置 临时报备单行项目ID 字段:market_channel_regist.reported_item_id
     *
     * @param reportedItemId the value for market_channel_regist.reported_item_id, 临时报备单行项目ID
     */
    public void setReportedItemId(Integer reportedItemId) {
        this.reportedItemId = reportedItemId;
    }

    /**
     * 获取 申请单行项目号 字段:market_channel_regist.item_no
     *
     * @return market_channel_regist.item_no, 申请单行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 申请单行项目号 字段:market_channel_regist.item_no
     *
     * @param itemNo the value for market_channel_regist.item_no, 申请单行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 费用类型名称 字段:market_channel_regist.cost_type_name
     *
     * @return market_channel_regist.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:market_channel_regist.cost_type_name
     *
     * @param costTypeName the value for market_channel_regist.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 费用类型ID 字段:market_channel_regist.cost_type_id
     *
     * @return market_channel_regist.cost_type_id, 费用类型ID
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型ID 字段:market_channel_regist.cost_type_id
     *
     * @param costTypeId the value for market_channel_regist.cost_type_id, 费用类型ID
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 开始日期 字段:market_channel_regist.s_date
     *
     * @return market_channel_regist.s_date, 开始日期
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始日期 字段:market_channel_regist.s_date
     *
     * @param sDate the value for market_channel_regist.s_date, 开始日期
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结束日期 字段:market_channel_regist.e_date
     *
     * @return market_channel_regist.e_date, 结束日期
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结束日期 字段:market_channel_regist.e_date
     *
     * @param eDate the value for market_channel_regist.e_date, 结束日期
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 终端编号 字段:market_channel_regist.terminal_id
     *
     * @return market_channel_regist.terminal_id, 终端编号
     */
    public String getTerminalId() {
        return terminalId;
    }

    /**
     * 设置 终端编号 字段:market_channel_regist.terminal_id
     *
     * @param terminalId the value for market_channel_regist.terminal_id, 终端编号
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 获取 终端名称 字段:market_channel_regist.terminal_name
     *
     * @return market_channel_regist.terminal_name, 终端名称
     */
    public String getTerminalName() {
        return terminalName;
    }

    /**
     * 设置 终端名称 字段:market_channel_regist.terminal_name
     *
     * @param terminalName the value for market_channel_regist.terminal_name, 终端名称
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 获取 省份编码 字段:market_channel_regist.province_id
     *
     * @return market_channel_regist.province_id, 省份编码
     */
    public String getProvinceId() {
        return provinceId;
    }

    /**
     * 设置 省份编码 字段:market_channel_regist.province_id
     *
     * @param provinceId the value for market_channel_regist.province_id, 省份编码
     */
    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    /**
     * 获取 省份名称 字段:market_channel_regist.province_name
     *
     * @return market_channel_regist.province_name, 省份名称
     */
    public String getProvinceName() {
        return provinceName;
    }

    /**
     * 设置 省份名称 字段:market_channel_regist.province_name
     *
     * @param provinceName the value for market_channel_regist.province_name, 省份名称
     */
    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    /**
     * 获取 市编码 字段:market_channel_regist.city_id
     *
     * @return market_channel_regist.city_id, 市编码
     */
    public String getCityId() {
        return cityId;
    }

    /**
     * 设置 市编码 字段:market_channel_regist.city_id
     *
     * @param cityId the value for market_channel_regist.city_id, 市编码
     */
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取 市名称 字段:market_channel_regist.city_name
     *
     * @return market_channel_regist.city_name, 市名称
     */
    public String getCityName() {
        return cityName;
    }

    /**
     * 设置 市名称 字段:market_channel_regist.city_name
     *
     * @param cityName the value for market_channel_regist.city_name, 市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取 区编码 字段:market_channel_regist.region_id
     *
     * @return market_channel_regist.region_id, 区编码
     */
    public String getRegionId() {
        return regionId;
    }

    /**
     * 设置 区编码 字段:market_channel_regist.region_id
     *
     * @param regionId the value for market_channel_regist.region_id, 区编码
     */
    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    /**
     * 获取 区名称 字段:market_channel_regist.region_name
     *
     * @return market_channel_regist.region_name, 区名称
     */
    public String getRegionName() {
        return regionName;
    }

    /**
     * 设置 区名称 字段:market_channel_regist.region_name
     *
     * @param regionName the value for market_channel_regist.region_name, 区名称
     */
    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    /**
     * 获取 具体地址 字段:market_channel_regist.address_detail
     *
     * @return market_channel_regist.address_detail, 具体地址
     */
    public String getAddressDetail() {
        return addressDetail;
    }

    /**
     * 设置 具体地址 字段:market_channel_regist.address_detail
     *
     * @param addressDetail the value for market_channel_regist.address_detail, 具体地址
     */
    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    /**
     * 获取 推广品牌编码 字段:market_channel_regist.brand_id
     *
     * @return market_channel_regist.brand_id, 推广品牌编码
     */
    public String getBrandId() {
        return brandId;
    }

    /**
     * 设置 推广品牌编码 字段:market_channel_regist.brand_id
     *
     * @param brandId the value for market_channel_regist.brand_id, 推广品牌编码
     */
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    /**
     * 获取 推广品牌名称 字段:market_channel_regist.brand_name
     *
     * @return market_channel_regist.brand_name, 推广品牌名称
     */
    public String getBrandName() {
        return brandName;
    }

    /**
     * 设置 推广品牌名称 字段:market_channel_regist.brand_name
     *
     * @param brandName the value for market_channel_regist.brand_name, 推广品牌名称
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * 获取 数量 字段:market_channel_regist.num
     *
     * @return market_channel_regist.num, 数量
     */
    public Integer getNum() {
        return num;
    }

    /**
     * 设置 数量 字段:market_channel_regist.num
     *
     * @param num the value for market_channel_regist.num, 数量
     */
    public void setNum(Integer num) {
        this.num = num;
    }

    /**
     * 获取 单瓶日投入 字段:market_channel_regist.day_price
     *
     * @return market_channel_regist.day_price, 单瓶日投入
     */
    public BigDecimal getDayPrice() {
    	if( this.dayPrice != null) {
	          return (this.dayPrice.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.dayPrice;
    }

    /**
     * 设置 单瓶日投入 字段:market_channel_regist.day_price
     *
     * @param dayPrice the value for market_channel_regist.day_price, 单瓶日投入
     */
    public void setDayPrice(BigDecimal dayPrice) {
        this.dayPrice = dayPrice;
    }

    /**
     * 获取 陈列瓶数 字段:market_channel_regist.display_num
     *
     * @return market_channel_regist.display_num, 陈列瓶数
     */
    public Integer getDisplayNum() {
        return displayNum;
    }

    /**
     * 设置 陈列瓶数 字段:market_channel_regist.display_num
     *
     * @param displayNum the value for market_channel_regist.display_num, 陈列瓶数
     */
    public void setDisplayNum(Integer displayNum) {
        this.displayNum = displayNum;
    }

    /**
     * 获取 负责人 字段:market_channel_regist.company_contact
     *
     * @return market_channel_regist.company_contact, 负责人
     */
    public String getCompanyContact() {
        return companyContact;
    }

    /**
     * 设置 负责人 字段:market_channel_regist.company_contact
     *
     * @param companyContact the value for market_channel_regist.company_contact, 负责人
     */
    public void setCompanyContact(String companyContact) {
        this.companyContact = companyContact;
    }

    /**
     * 获取 联系人职务 字段:market_channel_regist.contact_position
     *
     * @return market_channel_regist.contact_position, 联系人职务
     */
    public String getContactPosition() {
        return contactPosition;
    }

    /**
     * 设置 联系人职务 字段:market_channel_regist.contact_position
     *
     * @param contactPosition the value for market_channel_regist.contact_position, 联系人职务
     */
    public void setContactPosition(String contactPosition) {
        this.contactPosition = contactPosition;
    }

    /**
     * 获取 固定电话 字段:market_channel_regist.tel
     *
     * @return market_channel_regist.tel, 固定电话
     */
    public String getTel() {
        return tel;
    }

    /**
     * 设置 固定电话 字段:market_channel_regist.tel
     *
     * @param tel the value for market_channel_regist.tel, 固定电话
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 获取 移动电话 字段:market_channel_regist.mobile_phone
     *
     * @return market_channel_regist.mobile_phone, 移动电话
     */
    public String getMobilePhone() {
        return mobilePhone;
    }

    /**
     * 设置 移动电话 字段:market_channel_regist.mobile_phone
     *
     * @param mobilePhone the value for market_channel_regist.mobile_phone, 移动电话
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    /**
     * 获取 实际金额(分) 字段:market_channel_regist.actual_amount
     *
     * @return market_channel_regist.actual_amount, 实际金额(分)
     */
    public BigDecimal getActualAmount() {
    	if( this.actualAmount != null) {
	          return (this.actualAmount.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.actualAmount;
    }

    /**
     * 设置 实际金额(分) 字段:market_channel_regist.actual_amount
     *
     * @param actualAmount the value for market_channel_regist.actual_amount, 实际金额(分)
     */
    public void setActualAmount(BigDecimal actualAmount) {
        this.actualAmount = actualAmount;
    }

    /**
     * 获取 厂方承担金额/元 字段:market_channel_regist.compay_amount
     *
     * @return market_channel_regist.compay_amount, 厂方承担金额/元
     */
    public BigDecimal getCompayAmount() {
      	if( this.compayAmount != null) {
	          return (this.compayAmount.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.compayAmount;
    }

    /**
     * 设置 厂方承担金额/元 字段:market_channel_regist.compay_amount
     *
     * @param compayAmount the value for market_channel_regist.compay_amount, 厂方承担金额/元
     */
    public void setCompayAmount(BigDecimal compayAmount) {
        this.compayAmount = compayAmount;
    }

    /**
     * 获取 厂方承担比例 字段:market_channel_regist.compay_scale
     *
     * @return market_channel_regist.compay_scale, 厂方承担比例
     */
    public Double getCompayScale() {
        return compayScale;
    }

    /**
     * 设置 厂方承担比例 字段:market_channel_regist.compay_scale
     *
     * @param compayScale the value for market_channel_regist.compay_scale, 厂方承担比例
     */
    public void setCompayScale(Double compayScale) {
        this.compayScale = compayScale;
    }

    /**
     * 获取 行项目余额 字段:market_channel_regist.item_balance
     *
     * @return market_channel_regist.item_balance, 行项目余额
     */
    public BigDecimal getItemBalance() {
      	if( this.itemBalance != null) {
	          return (this.itemBalance.divide(new BigDecimal(100),2,RoundingMode.HALF_UP));
	      }
	      return this.itemBalance;
    }

    /**
     * 设置 行项目余额 字段:market_channel_regist.item_balance
     *
     * @param itemBalance the value for market_channel_regist.item_balance, 行项目余额
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 备注 字段:market_channel_regist.notes
     *
     * @return market_channel_regist.notes, 备注
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注 字段:market_channel_regist.notes
     *
     * @param notes the value for market_channel_regist.notes, 备注
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取 督查意见 字段:market_channel_regist.audit_notes
     *
     * @return market_channel_regist.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:market_channel_regist.audit_notes
     *
     * @param auditNotes the value for market_channel_regist.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取 状态 字段:market_channel_regist.status
     *
     * @return market_channel_regist.status, 状态
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置 状态 字段:market_channel_regist.status
     *
     * @param status the value for market_channel_regist.status, 状态
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取  字段:market_channel_regist.create_id
     *
     * @return market_channel_regist.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:market_channel_regist.create_id
     *
     * @param createId the value for market_channel_regist.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取 创建者姓名 字段:market_channel_regist.create_name
     *
     * @return market_channel_regist.create_name, 创建者姓名
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置 创建者姓名 字段:market_channel_regist.create_name
     *
     * @param createName the value for market_channel_regist.create_name, 创建者姓名
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取 创建时间 字段:market_channel_regist.create_date
     *
     * @return market_channel_regist.create_date, 创建时间
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置 创建时间 字段:market_channel_regist.create_date
     *
     * @param createDate the value for market_channel_regist.create_date, 创建时间
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:market_channel_regist.modify_id
     *
     * @return market_channel_regist.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:market_channel_regist.modify_id
     *
     * @param modifyId the value for market_channel_regist.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取 修改人姓名 字段:market_channel_regist.modify_name
     *
     * @return market_channel_regist.modify_name, 修改人姓名
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置 修改人姓名 字段:market_channel_regist.modify_name
     *
     * @param modifyName the value for market_channel_regist.modify_name, 修改人姓名
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取 修改时间 字段:market_channel_regist.modify_date
     *
     * @return market_channel_regist.modify_date, 修改时间
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置 修改时间 字段:market_channel_regist.modify_date
     *
     * @param modifyDate the value for market_channel_regist.modify_date, 修改时间
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 登记类型（0，常规 1临时） 字段:market_channel_regist.type
     *
     * @return market_channel_regist.type, 登记类型（0，常规 1临时）
     */
    public Boolean getType() {
        return type;
    }

    /**
     * 设置 登记类型（0，常规 1临时） 字段:market_channel_regist.type
     *
     * @param type the value for market_channel_regist.type, 登记类型（0，常规 1临时）
     */
    public void setType(Boolean type) {
        this.type = type;
    }

    /**
     * 获取 备用字段1 字段:market_channel_regist.applyItemNo
     *
     * @return market_channel_regist.applyItemNo, 备用字段1
     */
    public String getApplyItemNo() {
        return applyItemNo;
    }

    /**
     * 设置 备用字段1 字段:market_channel_regist.applyItemNo
     *
     * @param applyItemNo the value for market_channel_regist.applyItemNo, 备用字段1
     */
    public void setApplyItemNo(String applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    /**
     * 获取 备用字段2 字段:market_channel_regist.str2
     *
     * @return market_channel_regist.str2, 备用字段2
     */
    public String getStr2() {
        return str2;
    }

    /**
     * 设置 备用字段2 字段:market_channel_regist.str2
     *
     * @param str2 the value for market_channel_regist.str2, 备用字段2
     */
    public void setStr2(String str2) {
        this.str2 = str2;
    }
}