package com.chinayanghe.tpm.cost.vo.out.datadetail.regist;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 达标奖励登记
 * WelldoneRewardRegistDto
 * 数据库表：welldone_reward_regist
 */
public class WelldoneRewardRegistVo implements Serializable {

    /**
     *
     * 表字段 : welldone_reward_regist.id
     */
    private Integer id;

    /**
     * 登记单号
     * 表字段 : welldone_reward_regist.regist_no
     */
    private String registNo;

    /**
     * 行号
     * 表字段 : welldone_reward_apply.item_no
     */
    private Integer itemNo;

    /**
     * 申请单号
     * 表字段 : welldone_reward_regist.apply_no
     */
    private String applyNo;

    /**
     * 申请单id
     */
    private Integer applyId;

    /**
     * 申请单行号
     * 表字段 : welldone_reward_regist.apply_item_no
     */
    private String applyItemNo;

    /**
     * 费用类型编码
     * 表字段 : welldone_reward_regist.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : welldone_reward_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 开始时间
     * 表字段 : welldone_reward_regist.s_date
     */
    private Date sDate;

    /**
     * 结束时间
     * 表字段 : welldone_reward_regist.e_date
     */
    private Date eDate;

    /**
     * 终端编码
     * 表字段 : welldone_reward_regist.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : welldone_reward_regist.terminal_name
     */
    private String terminalName;

    /**
     * 终端联系人
     * 表字段 : welldone_reward_regist.terminal_contact
     */
    private String terminalContact;

    /**
     * 具体地址
     * 表字段 : welldone_reward_regist.address_detail
     */
    private String addressDetail;

    /**
     * 产品编码
     * 表字段 : welldone_reward_regist.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : welldone_reward_regist.product_name
     */
    private String productName;

    /**
     * 固定电话
     * 表字段 : welldone_reward_apply.tel
     */
    private String tel;

    /**
     * 移动电话
     * 表字段 : welldone_reward_apply.mobile_phone
     */
    private String mobilePhone;

    /**
     * 供货价
     * 表字段 : welldone_reward_regist.supply_price
     */
    private BigDecimal supplyPrice;

    /**
     * 结算价(分)
     * 表字段 : welldone_reward_regist.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 本次登记数量
     * 表字段 : welldone_reward_regist.buy_num
     */
    private Integer buyNum;

    /**
     * 厂方承担比例
     * 表字段 : welldone_reward_regist.company_scale
     */
    private Double companyScale;

    /**
     * 厂方承担金额(分)
     * 表字段 : welldone_reward_regist.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 保量力度
     * 表字段 : welldone_reward_regist.limit_quantity_scale
     */
    private Double limitQuantityScale;

    /**
     * 单瓶包量力度
     * 表字段 : welldone_reward_regist.dp_limit_quantity_scale
     */
    private BigDecimal dpLimitQuantityScale;

    /**
     * 厂方单瓶返利上限(分)
     * 表字段 : welldone_reward_regist.limit_company_rebate
     */
    private BigDecimal limitCompanyRebate;

    /**
     * 包销量(分)
     * 表字段 : welldone_reward_regist.product_price
     */
    private BigDecimal productPrice;

    /**
     * 审核金额
     * 表字段 : welldone_reward_regist.audit_amount
     */
    private BigDecimal auditAmount;

    /**
     * 行项目余额(分)
     * 表字段 : welldone_reward_regist.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 行备注
     * 表字段 : welldone_reward_regist.notes
     */
    private String ntoes;

    /**
     *
     * 表字段 : welldone_reward_regist.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : welldone_reward_regist.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : welldone_reward_regist.create_date
     */
    private Date createDate;

    /**
     *
     * 表字段 : welldone_reward_regist.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : welldone_reward_regist.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : welldone_reward_regist.modify_date
     */
    private Date modifyDate;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table welldone_reward_regist
     *
     * @mbggenerated Fri May 12 15:46:42 CST 2017
     */
    private static final long serialVersionUID = 1L;


    /**
     *
     * 表字段 : welldone_reward_regist.id
     */
    public Integer getId() {
        return this.id;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.id
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 登记单号
     * 表字段 : welldone_reward_regist.regist_no
     */
    public String getRegistNo() {
        return this.registNo;
    }

    /**
     * 登记单号
     * 表字段 : welldone_reward_regist.regist_no
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 行号
     * 表字段 : welldone_reward_apply.item_no
     */
    public Integer getItemNo() {
        return this.itemNo;
    }

    /**
     * 行号
     * 表字段 : welldone_reward_apply.item_no
     */
    public void setItemNo(Integer itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 申请单号
     * 表字段 : welldone_reward_regist.apply_no
     */
    public String getApplyNo() {
        return this.applyNo;
    }

    /**
     * 申请单号
     * 表字段 : welldone_reward_regist.apply_no
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 申请单行号
     * 表字段 : welldone_reward_regist.apply_item_no
     */
    public String getApplyItemNo() {
        return this.applyItemNo;
    }

    /**
     * 申请单行号
     * 表字段 : welldone_reward_regist.apply_item_no
     */
    public void setApplyItemNo(String applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    /**
     * 费用类型编码
     * 表字段 : welldone_reward_regist.cost_type_id
     */
    public String getCostTypeId() {
        return this.costTypeId;
    }

    /**
     * 费用类型编码
     * 表字段 : welldone_reward_regist.cost_type_id
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 费用类型名称
     * 表字段 : welldone_reward_regist.cost_type_name
     */
    public String getCostTypeName() {
        return this.costTypeName;
    }

    /**
     * 费用类型名称
     * 表字段 : welldone_reward_regist.cost_type_name
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 开始时间
     * 表字段 : welldone_reward_regist.s_date
     */
    public Date getsDate() {
        return this.sDate;
    }

    /**
     * 开始时间
     * 表字段 : welldone_reward_regist.s_date
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 结束时间
     * 表字段 : welldone_reward_regist.e_date
     */
    public Date geteDate() {
        return this.eDate;
    }

    /**
     * 结束时间
     * 表字段 : welldone_reward_regist.e_date
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 终端编码
     * 表字段 : welldone_reward_regist.terminal_id
     */
    public String getTerminalId() {
        return this.terminalId;
    }

    /**
     * 终端编码
     * 表字段 : welldone_reward_regist.terminal_id
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 终端名称
     * 表字段 : welldone_reward_regist.terminal_name
     */
    public String getTerminalName() {
        return this.terminalName;
    }

    /**
     * 终端名称
     * 表字段 : welldone_reward_regist.terminal_name
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 终端联系人
     * 表字段 : welldone_reward_regist.terminal_contact
     */
    public String getTerminalContact() {
        return this.terminalContact;
    }

    /**
     * 终端联系人
     * 表字段 : welldone_reward_regist.terminal_contact
     */
    public void setTerminalContact(String terminalContact) {
        this.terminalContact = terminalContact;
    }

    /**
     * 具体地址
     * 表字段 : welldone_reward_regist.address_detail
     */
    public String getAddressDetail() {
        return this.addressDetail;
    }

    /**
     * 具体地址
     * 表字段 : welldone_reward_regist.address_detail
     */
    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    /**
     * 产品编码
     * 表字段 : welldone_reward_regist.product_id
     */
    public String getProductId() {
        return this.productId;
    }

    /**
     * 产品编码
     * 表字段 : welldone_reward_regist.product_id
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 产品名称
     * 表字段 : welldone_reward_regist.product_name
     */
    public String getProductName() {
        return this.productName;
    }

    /**
     * 产品名称
     * 表字段 : welldone_reward_regist.product_name
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 供货价
     * 表字段 : welldone_reward_regist.supply_price
     */
    public BigDecimal getSupplyPrice() {
        return this.supplyPrice;
    }

    /**
     * 供货价
     * 表字段 : welldone_reward_regist.supply_price
     */
    public void setSupplyPrice(BigDecimal supplyPrice) {
        this.supplyPrice = supplyPrice;
    }

    /**
     * 结算价(分)
     * 表字段 : welldone_reward_regist.settlement_price
     */
    public BigDecimal getSettlementPrice() {
        if( this.settlementPrice != null) {
            return (this.settlementPrice.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.settlementPrice;
    }

    /**
     * 结算价(分)
     * 表字段 : welldone_reward_regist.settlement_price
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 本次登记数量
     * 表字段 : welldone_reward_regist.buy_num
     */
    public Integer getBuyNum() {
        return this.buyNum;
    }

    /**
     * 本次登记数量
     * 表字段 : welldone_reward_regist.buy_num
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 厂方承担比例
     * 表字段 : welldone_reward_regist.company_scale
     */
    public Double getCompanyScale() {
        return this.companyScale;
    }

    /**
     * 厂方承担比例
     * 表字段 : welldone_reward_regist.company_scale
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }

    /**
     * 厂方承担金额(分)
     * 表字段 : welldone_reward_regist.company_amount
     */
    public BigDecimal getCompanyAmount() {
        return this.companyAmount;
    }

    /**
     * 厂方承担金额(分)
     * 表字段 : welldone_reward_regist.company_amount
     */
    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 保量力度
     * 表字段 : welldone_reward_regist.limit_quantity_scale
     */
    public Double getLimitQuantityScale() {
        return this.limitQuantityScale;
    }

    /**
     * 保量力度
     * 表字段 : welldone_reward_regist.limit_quantity_scale
     */
    public void setLimitQuantityScale(Double limitQuantityScale) {
        this.limitQuantityScale = limitQuantityScale;
    }

    /**
     * 单瓶包量力度
     * 表字段 : welldone_reward_regist.dp_limit_quantity_scale
     */
    public BigDecimal getDpLimitQuantityScale() {
        if( this.dpLimitQuantityScale != null) {
            return (this.dpLimitQuantityScale.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.dpLimitQuantityScale;
    }

    /**
     * 单瓶包量力度
     * 表字段 : welldone_reward_regist.dp_limit_quantity_scale
     */
    public void setDpLimitQuantityScale(BigDecimal dpLimitQuantityScale) {
        this.dpLimitQuantityScale = dpLimitQuantityScale;
    }

    /**
     * 厂方单瓶返利上限(分)
     * 表字段 : welldone_reward_regist.limit_company_rebate
     */
    public BigDecimal getLimitCompanyRebate() {
        return this.limitCompanyRebate;
    }

    /**
     * 厂方单瓶返利上限(分)
     * 表字段 : welldone_reward_regist.limit_company_rebate
     */
    public void setLimitCompanyRebate(BigDecimal limitCompanyRebate) {
        this.limitCompanyRebate = limitCompanyRebate;
    }

    /**
     * 包销量(分)
     * 表字段 : welldone_reward_regist.product_price
     */
    public BigDecimal getProductPrice() {
        if( this.productPrice != null) {
            return (this.productPrice.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.productPrice;
    }

    /**
     * 包销量(分)
     * 表字段 : welldone_reward_regist.product_price
     */
    public void setProductPrice(BigDecimal productPrice) {
        this.productPrice = productPrice;
    }

    /**
     * 审核金额
     * 表字段 : welldone_reward_regist.audit_amount
     */
    public BigDecimal getAuditAmount() {
        return this.auditAmount;
    }

    /**
     * 审核金额
     * 表字段 : welldone_reward_regist.audit_amount
     */
    public void setAuditAmount(BigDecimal auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 行项目余额(分)
     * 表字段 : welldone_reward_regist.item_balance
     */
    public BigDecimal getItemBalance() {
        if( this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return this.itemBalance;
    }

    /**
     * 行项目余额(分)
     * 表字段 : welldone_reward_regist.item_balance
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 行备注
     * 表字段 : welldone_reward_regist.notes
     */
    public String getNtoes() {
        return this.ntoes;
    }

    /**
     * 行备注
     * 表字段 : welldone_reward_regist.notes
     */
    public void setNtoes(String ntoes) {
        this.ntoes = ntoes;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.create_id
     */
    public String getCreateId() {
        return this.createId;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.create_id
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.create_name
     */
    public String getCreateName() {
        return this.createName;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.create_name
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.create_date
     */
    public Date getCreateDate() {
        return this.createDate;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.create_date
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.modify_id
     */
    public String getModifyId() {
        return this.modifyId;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.modify_id
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.modify_name
     */
    public String getModifyName() {
        return this.modifyName;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.modify_name
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.modify_date
     */
    public Date getModifyDate() {
        return this.modifyDate;
    }

    /**
     *
     * 表字段 : welldone_reward_regist.modify_date
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 申请单id
     */
    public Integer getApplyId() {
        return this.applyId;
    }

    /**
     * 设置 申请单id
     */
    public void setApplyId(Integer applyId) {
        this.applyId = applyId;
    }

    /**
     * 固定电话
     * 表字段 : welldone_reward_apply.tel
     */
    public String getTel() {
        return this.tel;
    }

    /**
     * 固定电话
     * 表字段 : welldone_reward_apply.tel
     */
    public void setTel(String tel) {
        this.tel = tel;
    }

    /**
     * 移动电话
     * 表字段 : welldone_reward_apply.mobile_phone
     */
    public String getMobilePhone() {
        return this.mobilePhone;
    }

    /**
     * 移动电话
     * 表字段 : welldone_reward_apply.mobile_phone
     */
    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }
}