package com.chinayanghe.tpm.cost.vo.out.datadetail.pay;

import com.chinayanghe.tpm.cost.vo.out.datadetail.regist.ChannelCustomerRelRegistVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 渠道客情维系核报Vo
 * Created by Jay on 2017/6/13.
 */
public class ChannelCustomerRelPayVo implements Serializable {


    private ChannelCustomerRelRegistVo registVo;

    /**
     *
     * 表字段 : channel_customer_rel_pay.id
     */
    private Integer id;

    private Integer registId;

    private Double registCompanyScale;

    private Integer registPlanWineNum;

    /**
     *
     * 表字段 : channel_customer_rel_pay.pay_no
     */
    private String payNo;

    /**
     *
     * 表字段 : channel_customer_rel_pay.regist_no
     */
    private String registNo;

    /**
     *
     * 表字段 : channel_customer_rel_pay.regist_item_no
     */
    private Integer registItemNo;

    /**
     *
     * 表字段 : channel_customer_rel_pay.apply_no
     */
    private String applyNo;

    /**
     *
     * 表字段 : channel_customer_rel_pay.cost_type_id
     */
    private String costTypeId;

    /**
     *
     * 表字段 : channel_customer_rel_pay.cost_type_name
     */
    private String costTypeName;

    /**
     *
     * 表字段 : channel_customer_rel_pay.product_name
     */
    private String productName;

    /**
     * 场地名称(渠道类型)
     * 表字段 : channel_customer_rel_pay.field_name
     */
    private String fieldName;

    /**
     * 赠饮名称及数量
     * 表字段 : channel_customer_rel_pay.gift_name_num
     */
    private String giftNameNum;

    /**
     *
     * 表字段 : channel_customer_rel_pay.product_id
     */
    private String productId;

    /**
     * 核报金额
     * 表字段 : channel_customer_rel_pay.pay_amount
     */
    private BigDecimal payAmount;

    /**
     * 结算价
     * 表字段 : channel_customer_rel_pay.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 厂方承担比例
     * 表字段 : channel_customer_rel_pay.company_scale
     */
    private Double companyScale;


    /**
     * 宴会通单号
     * 表字段 : channel_customer_rel_pay.feast_form_no
     */
    private String feastFormNo;


    /**
     * 宴会通确认金额
     * 表字段 : channel_customer_rel_pay.feast_price
     */
    private Integer feastPrice;

    /**
     * 日期
     * 表字段 : channel_customer_rel_pay.gmt_date
     */
    private Date gmtDate;

    /**
     *
     * 表字段 : channel_customer_rel_pay.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : channel_customer_rel_pay.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : channel_customer_rel_pay.create_date
     */
    private Date createDate;

    /**
     *
     * 表字段 : channel_customer_rel_pay.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : channel_customer_rel_pay.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : channel_customer_rel_pay.modify_date
     */
    private Date modifyDate;

    /**
     * 行项目余额
     * 表字段 : channel_customer_rel_pay.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 行项目号
     * 表字段 : channel_customer_rel_pay.item_no
     */
    private Integer itemNo;

    /**
     * 餐费金额
     * 表字段 : channel_customer_rel_pay.plan_meals
     */
    private BigDecimal planMeals;

    /**
     * 用酒金额
     * 表字段 : channel_customer_rel_pay.cost_wine_price
     */
    private BigDecimal costWinePrice;

    /**
     * 核报数量（用酒数量）
     * 表字段 : channel_customer_rel_pay.plan_wine_num
     */
    private Integer planWineNum;


    public Integer getRegistId() {
        return registId;
    }

    public void setRegistId(Integer registId) {
        this.registId = registId;
    }


    public void setRegistCompanyScale(Double registCompanyScale) {
        this.registCompanyScale = registCompanyScale;
    }

    public Integer getRegistPlanWineNum() {
        return registPlanWineNum;
    }

    public void setRegistPlanWineNum(Integer registPlanWineNum) {
        this.registPlanWineNum = registPlanWineNum;
    }

    /**
     * 督查意见
     * 表字段 : channel_customer_rel_pay.audit_notes
     */
    private String auditNotes;

    /**
     * 获取  字段:channel_customer_rel_pay.id
     *
     * @return channel_customer_rel_pay.id,
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.id
     *
     * @param id the value for channel_customer_rel_pay.id,
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.pay_no
     *
     * @return channel_customer_rel_pay.pay_no,
     */
    public String getPayNo() {
        return payNo;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.pay_no
     *
     * @param payNo the value for channel_customer_rel_pay.pay_no,
     */
    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.regist_no
     *
     * @return channel_customer_rel_pay.regist_no,
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.regist_no
     *
     * @param registNo the value for channel_customer_rel_pay.regist_no,
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.regist_item_no
     *
     * @return channel_customer_rel_pay.regist_item_no,
     */
    public Integer getRegistItemNo() {
        return registItemNo;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.regist_item_no
     *
     * @param registItemNo the value for channel_customer_rel_pay.regist_item_no,
     */
    public void setRegistItemNo(Integer registItemNo) {
        this.registItemNo = registItemNo;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.apply_no
     *
     * @return channel_customer_rel_pay.apply_no,
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.apply_no
     *
     * @param applyNo the value for channel_customer_rel_pay.apply_no,
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.cost_type_id
     *
     * @return channel_customer_rel_pay.cost_type_id,
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.cost_type_id
     *
     * @param costTypeId the value for channel_customer_rel_pay.cost_type_id,
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.cost_type_name
     *
     * @return channel_customer_rel_pay.cost_type_name,
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.cost_type_name
     *
     * @param costTypeName the value for channel_customer_rel_pay.cost_type_name,
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.product_name
     *
     * @return channel_customer_rel_pay.product_name,
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.product_name
     *
     * @param productName the value for channel_customer_rel_pay.product_name,
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.product_id
     *
     * @return channel_customer_rel_pay.product_id,
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.product_id
     *
     * @param productId the value for channel_customer_rel_pay.product_id,
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 核报金额 字段:channel_customer_rel_pay.pay_amount
     *
     * @return channel_customer_rel_pay.pay_amount, 核报金额
     */
    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    /**
     * 设置 核报金额 字段:channel_customer_rel_pay.pay_amount
     *
     * @param payAmount the value for channel_customer_rel_pay.pay_amount, 核报金额
     */
    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    /**
     * 获取 结算价 字段:channel_customer_rel_pay.settlement_price
     *
     * @return channel_customer_rel_pay.settlement_price, 结算价
     */
    public BigDecimal getSettlementPrice() {
        if( this.settlementPrice != null) {
            return (this.settlementPrice.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return settlementPrice;
    }

    /**
     * 设置 结算价 字段:channel_customer_rel_pay.settlement_price
     *
     * @param settlementPrice the value for channel_customer_rel_pay.settlement_price, 结算价
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 获取 厂方承担比例 字段:channel_customer_rel_pay.company_scale
     *
     * @return channel_customer_rel_pay.company_scale, 厂方承担比例
     */
    public Double getCompanyScale() {
        return companyScale;
    }

    /**
     * 设置 厂方承担比例 字段:channel_customer_rel_pay.company_scale
     *
     * @param companyScale the value for channel_customer_rel_pay.company_scale, 厂方承担比例
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.create_id
     *
     * @return channel_customer_rel_pay.create_id,
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.create_id
     *
     * @param createId the value for channel_customer_rel_pay.create_id,
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.create_name
     *
     * @return channel_customer_rel_pay.create_name,
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.create_name
     *
     * @param createName the value for channel_customer_rel_pay.create_name,
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.create_date
     *
     * @return channel_customer_rel_pay.create_date,
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.create_date
     *
     * @param createDate the value for channel_customer_rel_pay.create_date,
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.modify_id
     *
     * @return channel_customer_rel_pay.modify_id,
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.modify_id
     *
     * @param modifyId the value for channel_customer_rel_pay.modify_id,
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.modify_name
     *
     * @return channel_customer_rel_pay.modify_name,
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.modify_name
     *
     * @param modifyName the value for channel_customer_rel_pay.modify_name,
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:channel_customer_rel_pay.modify_date
     *
     * @return channel_customer_rel_pay.modify_date,
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:channel_customer_rel_pay.modify_date
     *
     * @param modifyDate the value for channel_customer_rel_pay.modify_date,
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 行项目余额 字段:channel_customer_rel_pay.item_balance
     *
     * @return channel_customer_rel_pay.item_balance, 行项目余额
     */
    public BigDecimal getItemBalance() {
        return this.itemBalance;
    }

    /**
     * 设置 行项目余额 字段:channel_customer_rel_pay.item_balance
     *
     * @param itemBalance the value for channel_customer_rel_pay.item_balance, 行项目余额
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 行项目号 字段:channel_customer_rel_pay.item_no
     *
     * @return channel_customer_rel_pay.item_no, 行项目号
     */
    public Integer  getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:channel_customer_rel_pay.item_no
     *
     * @param itemNo the value for channel_customer_rel_pay.item_no, 行项目号
     */
    public void setItemNo(Integer  itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 餐费金额 字段:channel_customer_rel_pay.plan_meals
     *
     * @return channel_customer_rel_pay.plan_meals, 餐费金额
     */
    public BigDecimal getPlanMeals() {
        if( this.planMeals != null) {
            return (this.planMeals.divide(new BigDecimal(100),2, RoundingMode.HALF_UP));
        }
        return  this.planMeals;
    }

    /**
     * 设置 餐费金额 字段:channel_customer_rel_pay.plan_meals
     *
     * @param planMeals the value for channel_customer_rel_pay.plan_meals, 餐费金额
     */
    public void setPlanMeals(BigDecimal planMeals) {
        this.planMeals = planMeals;
    }

    /**
     * 获取 用酒金额 字段:channel_customer_rel_pay.cost_wine_price
     *
     * @return channel_customer_rel_pay.cost_wine_price, 用酒金额
     */
    public BigDecimal getCostWinePrice() {
        return this.costWinePrice;
    }

    /**
     * 设置 用酒金额 字段:channel_customer_rel_pay.cost_wine_price
     *
     * @param costWinePrice the value for channel_customer_rel_pay.cost_wine_price, 用酒金额
     */
    public void setCostWinePrice(BigDecimal costWinePrice) {
        this.costWinePrice = costWinePrice;
    }

    /**
     * 获取 核报数量（用酒数量） 字段:channel_customer_rel_pay.plan_wine_num
     *
     * @return channel_customer_rel_pay.plan_wine_num, 核报数量（用酒数量）
     */
    public Integer getPlanWineNum() {
        return planWineNum;
    }

    /**
     * 设置 核报数量（用酒数量） 字段:channel_customer_rel_pay.plan_wine_num
     *
     * @param planWineNum the value for channel_customer_rel_pay.plan_wine_num, 核报数量（用酒数量）
     */
    public void setPlanWineNum(Integer planWineNum) {
        this.planWineNum = planWineNum;
    }

    /**
     * 获取 督查意见 字段:channel_customer_rel_pay.audit_notes
     *
     * @return channel_customer_rel_pay.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 获取 场地名称(渠道类型) 字段:channel_customer_rel_pay.field_name
     *
     * @return channel_customer_rel_pay.field_name, 场地名称(渠道类型)
     */
    public String getFieldName() {
        return fieldName;
    }

    /**
     * 设置 场地名称(渠道类型) 字段:channel_customer_rel_pay.field_name
     *
     * @param fieldName the value for channel_customer_rel_pay.field_name, 场地名称(渠道类型)
     */
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    /**
     * 获取 赠饮名称及数量 字段:channel_customer_rel_pay.gift_name_num
     *
     * @return channel_customer_rel_pay.gift_name_num, 赠饮名称及数量
     */
    public String getGiftNameNum() {
        return giftNameNum;
    }

    /**
     * 设置 赠饮名称及数量 字段:channel_customer_rel_pay.gift_name_num
     *
     * @param giftNameNum the value for channel_customer_rel_pay.gift_name_num, 赠饮名称及数量
     */
    public void setGiftNameNum(String giftNameNum) {
        this.giftNameNum = giftNameNum;
    }

    /**
     * 设置 督查意见 字段:channel_customer_rel_pay.audit_notes
     *
     * @param auditNotes the value for channel_customer_rel_pay.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    public String getFeastFormNo() {
        return feastFormNo;
    }

    public void setFeastFormNo(String feastFormNo) {
        this.feastFormNo = feastFormNo;
    }

    public Integer getFeastPrice() {
        return feastPrice;
    }

    public void setFeastPrice(Integer feastPrice) {
        this.feastPrice = feastPrice;
    }

    public Date getGmtDate() {
        return gmtDate;
    }

    public void setGmtDate(Date gmtDate) {
        this.gmtDate = gmtDate;
    }

    public ChannelCustomerRelRegistVo getRegistVo() {
        return registVo;
    }

    public void setRegistVo(ChannelCustomerRelRegistVo registVo) {
        this.registVo = registVo;
    }
}
