package com.chinayanghe.tpm.cost.vo.out.datadetail.pay;


import com.chinayanghe.tpm.cost.vo.out.datadetail.regist.PersonalReviewApplyVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 个人品鉴核报Vo
 * Created Jay tp on 2017/5/16.
 */
public class PersonalReviewPayVo implements Serializable {

    private PersonalReviewApplyVo registVo;
    /**
     *
     * 表字段 : personal_review_pay.id
     */
    private Integer id;

    /**
     * 核报单号
     * 表字段 : personal_review_pay.pay_no
     */
    private String payNo;

    /**
     * 申请单号
     * 表字段 : personal_review_pay.apply_no
     */
    private String applyNo;

    /**
     * 费用类型编码
     * 表字段 : personal_review_pay.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : personal_review_pay.cost_type_name
     */
    private String costTypeName;

    /**
     * 产品编码
     * 表字段 : personal_review_pay.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : personal_review_pay.product_name
     */
    private String productName;

    /**
     * 已赠饮品种
     * 表字段 : personal_review_pay.product_gift_type
     */
    private String productGiftType;

    /**
     * 已销售品种
     * 表字段 : personal_review_pay.product_sale_type
     */
    private String productSaleType;

    /**
     * 本次赠饮数量
     * 表字段 : personal_review_pay.buy_num
     */
    private Integer buyNum;

    /**
     * 结算价(分)
     * 表字段 : personal_review_pay.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 申请金额(分)
     * 表字段 : personal_review_pay.apply_amount
     */
    private BigDecimal applyAmount;

    /**
     * 审核金额(分)
     * 表字段 : personal_review_pay.audit_amount
     */
    private BigDecimal auditAmount;

    /**
     *
     * 表字段 : personal_review_pay.company_scale
     */
    private Double companyScale;

    /**
     * 厂方承担金额(分)
     * 表字段 : personal_review_pay.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 核报金额(分)
     * 表字段 : personal_review_pay.pay_amount
     */
    private BigDecimal payAmount;

    /**
     * 是否实施(0否,1是)
     * 表字段 : personal_review_pay.is_impl
     */
    private String  isImpl;

    /**
     * 督查意见
     * 表字段 : personal_review_pay.audit_notes
     */
    private String auditNotes;

    /**
     *
     * 表字段 : personal_review_pay.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : personal_review_pay.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : personal_review_pay.create_date
     */
    private Date createDate;

    /**
     *
     * 表字段 : personal_review_pay.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : personal_review_pay.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : personal_review_pay.modify_date
     */
    private Date modifyDate;

    /**
     * 行项目余额(分)
     * 表字段 : personal_review_pay.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 行项目号
     * 表字段 : personal_review_pay.item_no
     */
    private Integer itemNo;

    /**
     * 申请单行项目号
     * 表字段 : personal_review_pay.apply_item_no
     */
    private Integer applyItemNo;

    /**
     * 获取  字段:personal_review_pay.id
     *
     * @return personal_review_pay.id,
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:personal_review_pay.id
     *
     * @param id the value for personal_review_pay.id,
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 核报单号 字段:personal_review_pay.pay_no
     *
     * @return personal_review_pay.pay_no, 核报单号
     */
    public String getPayNo() {
        return payNo;
    }

    /**
     * 设置 核报单号 字段:personal_review_pay.pay_no
     *
     * @param payNo the value for personal_review_pay.pay_no, 核报单号
     */
    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    /**
     * 获取 申请单号 字段:personal_review_pay.apply_no
     *
     * @return personal_review_pay.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:personal_review_pay.apply_no
     *
     * @param applyNo the value for personal_review_pay.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 费用类型编码 字段:personal_review_pay.cost_type_id
     *
     * @return personal_review_pay.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:personal_review_pay.cost_type_id
     *
     * @param costTypeId the value for personal_review_pay.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:personal_review_pay.cost_type_name
     *
     * @return personal_review_pay.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:personal_review_pay.cost_type_name
     *
     * @param costTypeName the value for personal_review_pay.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 产品编码 字段:personal_review_pay.product_id
     *
     * @return personal_review_pay.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:personal_review_pay.product_id
     *
     * @param productId the value for personal_review_pay.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:personal_review_pay.product_name
     *
     * @return personal_review_pay.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:personal_review_pay.product_name
     *
     * @param productName the value for personal_review_pay.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 已赠饮品种 字段:personal_review_pay.product_gift_type
     *
     * @return personal_review_pay.product_gift_type, 已赠饮品种
     */
    public String getProductGiftType() {
        return productGiftType;
    }

    /**
     * 设置 已赠饮品种 字段:personal_review_pay.product_gift_type
     *
     * @param productGiftType the value for personal_review_pay.product_gift_type, 已赠饮品种
     */
    public void setProductGiftType(String productGiftType) {
        this.productGiftType = productGiftType;
    }

    /**
     * 获取 已销售品种 字段:personal_review_pay.product_sale_type
     *
     * @return personal_review_pay.product_sale_type, 已销售品种
     */
    public String getProductSaleType() {
        return productSaleType;
    }

    /**
     * 设置 已销售品种 字段:personal_review_pay.product_sale_type
     *
     * @param productSaleType the value for personal_review_pay.product_sale_type, 已销售品种
     */
    public void setProductSaleType(String productSaleType) {
        this.productSaleType = productSaleType;
    }

    /**
     * 获取 本次赠饮数量 字段:personal_review_pay.buy_num
     *
     * @return personal_review_pay.buy_num, 本次赠饮数量
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 本次赠饮数量 字段:personal_review_pay.buy_num
     *
     * @param buyNum the value for personal_review_pay.buy_num, 本次赠饮数量
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取 结算价(分) 字段:personal_review_pay.settlement_price
     *
     * @return personal_review_pay.settlement_price, 结算价(分)
     */
    public BigDecimal getSettlementPrice() {
        return settlementPrice;
    }

    /**
     * 设置 结算价(分) 字段:personal_review_pay.settlement_price
     *
     * @param settlementPrice the value for personal_review_pay.settlement_price, 结算价(分)
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 获取 申请金额(分) 字段:personal_review_pay.apply_amount
     *
     * @return personal_review_pay.apply_amount, 申请金额(分)
     */
    public BigDecimal getApplyAmount() {
        return applyAmount;
    }

    /**
     * 设置 申请金额(分) 字段:personal_review_pay.apply_amount
     *
     * @param applyAmount the value for personal_review_pay.apply_amount, 申请金额(分)
     */
    public void setApplyAmount(BigDecimal applyAmount) {
        this.applyAmount = applyAmount;
    }

    /**
     * 获取 审核金额(分) 字段:personal_review_pay.audit_amount
     *
     * @return personal_review_pay.audit_amount, 审核金额(分)
     */
    public BigDecimal getAuditAmount() {
        return this.auditAmount;
    }

    /**
     * 设置 审核金额(分) 字段:personal_review_pay.audit_amount
     *
     * @param auditAmount the value for personal_review_pay.audit_amount, 审核金额(分)
     */
    public void setAuditAmount(BigDecimal auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 获取  字段:personal_review_pay.company_scale
     *
     * @return personal_review_pay.company_scale,
     */
    public Double getCompanyScale() {
        return companyScale;
    }

    /**
     * 设置  字段:personal_review_pay.company_scale
     *
     * @param companyScale the value for personal_review_pay.company_scale,
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }

    /**
     * 获取 厂方承担金额(分) 字段:personal_review_pay.company_amount
     *
     * @return personal_review_pay.company_amount, 厂方承担金额(分)
     */
    public BigDecimal getCompanyAmount() {
        return this.companyAmount;
    }

    /**
     * 设置 厂方承担金额(分) 字段:personal_review_pay.company_amount
     *
     * @param companyAmount the value for personal_review_pay.company_amount, 厂方承担金额(分)
     */
    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 获取 核报金额(分) 字段:personal_review_pay.pay_amount
     *
     * @return personal_review_pay.pay_amount, 核报金额(分)
     */
    public BigDecimal getPayAmount() {
        return this.payAmount;
    }

    /**
     * 设置 核报金额(分) 字段:personal_review_pay.pay_amount
     *
     * @param payAmount the value for personal_review_pay.pay_amount, 核报金额(分)
     */
    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    /**
     * 获取 是否实施(0否,1是) 字段:personal_review_pay.is_impl
     *
     * @return personal_review_pay.is_impl, 是否实施(0否,1是)
     */
    public String getIsImpl() {
        return isImpl;
    }

    /**
     * 设置 是否实施(0否,1是) 字段:personal_review_pay.is_impl
     *
     * @param isImpl the value for personal_review_pay.is_impl, 是否实施(0否,1是)
     */
    public void setIsImpl(String isImpl) {
        this.isImpl = isImpl;
    }

    /**
     * 获取 督查意见 字段:personal_review_pay.audit_notes
     *
     * @return personal_review_pay.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:personal_review_pay.audit_notes
     *
     * @param auditNotes the value for personal_review_pay.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取  字段:personal_review_pay.create_id
     *
     * @return personal_review_pay.create_id,
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:personal_review_pay.create_id
     *
     * @param createId the value for personal_review_pay.create_id,
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:personal_review_pay.create_name
     *
     * @return personal_review_pay.create_name,
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:personal_review_pay.create_name
     *
     * @param createName the value for personal_review_pay.create_name,
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:personal_review_pay.create_date
     *
     * @return personal_review_pay.create_date,
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:personal_review_pay.create_date
     *
     * @param createDate the value for personal_review_pay.create_date,
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:personal_review_pay.modify_id
     *
     * @return personal_review_pay.modify_id,
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:personal_review_pay.modify_id
     *
     * @param modifyId the value for personal_review_pay.modify_id,
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:personal_review_pay.modify_name
     *
     * @return personal_review_pay.modify_name,
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:personal_review_pay.modify_name
     *
     * @param modifyName the value for personal_review_pay.modify_name,
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:personal_review_pay.modify_date
     *
     * @return personal_review_pay.modify_date,
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:personal_review_pay.modify_date
     *
     * @param modifyDate the value for personal_review_pay.modify_date,
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 行项目余额(分) 字段:personal_review_pay.item_balance
     *
     * @return personal_review_pay.item_balance, 行项目余额(分)
     */
    public BigDecimal getItemBalance() {
        return this.itemBalance;
    }

    /**
     * 设置 行项目余额(分) 字段:personal_review_pay.item_balance
     *
     * @param itemBalance the value for personal_review_pay.item_balance, 行项目余额(分)
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 行项目号 字段:personal_review_pay.item_no
     *
     * @return personal_review_pay.item_no, 行项目号
     */
    public Integer getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:personal_review_pay.item_no
     *
     * @param itemNo the value for personal_review_pay.item_no, 行项目号
     */
    public void setItemNo(Integer itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 申请单行项目号 字段:personal_review_pay.apply_item_no
     *
     * @return personal_review_pay.apply_item_no, 申请单行项目号
     */
    public Integer getApplyItemNo() {
        return applyItemNo;
    }

    /**
     * 设置 申请单行项目号 字段:personal_review_pay.apply_item_no
     *
     * @param applyItemNo the value for personal_review_pay.apply_item_no, 申请单行项目号
     */
    public void setApplyItemNo(Integer applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    public PersonalReviewPayVo(Integer id, String applyNo, String costTypeName, String productId, String productName, String productGiftType, String productSaleType, Integer buyNum, BigDecimal applyAmount, BigDecimal auditAmount, Double companyScale, Integer applyItemNo, BigDecimal settlementPrice) {
        this.id = id;
        this.applyNo = applyNo;
        this.costTypeName = costTypeName;
        this.productId = productId;
        this.productName = productName;
        this.productGiftType = productGiftType;
        this.productSaleType = productSaleType;
        this.buyNum = buyNum;
        this.applyAmount = applyAmount;
        this.auditAmount = auditAmount;
        this.companyScale = companyScale;
        this.applyItemNo = applyItemNo;
        this.settlementPrice = settlementPrice;
    }

    public PersonalReviewPayVo(String applyNo) {
        this.applyNo = applyNo;
    }

    public PersonalReviewPayVo() {
    }
}
