package com.chinayanghe.tpm.cost.vo.out.datadetail.pay;

import com.chinayanghe.tpm.cost.vo.out.datadetail.regist.TroopCareRegistVo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 部队慰问核报单
 * TroopCarePayDto
 * 数据库表：troop_care_pay
 */
public class TroopCarePayVo implements Serializable {


    private TroopCareRegistVo registVo;
    /**
     *
     * 表字段 : troop_care_pay.id
     */
    private Integer id;


    /**
     * 核报单号
     * 表字段 : troop_care_pay.pay_no
     */
    private String payNo;

    /**
     * 登记单号
     * 表字段 : troop_care_pay.regist_no
     */
    private String registNo;

    /**
     * 登记单行项目号
     * 表字段 : troop_care_pay.regist_item_no
     */
    private String registItemNo;

    /**
     * 申请单号
     * 表字段 : troop_care_pay.apply_no
     */
    private String applyNo;

    /**
     * 费用类型编码
     * 表字段 : troop_care_pay.cost_type_id
     */
    private String costTypeId;

    /**
     * 费用类型名称
     * 表字段 : troop_care_pay.cost_type_name
     */
    private String costTypeName;

    /**
     * 产品编码
     * 表字段 : troop_care_pay.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : troop_care_pay.product_name
     */
    private String productName;

    /**
     * 购买数量
     * 表字段 : troop_care_pay.buy_num
     */
    private Integer buyNum;

    /**
     * 结算价(分)
     * 表字段 : troop_care_pay.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 总金额(分)
     * 表字段 : troop_care_pay.total_amount
     */
    private BigDecimal totalAmount;

    /**
     * 核报金额(分)
     * 表字段 : troop_care_pay.pay_amount
     */
    private BigDecimal payAmount;

    /**
     * 督查意见
     * 表字段 : troop_care_pay.audit_notes
     */
    private String auditNotes;

    /**
     *
     * 表字段 : troop_care_pay.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : troop_care_pay.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : troop_care_pay.create_date
     */
    private Date createDate;

    /**
     *
     * 表字段 : troop_care_pay.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : troop_care_pay.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : troop_care_pay.modify_date
     */
    private Date modifyDate;

    /**
     * 行项目号
     * 表字段 : troop_care_pay.item_no
     */
    private String itemNo;

    /**
     * 行项目余额
     * 表字段 : troop_care_pay.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 厂方承担比例
     * 表字段 : troop_care_pay.compay_scale
     */
    private Double compayScale;

    /**
     * 产品类型(0定制，1高端)
     * 表字段 : troop_care_pay.product_type
     */
    private Byte productType;

    /**
     * 获取  字段:troop_care_pay.id
     *
     * @return troop_care_pay.id,
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:troop_care_pay.id
     *
     * @param id the value for troop_care_pay.id,
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 核报单号 字段:troop_care_pay.pay_no
     *
     * @return troop_care_pay.pay_no, 核报单号
     */
    public String getPayNo() {
        return payNo;
    }

    /**
     * 设置 核报单号 字段:troop_care_pay.pay_no
     *
     * @param payNo the value for troop_care_pay.pay_no, 核报单号
     */
    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    /**
     * 获取 登记单号 字段:troop_care_pay.regist_no
     *
     * @return troop_care_pay.regist_no, 登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 登记单号 字段:troop_care_pay.regist_no
     *
     * @param registNo the value for troop_care_pay.regist_no, 登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取 登记单行项目号 字段:troop_care_pay.regist_item_no
     *
     * @return troop_care_pay.regist_item_no, 登记单行项目号
     */
    public String getRegistItemNo() {
        return registItemNo;
    }

    /**
     * 设置 登记单行项目号 字段:troop_care_pay.regist_item_no
     *
     * @param registItemNo the value for troop_care_pay.regist_item_no, 登记单行项目号
     */
    public void setRegistItemNo(String registItemNo) {
        this.registItemNo = registItemNo;
    }

    /**
     * 获取 申请单号 字段:troop_care_pay.apply_no
     *
     * @return troop_care_pay.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:troop_care_pay.apply_no
     *
     * @param applyNo the value for troop_care_pay.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 费用类型编码 字段:troop_care_pay.cost_type_id
     *
     * @return troop_care_pay.cost_type_id, 费用类型编码
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置 费用类型编码 字段:troop_care_pay.cost_type_id
     *
     * @param costTypeId the value for troop_care_pay.cost_type_id, 费用类型编码
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取 费用类型名称 字段:troop_care_pay.cost_type_name
     *
     * @return troop_care_pay.cost_type_name, 费用类型名称
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置 费用类型名称 字段:troop_care_pay.cost_type_name
     *
     * @param costTypeName the value for troop_care_pay.cost_type_name, 费用类型名称
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 产品编码 字段:troop_care_pay.product_id
     *
     * @return troop_care_pay.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:troop_care_pay.product_id
     *
     * @param productId the value for troop_care_pay.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:troop_care_pay.product_name
     *
     * @return troop_care_pay.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:troop_care_pay.product_name
     *
     * @param productName the value for troop_care_pay.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 购买数量 字段:troop_care_pay.buy_num
     *
     * @return troop_care_pay.buy_num, 购买数量
     */
    public Integer getBuyNum() {
        return buyNum;
    }

    /**
     * 设置 购买数量 字段:troop_care_pay.buy_num
     *
     * @param buyNum the value for troop_care_pay.buy_num, 购买数量
     */
    public void setBuyNum(Integer buyNum) {
        this.buyNum = buyNum;
    }

    /**
     * 获取 结算价(分) 字段:troop_care_pay.settlement_price
     *
     * @return troop_care_pay.settlement_price, 结算价(分)
     */
    public BigDecimal getSettlementPrice() {
        if (this.settlementPrice != null) {
            return (this.settlementPrice.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.settlementPrice;
    }

    /**
     * 设置 结算价(分) 字段:troop_care_pay.settlement_price
     *
     * @param settlementPrice the value for troop_care_pay.settlement_price, 结算价(分)
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 获取 总金额(分) 字段:troop_care_pay.total_amount
     *
     * @return troop_care_pay.total_amount, 总金额(分)
     */
    public BigDecimal getTotalAmount() {
        if (this.totalAmount != null) {
            return (this.totalAmount.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.totalAmount;
    }

    /**
     * 设置 总金额(分) 字段:troop_care_pay.total_amount
     *
     * @param totalAmount the value for troop_care_pay.total_amount, 总金额(分)
     */
    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    /**
     * 获取 核报金额(分) 字段:troop_care_pay.pay_amount
     *
     * @return troop_care_pay.pay_amount, 核报金额(分)
     */
    public BigDecimal getPayAmount() {
        if (this.payAmount != null) {
            return (this.payAmount.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.payAmount;
    }

    /**
     * 设置 核报金额(分) 字段:troop_care_pay.pay_amount
     *
     * @param payAmount the value for troop_care_pay.pay_amount, 核报金额(分)
     */
    public void setPayAmount(BigDecimal payAmount) {
        this.payAmount = payAmount;
    }

    /**
     * 获取 督查意见 字段:troop_care_pay.audit_notes
     *
     * @return troop_care_pay.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:troop_care_pay.audit_notes
     *
     * @param auditNotes the value for troop_care_pay.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取  字段:troop_care_pay.create_id
     *
     * @return troop_care_pay.create_id,
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:troop_care_pay.create_id
     *
     * @param createId the value for troop_care_pay.create_id,
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:troop_care_pay.create_name
     *
     * @return troop_care_pay.create_name,
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:troop_care_pay.create_name
     *
     * @param createName the value for troop_care_pay.create_name,
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:troop_care_pay.create_date
     *
     * @return troop_care_pay.create_date,
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:troop_care_pay.create_date
     *
     * @param createDate the value for troop_care_pay.create_date,
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:troop_care_pay.modify_id
     *
     * @return troop_care_pay.modify_id,
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:troop_care_pay.modify_id
     *
     * @param modifyId the value for troop_care_pay.modify_id,
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:troop_care_pay.modify_name
     *
     * @return troop_care_pay.modify_name,
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:troop_care_pay.modify_name
     *
     * @param modifyName the value for troop_care_pay.modify_name,
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:troop_care_pay.modify_date
     *
     * @return troop_care_pay.modify_date,
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:troop_care_pay.modify_date
     *
     * @param modifyDate the value for troop_care_pay.modify_date,
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 行项目号 字段:troop_care_pay.item_no
     *
     * @return troop_care_pay.item_no, 行项目号
     */
    public String getItemNo() {
        return itemNo;
    }

    /**
     * 设置 行项目号 字段:troop_care_pay.item_no
     *
     * @param itemNo the value for troop_care_pay.item_no, 行项目号
     */
    public void setItemNo(String itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 行项目余额 字段:troop_care_pay.item_balance
     *
     * @return troop_care_pay.item_balance, 行项目余额
     */
    public BigDecimal getItemBalance() {
        if (this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.itemBalance;
    }

    /**
     * 设置 行项目余额 字段:troop_care_pay.item_balance
     *
     * @param itemBalance the value for troop_care_pay.item_balance, 行项目余额
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 厂方承担比例 字段:troop_care_pay.compay_scale
     *
     * @return troop_care_pay.compay_scale, 厂方承担比例
     */
    public Double getCompayScale() {
        return compayScale;
    }

    /**
     * 设置 厂方承担比例 字段:troop_care_pay.compay_scale
     *
     * @param compayScale the value for troop_care_pay.compay_scale, 厂方承担比例
     */
    public void setCompayScale(Double compayScale) {
        this.compayScale = compayScale;
    }

    /**
     * 获取 产品类型(0定制，1高端) 字段:troop_care_pay.product_type
     *
     * @return troop_care_pay.product_type, 产品类型(0定制，1高端)
     */
    public Byte getProductType() {
        return productType;
    }

    /**
     * 设置 产品类型(0定制，1高端) 字段:troop_care_pay.product_type
     *
     * @param productType the value for troop_care_pay.product_type, 产品类型(0定制，1高端)
     */
    public void setProductType(Byte productType) {
        this.productType = productType;
    }

    public TroopCareRegistVo getRegistVo() {
        return registVo;
    }

    public void setRegistVo(TroopCareRegistVo registVo) {
        this.registVo = registVo;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
