
package com.chinayanghe.tpm.cost.vo.out.datahead;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 费用-登记取证对象
 * @author arthur
 *
 */
public  class ActivityBaseInfoVo  implements Serializable{
	

	
	/**管理信息*/
	private ManageInfoVo manageInfo;
	
	/**财务信息*/
	private FinanceInfoApplyVo financeInfoApply;
	/**区域市场*/
	private List<AreaMarketingVo> areaMarketing;
	
	private FinaceInfoPayVo finaceInfoPay;
	
    /**
     * 
     * 表字段 : activity_base_info.id
     */
    private Integer id;

    /**
     * 表单号
     * 表字段 : activity_base_info.form_no
     */
    private String formNo;

    /**
     * 表单类型
     * 表字段 : activity_base_info.form_type
     */
    private String formType;

    /**
     * 开始日期
     * 表字段 : activity_base_info.s_date
     */
    private Date sDate;

    /**
     * 结束日期
     * 表字段 : activity_base_info.e_date
     */
    private Date eDate;

    /**
     * 客户编号
     * 表字段 : activity_base_info.kunnr
     */
    private String kunnr;

    private String TerminalType;
    /**
     * 经销商一级渠道
     * 表字段 : activity_base_info.level1_channel
     */
    private String level1Channel;

    /**
     * 经销商2级渠道
     * 表字段 : activity_base_info.level2_channel
     */
    private String level2Channel;

    /**
     * 品牌大类
     * 表字段 : activity_base_info.spart
     */
    private String spart;

    /**
     * 活动类型编码
     * 表字段 : activity_base_info.activity_type_code
     */
    private String activityTypeCode;

    /**
     * 活动类型名称
     * 表字段 : activity_base_info.activity_type_name
     */
    private String activityTypeName;

    /**
     * 
     * 表字段 : activity_base_info.activity_type_code_sub
     */
    private String activityTypeCodeSub;

    /**
     * 活动类型2级编码
     * 表字段 : activity_base_info.activity_type_name_sub
     */
    private String activityTypeNameSub;

    /**
     * 经销商编号
     * 表字段 : activity_base_info.dealer_id
     */
    private String dealerId;

    /**
     * 经销商名称
     * 表字段 : activity_base_info.dealer_name
     */
    private String dealerName;

    /**
     * 
     * 表字段 : activity_base_info.dealer_type
     */
    private String dealerType;

    /**
     * 区域市场(行政区域，多个以，号分割)
     * 表字段 : activity_base_info.region_mkt
     */
    private String regionMkt;

    /**
     * 城市经理编号
     * 表字段 : activity_base_info.zcm_id
     */
    private String zcmId;

    /**
     * 城市经理名称
     * 表字段 : activity_base_info.zcm_name
     */
    private String zcmName;

    /**
     * 特殊备注
     * 表字段 : activity_base_info.spe_notes
     */
    private String speNotes;

    /**
     * 厂方承担金额(分)
     * 表字段 : activity_base_info.add_assume_amt
     */
    private Long addAssumeAmt;

    /**
     * 活动金额(分)
     * 表字段 : activity_base_info.activity_amount
     */
    private Long activityAmount;

    /**
     * 对应的申请、登记合计金额(分)
     * 表字段 : activity_base_info.total_amount
     */
    private Long totalAmount;
    /**
     * 金额(申请、登记、核报)
     * 表字段 : activity_base_info.amount
     */
    private Long amount;
    
    //费用类型 -取行项目上第一行的费用类型
    private String costType;
    //费用类型名称
    private String costTypeName;


    /**
     * 审核金额合计(分)
     * 表字段 : activity_base_info.audit_amount
     */
    private Long auditAmount;

    /**
     * 复核金额合计(分)   当为申请单时，保存已核报发起金额
     * 表字段 : activity_base_info.review_amount
     */
    private Long reviewAmount;

    /**
     * 最终审核金额(分)
     * 表字段 : activity_base_info.final_amount
     */
    private Long finalAmount;

    /**
     * 促销类型
     * 表字段 : activity_base_info.promote_type
     */
    private String promoteType;

    /**
     * 是否个性化促销1是 0不是
     * 表字段 : activity_base_info.is_individual_promote
     */
    private Byte isIndividualPromote;

    /**
     * 渠道
     * 表字段 : activity_base_info.channel
     */
    private String channel;

    /**
     * 账务处理方式（入账类型）
     * 表字段 : activity_base_info.account_treat
     */
    private String accountTreat;

    /**
     * 入帐经销商编号
     * 表字段 : activity_base_info.entry_dealer_id
     */
    private String entryDealerId;

    /**
     * 入帐经销商名称
     * 表字段 : activity_base_info.entry_dealer_name
     */
    private String entryDealerName;

    /**
     * 是否督查扣款
     * 表字段 : activity_base_info.is_payment
     */
    private Byte isPayment;

    /**
     * 关联申请单号
     * 表字段 : activity_base_info.apply_no
     */
    private String applyNo;

    /**
     * 关联核报单号
     * 表字段 : activity_base_info.pay_no
     */
    private String payNo;

    /**
     * 关联登记单号
     * 表字段 : activity_base_info.regist_no
     */
    private String registNo;

    /**
     * 
     * 表字段 : activity_base_info.status
     */
    private Integer status;
    /**
     * 
     * 表字段 : activity_base_info.status
     */
    private String statusName;

    /**
     * 
     * 表字段 : activity_base_info.create_id
     */
    private String createId;

    /**
     * 
     * 表字段 : activity_base_info.create_name
     */
    private String createName;

    /**
     * 
     * 表字段 : activity_base_info.create_date
     */
    private Date createDate;

    /**
     * 
     * 表字段 : activity_base_info.modify_id
     */
    private String modifyId;

    /**
     * 
     * 表字段 : activity_base_info.modify_name
     */
    private String modifyName;

    /**
     * 
     * 表字段 : activity_base_info.modify_date
     */
    private Date modifyDate;

    /**
     * 预估销量瓶数
     * 表字段 : activity_base_info.sale_forecast_num
     */
    private Integer saleForecastNum;

    /**
     * 预估销售金额
     * 表字段 : activity_base_info.sale_forecast_amount
     */
    private Long saleForecastAmount;

    /**
     * 是否促销(0是，1否)
     * 表字段 : activity_base_info.is_promote
     */
    private Byte isPromote;

    /**
     * 促销品采购方式
     * 表字段 : activity_base_info.promote_product_buyway
     */
    private String promoteProductBuyway;

    /**
     * 促销总金额(分)
     * 表字段 : activity_base_info.promote_amount_total
     */
    private Integer promoteAmountTotal;

    /**
     * 登记意见
     * 表字段 : activity_base_info.regist_notes
     */
    private String registNotes;

    public String getStatusName() {
		return statusName;
	}

	public void setStatusName(String statusName) {
		this.statusName = statusName;
	}

	/**
     * 活动投入实施说明
     * 表字段 : activity_base_info.activity_notes
     */
    private String activityNotes;

    /**
     * 督查汇总意见
     * 表字段 : activity_base_info.audit_notes
     */
    private String auditNotes;

    /**
     * 是否督查扣款
     * 表字段 : activity_base_info.id_audit_withhold
     */
    private Byte idAuditWithhold;


    /**
     * 活动投入类型
     * 表字段 : activity_base_info.activity_input_type
     */
    private String activityInputType;

    /**
     * 是使用赠酒卡(0否，1是)
     * 表字段 : activity_base_info.is_use_gift_card
     */
    private Byte isUseGiftCard;

    /**
     * 赠饮对象(10政府领导11企业领导12军队领导13品鉴顾问14酒店老板15烟酒店老板16核心消费者)
     * 表字段 : activity_base_info.gift_wine_obj
     */
    private Integer giftWineObj;

    /**
     * 赠饮目的
     * 表字段 : activity_base_info.gift_notes
     */
    private String giftNotes;

    /**
     * 推广品牌编码
     */
    private String brandId;

    /**
     * 推广品牌名称
     */
    private String brandName;

    /**
     * 投入方式(按价格、按单瓶)
     */
    private String inputWay;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table activity_base_info
     *
     * @mbggenerated Fri May 12 15:46:32 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:activity_base_info.id
     *
     * @return activity_base_info.id, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:activity_base_info.id
     *
     * @param id the value for activity_base_info.id, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 表单号 字段:activity_base_info.form_no
     *
     * @return activity_base_info.form_no, 表单号
     */
    public String getFormNo() {
        return formNo;
    }

    /**
     * 设置 表单号 字段:activity_base_info.form_no
     *
     * @param formNo the value for activity_base_info.form_no, 表单号
     */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /**
     * 获取 表单类型 字段:activity_base_info.form_type
     *
     * @return activity_base_info.form_type, 表单类型
     */
    public String getFormType() {
        return formType;
    }

    /**
     * 设置 表单类型 字段:activity_base_info.form_type
     *
     * @param formType the value for activity_base_info.form_type, 表单类型
     */
    public void setFormType(String formType) {
        this.formType = formType;
    }

    /**
     * 获取 开始日期 字段:activity_base_info.s_date
     *
     * @return activity_base_info.s_date, 开始日期
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置 开始日期 字段:activity_base_info.s_date
     *
     * @param sDate the value for activity_base_info.s_date, 开始日期
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取 结束日期 字段:activity_base_info.e_date
     *
     * @return activity_base_info.e_date, 结束日期
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置 结束日期 字段:activity_base_info.e_date
     *
     * @param eDate the value for activity_base_info.e_date, 结束日期
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取 客户编号 字段:activity_base_info.kunnr
     *
     * @return activity_base_info.kunnr, 客户编号
     */
    public String getKunnr() {
        return kunnr;
    }

    /**
     * 设置 客户编号 字段:activity_base_info.kunnr
     *
     * @param kunnr the value for activity_base_info.kunnr, 客户编号
     */
    public void setKunnr(String kunnr) {
        this.kunnr = kunnr;
    }

    public String getTerminalType() {
        return TerminalType;
    }

    public void setTerminalType(String terminalType) {
        TerminalType = terminalType;
    }

    /**
     * 获取 经销商一级渠道 字段:activity_base_info.level1_channel
     *
     * @return activity_base_info.level1_channel, 经销商一级渠道
     */
    public String getLevel1Channel() {
        return level1Channel;
    }

    /**
     * 设置 经销商一级渠道 字段:activity_base_info.level1_channel
     *
     * @param level1Channel the value for activity_base_info.level1_channel, 经销商一级渠道
     */
    public void setLevel1Channel(String level1Channel) {
        this.level1Channel = level1Channel;
    }

    
    public FinaceInfoPayVo getFinaceInfoPay() {
		return finaceInfoPay;
	}

	public void setFinaceInfoPay(FinaceInfoPayVo finaceInfoPay) {
		this.finaceInfoPay = finaceInfoPay;
	}

	/**
     * 获取 经销商2级渠道 字段:activity_base_info.level2_channel
     *
     * @return activity_base_info.level2_channel, 经销商2级渠道
     */
    public String getLevel2Channel() {
        return level2Channel;
    }

    /**
     * 设置 经销商2级渠道 字段:activity_base_info.level2_channel
     *
     * @param level2Channel the value for activity_base_info.level2_channel, 经销商2级渠道
     */
    public void setLevel2Channel(String level2Channel) {
        this.level2Channel = level2Channel;
    }

    /**
     * 获取 品牌大类 字段:activity_base_info.spart
     *
     * @return activity_base_info.spart, 品牌大类
     */
    public String getSpart() {
        return spart;
    }

    /**
     * 设置 品牌大类 字段:activity_base_info.spart
     *
     * @param spart the value for activity_base_info.spart, 品牌大类
     */
    public void setSpart(String spart) {
        this.spart = spart;
    }

    /**
     * 获取 活动类型编码 字段:activity_base_info.activity_type_code
     *
     * @return activity_base_info.activity_type_code, 活动类型编码
     */
    public String getActivityTypeCode() {
        return activityTypeCode;
    }

    /**
     * 设置 活动类型编码 字段:activity_base_info.activity_type_code
     *
     * @param activityTypeCode the value for activity_base_info.activity_type_code, 活动类型编码
     */
    public void setActivityTypeCode(String activityTypeCode) {
        this.activityTypeCode = activityTypeCode;
    }

    /**
     * 获取 活动类型名称 字段:activity_base_info.activity_type_name
     *
     * @return activity_base_info.activity_type_name, 活动类型名称
     */
    public String getActivityTypeName() {
        return activityTypeName;
    }

    /**
     * 设置 活动类型名称 字段:activity_base_info.activity_type_name
     *
     * @param activityTypeName the value for activity_base_info.activity_type_name, 活动类型名称
     */
    public void setActivityTypeName(String activityTypeName) {
        this.activityTypeName = activityTypeName;
    }

    /**
     * 获取  字段:activity_base_info.activity_type_code_sub
     *
     * @return activity_base_info.activity_type_code_sub, 
     */
    public String getActivityTypeCodeSub() {
        return activityTypeCodeSub;
    }

    /**
     * 设置  字段:activity_base_info.activity_type_code_sub
     *
     * @param activityTypeCodeSub the value for activity_base_info.activity_type_code_sub, 
     */
    public void setActivityTypeCodeSub(String activityTypeCodeSub) {
        this.activityTypeCodeSub = activityTypeCodeSub;
    }

    /**
     * 获取 活动类型2级编码 字段:activity_base_info.activity_type_name_sub
     *
     * @return activity_base_info.activity_type_name_sub, 活动类型2级编码
     */
    public String getActivityTypeNameSub() {
        return activityTypeNameSub;
    }

    /**
     * 设置 活动类型2级编码 字段:activity_base_info.activity_type_name_sub
     *
     * @param activityTypeNameSub the value for activity_base_info.activity_type_name_sub, 活动类型2级编码
     */
    public void setActivityTypeNameSub(String activityTypeNameSub) {
        this.activityTypeNameSub = activityTypeNameSub;
    }

    /**
     * 获取 经销商编号 字段:activity_base_info.dealer_id
     *
     * @return activity_base_info.dealer_id, 经销商编号
     */
    public String getDealerId() {
        return dealerId;
    }

    /**
     * 设置 经销商编号 字段:activity_base_info.dealer_id
     *
     * @param dealerId the value for activity_base_info.dealer_id, 经销商编号
     */
    public void setDealerId(String dealerId) {
        this.dealerId = dealerId;
    }

    /**
     * 获取 经销商名称 字段:activity_base_info.dealer_name
     *
     * @return activity_base_info.dealer_name, 经销商名称
     */
    public String getDealerName() {
        return dealerName;
    }

    /**
     * 设置 经销商名称 字段:activity_base_info.dealer_name
     *
     * @param dealerName the value for activity_base_info.dealer_name, 经销商名称
     */
    public void setDealerName(String dealerName) {
        this.dealerName = dealerName;
    }

    /**
     * 获取  字段:activity_base_info.dealer_type
     *
     * @return activity_base_info.dealer_type, 
     */
    public String getDealerType() {
        return dealerType;
    }

    /**
     * 设置  字段:activity_base_info.dealer_type
     *
     * @param dealerType the value for activity_base_info.dealer_type, 
     */
    public void setDealerType(String dealerType) {
        this.dealerType = dealerType;
    }

    /**
     * 获取 区域市场(行政区域，多个以，号分割) 字段:activity_base_info.region_mkt
     *
     * @return activity_base_info.region_mkt, 区域市场(行政区域，多个以，号分割)
     */
    public String getRegionMkt() {
        return regionMkt;
    }

    /**
     * 设置 区域市场(行政区域，多个以，号分割) 字段:activity_base_info.region_mkt
     *
     * @param regionMkt the value for activity_base_info.region_mkt, 区域市场(行政区域，多个以，号分割)
     */
    public void setRegionMkt(String regionMkt) {
        this.regionMkt = regionMkt;
    }

    /**
     * 获取 城市经理编号 字段:activity_base_info.zcm_id
     *
     * @return activity_base_info.zcm_id, 城市经理编号
     */
    public String getZcmId() {
        return zcmId;
    }

    /**
     * 设置 城市经理编号 字段:activity_base_info.zcm_id
     *
     * @param zcmId the value for activity_base_info.zcm_id, 城市经理编号
     */
    public void setZcmId(String zcmId) {
        this.zcmId = zcmId;
    }

    /**
     * 获取 城市经理名称 字段:activity_base_info.zcm_name
     *
     * @return activity_base_info.zcm_name, 城市经理名称
     */
    public String getZcmName() {
        return zcmName;
    }

    /**
     * 设置 城市经理名称 字段:activity_base_info.zcm_name
     *
     * @param zcmName the value for activity_base_info.zcm_name, 城市经理名称
     */
    public void setZcmName(String zcmName) {
        this.zcmName = zcmName;
    }

    /**
     * 获取 特殊备注 字段:activity_base_info.spe_notes
     *
     * @return activity_base_info.spe_notes, 特殊备注
     */
    public String getSpeNotes() {
        return speNotes;
    }

    /**
     * 设置 特殊备注 字段:activity_base_info.spe_notes
     *
     * @param speNotes the value for activity_base_info.spe_notes, 特殊备注
     */
    public void setSpeNotes(String speNotes) {
        this.speNotes = speNotes;
    }

    /**
     * 获取 厂方承担金额(分) 字段:activity_base_info.add_assume_amt
     *
     * @return activity_base_info.add_assume_amt, 厂方承担金额(分)
     */
    public Long getAddAssumeAmt() {
        return addAssumeAmt;
    }

    /**
     * 设置 厂方承担金额(分) 字段:activity_base_info.add_assume_amt
     *
     * @param addAssumeAmt the value for activity_base_info.add_assume_amt, 厂方承担金额(分)
     */
    public void setAddAssumeAmt(Long addAssumeAmt) {
        this.addAssumeAmt = addAssumeAmt;
    }

    /**
     * 获取 活动金额(分) 字段:activity_base_info.activity_amount
     *
     * @return activity_base_info.activity_amount, 活动金额(分)
     */
    public Long getActivityAmount() {
        return activityAmount;
    }

    /**
     * 设置 活动金额(分) 字段:activity_base_info.activity_amount
     *
     * @param activityAmount the value for activity_base_info.activity_amount, 活动金额(分)
     */
    public void setActivityAmount(Long activityAmount) {
        this.activityAmount = activityAmount;
    }



    public Long getTotalAmount() {
		return totalAmount;
	}

	public void setTotalAmount(Long totalAmount) {
		this.totalAmount = totalAmount;
	}


    /**
     * 获取 审核金额合计(分) 字段:activity_base_info.audit_amount
     *
     * @return activity_base_info.audit_amount, 审核金额合计(分)
     */
    public Long getAuditAmount() {
        return auditAmount;
    }

    /**
     * 设置 审核金额合计(分) 字段:activity_base_info.audit_amount
     *
     * @param auditAmount the value for activity_base_info.audit_amount, 审核金额合计(分)
     */
    public void setAuditAmount(Long auditAmount) {
        this.auditAmount = auditAmount;
    }

    /**
     * 获取 复核金额合计(分) 字段:activity_base_info.review_amount
     *
     * @return activity_base_info.review_amount, 复核金额合计(分)
     */
    public Long getReviewAmount() {
        return reviewAmount;
    }

    /**
     * 设置 复核金额合计(分) 字段:activity_base_info.review_amount
     *
     * @param reviewAmount the value for activity_base_info.review_amount, 复核金额合计(分)
     */
    public void setReviewAmount(Long reviewAmount) {
        this.reviewAmount = reviewAmount;
    }

    /**
     * 获取 最终审核金额(分) 字段:activity_base_info.final_amount
     *
     * @return activity_base_info.final_amount, 最终审核金额(分)
     */
    public Long getFinalAmount() {
        return finalAmount;
    }

    /**
     * 设置 最终审核金额(分) 字段:activity_base_info.final_amount
     *
     * @param finalAmount the value for activity_base_info.final_amount, 最终审核金额(分)
     */
    public void setFinalAmount(Long finalAmount) {
        this.finalAmount = finalAmount;
    }

    /**
     * 获取 促销类型 字段:activity_base_info.promote_type
     *
     * @return activity_base_info.promote_type, 促销类型
     */
    public String getPromoteType() {
        return promoteType;
    }

    /**
     * 设置 促销类型 字段:activity_base_info.promote_type
     *
     * @param promoteType the value for activity_base_info.promote_type, 促销类型
     */
    public void setPromoteType(String promoteType) {
        this.promoteType = promoteType;
    }

    /**
     * 获取 是否个性化促销1是 0不是 字段:activity_base_info.is_individual_promote
     *
     * @return activity_base_info.is_individual_promote, 是否个性化促销1是 0不是
     */
    public Byte getIsIndividualPromote() {
        return isIndividualPromote;
    }

    /**
     * 设置 是否个性化促销1是 0不是 字段:activity_base_info.is_individual_promote
     *
     * @param isIndividualPromote the value for activity_base_info.is_individual_promote, 是否个性化促销1是 0不是
     */
    public void setIsIndividualPromote(Byte isIndividualPromote) {
        this.isIndividualPromote = isIndividualPromote;
    }

    /**
     * 获取 渠道 字段:activity_base_info.channel
     *
     * @return activity_base_info.channel, 渠道
     */
    public String getChannel() {
        return channel;
    }

    /**
     * 设置 渠道 字段:activity_base_info.channel
     *
     * @param channel the value for activity_base_info.channel, 渠道
     */
    public void setChannel(String channel) {
        this.channel = channel;
    }

    /**
     * 获取 账务处理方式（入账类型） 字段:activity_base_info.account_treat
     *
     * @return activity_base_info.account_treat, 账务处理方式（入账类型）
     */
    public String getAccountTreat() {
        return accountTreat;
    }

    /**
     * 设置 账务处理方式（入账类型） 字段:activity_base_info.account_treat
     *
     * @param accountTreat the value for activity_base_info.account_treat, 账务处理方式（入账类型）
     */
    public void setAccountTreat(String accountTreat) {
        this.accountTreat = accountTreat;
    }

    /**
     * 获取 入帐经销商编号 字段:activity_base_info.entry_dealer_id
     *
     * @return activity_base_info.entry_dealer_id, 入帐经销商编号
     */
    public String getEntryDealerId() {
        return entryDealerId;
    }

    /**
     * 设置 入帐经销商编号 字段:activity_base_info.entry_dealer_id
     *
     * @param entryDealerId the value for activity_base_info.entry_dealer_id, 入帐经销商编号
     */
    public void setEntryDealerId(String entryDealerId) {
        this.entryDealerId = entryDealerId;
    }

    /**
     * 获取 入帐经销商名称 字段:activity_base_info.entry_dealer_name
     *
     * @return activity_base_info.entry_dealer_name, 入帐经销商名称
     */
    public String getEntryDealerName() {
        return entryDealerName;
    }

    /**
     * 设置 入帐经销商名称 字段:activity_base_info.entry_dealer_name
     *
     * @param entryDealerName the value for activity_base_info.entry_dealer_name, 入帐经销商名称
     */
    public void setEntryDealerName(String entryDealerName) {
        this.entryDealerName = entryDealerName;
    }

    /**
     * 获取 是否督查扣款 字段:activity_base_info.is_payment
     *
     * @return activity_base_info.is_payment, 是否督查扣款
     */
    public Byte getIsPayment() {
        return isPayment;
    }

    /**
     * 设置 是否督查扣款 字段:activity_base_info.is_payment
     *
     * @param isPayment the value for activity_base_info.is_payment, 是否督查扣款
     */
    public void setIsPayment(Byte isPayment) {
        this.isPayment = isPayment;
    }

    /**
     * 获取 关联申请单号 字段:activity_base_info.apply_no
     *
     * @return activity_base_info.apply_no, 关联申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 关联申请单号 字段:activity_base_info.apply_no
     *
     * @param applyNo the value for activity_base_info.apply_no, 关联申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 关联核报单号 字段:activity_base_info.pay_no
     *
     * @return activity_base_info.pay_no, 关联核报单号
     */
    public String getPayNo() {
        return payNo;
    }

    /**
     * 设置 关联核报单号 字段:activity_base_info.pay_no
     *
     * @param payNo the value for activity_base_info.pay_no, 关联核报单号
     */
    public void setPayNo(String payNo) {
        this.payNo = payNo;
    }

    /**
     * 获取 关联登记单号 字段:activity_base_info.regist_no
     *
     * @return activity_base_info.regist_no, 关联登记单号
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置 关联登记单号 字段:activity_base_info.regist_no
     *
     * @param registNo the value for activity_base_info.regist_no, 关联登记单号
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取  字段:activity_base_info.status
     *
     * @return activity_base_info.status, 
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置  字段:activity_base_info.status
     *
     * @param status the value for activity_base_info.status, 
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取  字段:activity_base_info.create_id
     *
     * @return activity_base_info.create_id, 
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:activity_base_info.create_id
     *
     * @param createId the value for activity_base_info.create_id, 
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:activity_base_info.create_name
     *
     * @return activity_base_info.create_name, 
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:activity_base_info.create_name
     *
     * @param createName the value for activity_base_info.create_name, 
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:activity_base_info.create_date
     *
     * @return activity_base_info.create_date, 
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:activity_base_info.create_date
     *
     * @param createDate the value for activity_base_info.create_date, 
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:activity_base_info.modify_id
     *
     * @return activity_base_info.modify_id, 
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:activity_base_info.modify_id
     *
     * @param modifyId the value for activity_base_info.modify_id, 
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:activity_base_info.modify_name
     *
     * @return activity_base_info.modify_name, 
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:activity_base_info.modify_name
     *
     * @param modifyName the value for activity_base_info.modify_name, 
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:activity_base_info.modify_date
     *
     * @return activity_base_info.modify_date, 
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:activity_base_info.modify_date
     *
     * @param modifyDate the value for activity_base_info.modify_date, 
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 预估销量瓶数 字段:activity_base_info.sale_forecast_num
     *
     * @return activity_base_info.sale_forecast_num, 预估销量瓶数
     */
    public Integer getSaleForecastNum() {
        return saleForecastNum;
    }

    /**
     * 设置 预估销量瓶数 字段:activity_base_info.sale_forecast_num
     *
     * @param saleForecastNum the value for activity_base_info.sale_forecast_num, 预估销量瓶数
     */
    public void setSaleForecastNum(Integer saleForecastNum) {
        this.saleForecastNum = saleForecastNum;
    }

    /**
     * 获取 预估销售金额 字段:activity_base_info.sale_forecast_amount
     *
     * @return activity_base_info.sale_forecast_amount, 预估销售金额
     */
    public Long getSaleForecastAmount() {
        return saleForecastAmount;
    }

    /**
     * 设置 预估销售金额 字段:activity_base_info.sale_forecast_amount
     *
     * @param saleForecastAmount the value for activity_base_info.sale_forecast_amount, 预估销售金额
     */
    public void setSaleForecastAmount(Long saleForecastAmount) {
        this.saleForecastAmount = saleForecastAmount;
    }

    /**
     * 获取 是否促销(0是，1否) 字段:activity_base_info.is_promote
     *
     * @return activity_base_info.is_promote, 是否促销(0是，1否)
     */
    public Byte getIsPromote() {
        return isPromote;
    }

    /**
     * 设置 是否促销(0是，1否) 字段:activity_base_info.is_promote
     *
     * @param isPromote the value for activity_base_info.is_promote, 是否促销(0是，1否)
     */
    public void setIsPromote(Byte isPromote) {
        this.isPromote = isPromote;
    }

    /**
     * 获取 促销品采购方式 字段:activity_base_info.promote_product_buyway
     *
     * @return activity_base_info.promote_product_buyway, 促销品采购方式
     */
    public String getPromoteProductBuyway() {
        return promoteProductBuyway;
    }

    /**
     * 设置 促销品采购方式 字段:activity_base_info.promote_product_buyway
     *
     * @param promoteProductBuyway the value for activity_base_info.promote_product_buyway, 促销品采购方式
     */
    public void setPromoteProductBuyway(String promoteProductBuyway) {
        this.promoteProductBuyway = promoteProductBuyway;
    }

    /**
     * 获取 促销总金额(分) 字段:activity_base_info.promote_amount_total
     *
     * @return activity_base_info.promote_amount_total, 促销总金额(分)
     */
    public Integer getPromoteAmountTotal() {
        return promoteAmountTotal;
    }

    /**
     * 设置 促销总金额(分) 字段:activity_base_info.promote_amount_total
     *
     * @param promoteAmountTotal the value for activity_base_info.promote_amount_total, 促销总金额(分)
     */
    public void setPromoteAmountTotal(Integer promoteAmountTotal) {
        this.promoteAmountTotal = promoteAmountTotal;
    }

    /**
     * 获取 登记意见 字段:activity_base_info.regist_notes
     *
     * @return activity_base_info.regist_notes, 登记意见
     */
    public String getRegistNotes() {
        return registNotes;
    }

    /**
     * 设置 登记意见 字段:activity_base_info.regist_notes
     *
     * @param registNotes the value for activity_base_info.regist_notes, 登记意见
     */
    public void setRegistNotes(String registNotes) {
        this.registNotes = registNotes;
    }

    /**
     * 获取 活动投入实施说明 字段:activity_base_info.activity_notes
     *
     * @return activity_base_info.activity_notes, 活动投入实施说明
     */
    public String getActivityNotes() {
        return activityNotes;
    }

    /**
     * 设置 活动投入实施说明 字段:activity_base_info.activity_notes
     *
     * @param activityNotes the value for activity_base_info.activity_notes, 活动投入实施说明
     */
    public void setActivityNotes(String activityNotes) {
        this.activityNotes = activityNotes;
    }

    /**
     * 获取 督查汇总意见 字段:activity_base_info.audit_notes
     *
     * @return activity_base_info.audit_notes, 督查汇总意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查汇总意见 字段:activity_base_info.audit_notes
     *
     * @param auditNotes the value for activity_base_info.audit_notes, 督查汇总意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取 是否督查扣款 字段:activity_base_info.id_audit_withhold
     *
     * @return activity_base_info.id_audit_withhold, 是否督查扣款
     */
    public Byte getIdAuditWithhold() {
        return idAuditWithhold;
    }
    /**
     * 获取 活动投入类型 字段:activity_base_info.activity_input_type
     *
     * @return activity_base_info.activity_input_type, 活动投入类型
     */
    public String getActivityInputType() {
        return activityInputType;
    }

    /**
     * 设置 活动投入类型 字段:activity_base_info.activity_input_type
     *
     * @param activityInputType the value for activity_base_info.activity_input_type, 活动投入类型
     */
    public void setActivityInputType(String activityInputType) {
        this.activityInputType = activityInputType;
    }

    /**
     * 获取 是使用赠酒卡(0否，1是) 字段:activity_base_info.is_use_gift_card
     *
     * @return activity_base_info.is_use_gift_card, 是使用赠酒卡(0否，1是)
     */
    public Byte getIsUseGiftCard() {
        return isUseGiftCard;
    }

    /**
     * 设置 是使用赠酒卡(0否，1是) 字段:activity_base_info.is_use_gift_card
     *
     * @param isUseGiftCard the value for activity_base_info.is_use_gift_card, 是使用赠酒卡(0否，1是)
     */
    public void setIsUseGiftCard(Byte isUseGiftCard) {
        this.isUseGiftCard = isUseGiftCard;
    }

    /**
     * 获取 赠饮对象(10政府领导11企业领导12军队领导13品鉴顾问14酒店老板15烟酒店老板16核心消费者) 字段:activity_base_info.gift_wine_obj
     *
     * @return activity_base_info.gift_wine_obj, 赠饮对象(10政府领导11企业领导12军队领导13品鉴顾问14酒店老板15烟酒店老板16核心消费者)
     */
    public Integer getGiftWineObj() {
        return giftWineObj;
    }

    /**
     * 设置 赠饮对象(10政府领导11企业领导12军队领导13品鉴顾问14酒店老板15烟酒店老板16核心消费者) 字段:activity_base_info.gift_wine_obj
     *
     * @param giftWineObj the value for activity_base_info.gift_wine_obj, 赠饮对象(10政府领导11企业领导12军队领导13品鉴顾问14酒店老板15烟酒店老板16核心消费者)
     */
    public void setGiftWineObj(Integer giftWineObj) {
        this.giftWineObj = giftWineObj;
    }

    /**
     * 获取 赠饮目的 字段:activity_base_info.gift_notes
     *
     * @return activity_base_info.gift_notes, 赠饮目的
     */
    public String getGiftNotes() {
        return giftNotes;
    }

    /**
     * 设置 赠饮目的 字段:activity_base_info.gift_notes
     *
     * @param giftNotes the value for activity_base_info.gift_notes, 赠饮目的
     */
    public void setGiftNotes(String giftNotes) {
        this.giftNotes = giftNotes;
    }
    /**
     * 设置 是否督查扣款 字段:activity_base_info.id_audit_withhold
     *
     * @param idAuditWithhold the value for activity_base_info.id_audit_withhold, 是否督查扣款
     */
    public void setIdAuditWithhold(Byte idAuditWithhold) {
        this.idAuditWithhold = idAuditWithhold;
    }

	public Long getAmount() {
		return amount;
	}

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public String getCostType() {
		return costType;
	}

	public void setCostType(String costType) {
		this.costType = costType;
	}

	public String getCostTypeName() {
		return costTypeName;
	}

	public void setCostTypeName(String costTypeName) {
		this.costTypeName = costTypeName;
	}

    /**
     * 获取 推广品牌编码
     */
    public String getBrandId() {
        return this.brandId;
    }

    /**
     * 设置 推广品牌编码
     */
    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    /**
     * 获取 推广品牌名称
     */
    public String getBrandName() {
        return this.brandName;
    }

    /**
     * 设置 推广品牌名称
     */
    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    /**
     * 获取 投入方式(按价格、按单瓶)
     */
    public String getInputWay() {
        return this.inputWay;
    }

    /**
     * 设置 投入方式(按价格、按单瓶)
     */
    public void setInputWay(String inputWay) {
        this.inputWay = inputWay;
    }


	public ManageInfoVo getManageInfo() {
		return manageInfo;
	}

	public void setManageInfo(ManageInfoVo manageInfo) {
		this.manageInfo = manageInfo;
	}

	public FinanceInfoApplyVo getFinanceInfoApply() {
		return financeInfoApply;
	}

	public void setFinanceInfoApply(FinanceInfoApplyVo financeInfoApply) {
		this.financeInfoApply = financeInfoApply;
	}

	public List<AreaMarketingVo> getAreaMarketing() {
		return areaMarketing;
	}

	public void setAreaMarketing(List<AreaMarketingVo> areaMarketing) {
		this.areaMarketing = areaMarketing;
	}
  
}
