package com.chinayanghe.tpm.cost.vo.out.datadetail.regist;


import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

/**
 * 渠道客情登记Vo
 * Created by Jay on 2017/6/2.
 */
public class ChannelCustomerRelRegistVo implements Serializable {

    /**
     *
     * 表字段 : channel_customer_rel_regist.id
     */
    private Integer id;

    private Integer applyId;

    private  Double applyCompanyScale;

    /**
     *
     * 表字段 : channel_customer_rel_regist.regist_no
     */
    private String registNo;

    /**
     *
     * 表字段 : channel_customer_rel_regist.apply_no
     */
    private String applyNo;

    /**
     *
     * 表字段 : channel_customer_rel_regist.apply_item_no
     */
    private Integer applyItemNo;

    /**
     *
     * 表字段 : channel_customer_rel_regist.s_date
     */
    private Date sDate;

    /**
     *
     * 表字段 : channel_customer_rel_regist.e_date
     */
    private Date eDate;

    /**
     *
     * 表字段 : channel_customer_rel_regist.cost_type_id
     */
    private String costTypeId;

    /**
     *
     * 表字段 : channel_customer_rel_regist.cost_type_name
     */
    private String costTypeName;

    /**
     * 详细地址
     * 表字段 : channel_customer_rel_regist.address_detail
     */
    private String addressDetail;

    /**
     * 受赠客户
     * 表字段 : channel_customer_rel_regist.gift_costomer
     */
    private String giftCostomer;

    /**
     * 终端编码
     * 表字段 : channel_customer_rel_regist.terminal_id
     */
    private String terminalId;

    /**
     * 终端名称
     * 表字段 : channel_customer_rel_regist.terminal_name
     */
    private String terminalName;

    /**
     * 省编码
     * 表字段 : channel_customer_rel_regist.province_id
     */
    private String provinceId;

    /**
     * 省名称
     * 表字段 : channel_customer_rel_regist.province_name
     */
    private String provinceName;

    /**
     * 宴会通单号
     * 表字段 : channel_customer_rel_regist.feast_form_no
     */
    private String feastFormNo;

    /**
     * 市编码
     * 表字段 : channel_customer_rel_regist.city_id
     */
    private String cityId;

    /**
     * 市名称
     * 表字段 : channel_customer_rel_regist.city_name
     */
    private String cityName;

    /**
     * 区县编码
     * 表字段 : channel_customer_rel_regist.county_id
     */
    private String countyId;

    /**
     * 区县名称
     * 表字段 : channel_customer_rel_regist.county_name
     */
    private String countyName;

    /**
     * 产品编码
     * 表字段 : channel_customer_rel_regist.product_id
     */
    private String productId;

    /**
     * 产品名称
     * 表字段 : channel_customer_rel_regist.product_name
     */
    private String productName;

    /**
     * 登记数量
     * 表字段 : channel_customer_rel_regist.regist_num
     */
    private Integer registNum;

    /**
     * 结算价(分)
     * 表字段 : channel_customer_rel_regist.settlement_price
     */
    private BigDecimal settlementPrice;

    /**
     * 预计产生费用(分)
     * 表字段 : channel_customer_rel_regist.plan_amount
     */
    private BigDecimal planAmount;

    /**
     * 厂方承担金额
     * 表字段 : channel_customer_rel_regist.company_amount
     */
    private BigDecimal companyAmount;

    /**
     * 厂方承担比例
     * 表字段 : channel_customer_rel_regist.company_scale
     */
    private Double companyScale;

    /**
     * 日期
     * 表字段 : channel_customer_rel_regist.gmt_date
     */
    private Date gmtDate;

    /**
     * 时间范围
     * 表字段 : channel_customer_rel_regist.range_date
     */
    private String rangeDate;

    /**
     * 单位名称
     * 表字段 : channel_customer_rel_regist.company_name
     */
    private String companyName;

    /**
     * 单位地址
     * 表字段 : channel_customer_rel_regist.company_address
     */
    private String companyAddress;

    /**
     * 酒店包厢
     * 表字段 : channel_customer_rel_regist.hotel_box
     */
    private String hotelBox;

    /**
     * 会议名称
     * 表字段 : channel_customer_rel_regist.Meeting_name
     */
    private String meetingName;

    /**
     * 场地名称
     * 表字段 : channel_customer_rel_regist.field_name
     */
    private String fieldName;

    /**
     * 场地电话
     * 表字段 : channel_customer_rel_regist.field_tel
     */
    private String fieldTel;

    /**
     * 联系人
     * 表字段 : channel_customer_rel_regist.contacts_name
     */
    private String contactsName;

    /**
     * 联系人电话
     * 表字段 : channel_customer_rel_regist.contacts_tel
     */
    private String contactsTel;

    /**
     * 预计到会人数
     * 表字段 : channel_customer_rel_regist.plan_attendance
     */
    private String planAttendance;

    /**
     * 预计餐费
     * 表字段 : channel_customer_rel_regist.plan_meals
     */
    private BigDecimal planMeals;

    /**
     * 用酒量
     * 表字段 : channel_customer_rel_regist.plan_wine_num
     */
    private Integer planWineNum;

    /**
     * 赠品名称及数量
     * 表字段 : channel_customer_rel_regist.gift_name_num
     */
    private String giftNameNum;

    /**
     * 备注
     * 表字段 : channel_customer_rel_regist.notes
     */
    private String notes;


    /**
     * 是否是宴会通 （0:不是 ，1:是）
     * 表字段 : channel_customer_rel_regist.is_feast
     */
    private Integer isFeast;

    /**
     *
     * 表字段 : channel_customer_rel_regist.item_no
     */
    private String  itemNo;

    /**
     * 行项目余额
     * 表字段 : channel_customer_rel_regist.item_balance
     */
    private BigDecimal itemBalance;

    /**
     * 督查意见
     * 表字段 : channel_customer_rel_regist.audit_notes
     */
    private String auditNotes;

    /**
     *
     * 表字段 : channel_customer_rel_regist.create_id
     */
    private String createId;

    /**
     *
     * 表字段 : channel_customer_rel_regist.create_name
     */
    private String createName;

    /**
     *
     * 表字段 : channel_customer_rel_regist.create_date
     */
    private Date createDate;

    /**
     *
     * 表字段 : channel_customer_rel_regist.modify_id
     */
    private String modifyId;

    /**
     *
     * 表字段 : channel_customer_rel_regist.modify_name
     */
    private String modifyName;

    /**
     *
     * 表字段 : channel_customer_rel_regist.modify_date
     */
    private Date modifyDate;


    public Integer getApplyId() {
        return applyId;
    }

    public void setApplyId(Integer applyId) {
        this.applyId = applyId;
    }

    public Double getApplyCompanyScale() {
        return applyCompanyScale;
    }

    public void setApplyCompanyScale(Double applyCompanyScale) {
        this.applyCompanyScale = applyCompanyScale;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.id
     *
     * @return channel_customer_rel_regist.id,
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.id
     *
     * @param id the value for channel_customer_rel_regist.id,
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.regist_no
     *
     * @return channel_customer_rel_regist.regist_no,
     */
    public String getRegistNo() {
        return registNo;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.regist_no
     *
     * @param registNo the value for channel_customer_rel_regist.regist_no,
     */
    public void setRegistNo(String registNo) {
        this.registNo = registNo;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.apply_no
     *
     * @return channel_customer_rel_regist.apply_no,
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.apply_no
     *
     * @param applyNo the value for channel_customer_rel_regist.apply_no,
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.apply_item_no
     *
     * @return channel_customer_rel_regist.apply_item_no,
     */
    public Integer getApplyItemNo() {
        return applyItemNo;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.apply_item_no
     *
     * @param applyItemNo the value for channel_customer_rel_regist.apply_item_no,
     */
    public void setApplyItemNo(Integer applyItemNo) {
        this.applyItemNo = applyItemNo;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.s_date
     *
     * @return channel_customer_rel_regist.s_date,
     */
    public Date getsDate() {
        return sDate;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.s_date
     *
     * @param sDate the value for channel_customer_rel_regist.s_date,
     */
    public void setsDate(Date sDate) {
        this.sDate = sDate;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.e_date
     *
     * @return channel_customer_rel_regist.e_date,
     */
    public Date geteDate() {
        return eDate;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.e_date
     *
     * @param eDate the value for channel_customer_rel_regist.e_date,
     */
    public void seteDate(Date eDate) {
        this.eDate = eDate;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.cost_type_id
     *
     * @return channel_customer_rel_regist.cost_type_id,
     */
    public String getCostTypeId() {
        return costTypeId;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.cost_type_id
     *
     * @param costTypeId the value for channel_customer_rel_regist.cost_type_id,
     */
    public void setCostTypeId(String costTypeId) {
        this.costTypeId = costTypeId;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.cost_type_name
     *
     * @return channel_customer_rel_regist.cost_type_name,
     */
    public String getCostTypeName() {
        return costTypeName;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.cost_type_name
     *
     * @param costTypeName the value for channel_customer_rel_regist.cost_type_name,
     */
    public void setCostTypeName(String costTypeName) {
        this.costTypeName = costTypeName;
    }

    /**
     * 获取 宴会通单号 字段:channel_customer_rel_regist.feast_form_no
     *
     * @return channel_customer_rel_regist.feast_form_no, 宴会通单号
     */
    public String getFeastFormNo() {
        return feastFormNo;
    }

    /**
     * 设置 宴会通单号 字段:channel_customer_rel_regist.feast_form_no
     *
     * @param feastFormNo the value for channel_customer_rel_regist.feast_form_no, 宴会通单号
     */
    public void setFeastFormNo(String feastFormNo) {
        this.feastFormNo = feastFormNo;
    }

    /**
     * 获取 详细地址 字段:channel_customer_rel_regist.address_detail
     *
     * @return channel_customer_rel_regist.address_detail, 详细地址
     */
    public String getAddressDetail() {
        return addressDetail;
    }

    /**
     * 设置 详细地址 字段:channel_customer_rel_regist.address_detail
     *
     * @param addressDetail the value for channel_customer_rel_regist.address_detail, 详细地址
     */
    public void setAddressDetail(String addressDetail) {
        this.addressDetail = addressDetail;
    }

    /**
     * 获取 受赠客户 字段:channel_customer_rel_regist.gift_costomer
     *
     * @return channel_customer_rel_regist.gift_costomer, 受赠客户
     */
    public String getGiftCostomer() {
        return giftCostomer;
    }

    /**
     * 设置 受赠客户 字段:channel_customer_rel_regist.gift_costomer
     *
     * @param giftCostomer the value for channel_customer_rel_regist.gift_costomer, 受赠客户
     */
    public void setGiftCostomer(String giftCostomer) {
        this.giftCostomer = giftCostomer;
    }

    /**
     * 获取 终端编码 字段:channel_customer_rel_regist.terminal_id
     *
     * @return channel_customer_rel_regist.terminal_id, 终端编码
     */
    public String getTerminalId() {
        return terminalId;
    }

    /**
     * 设置 终端编码 字段:channel_customer_rel_regist.terminal_id
     *
     * @param terminalId the value for channel_customer_rel_regist.terminal_id, 终端编码
     */
    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    /**
     * 获取 终端名称 字段:channel_customer_rel_regist.terminal_name
     *
     * @return channel_customer_rel_regist.terminal_name, 终端名称
     */
    public String getTerminalName() {
        return terminalName;
    }

    /**
     * 设置 终端名称 字段:channel_customer_rel_regist.terminal_name
     *
     * @param terminalName the value for channel_customer_rel_regist.terminal_name, 终端名称
     */
    public void setTerminalName(String terminalName) {
        this.terminalName = terminalName;
    }

    /**
     * 获取 省编码 字段:channel_customer_rel_regist.province_id
     *
     * @return channel_customer_rel_regist.province_id, 省编码
     */
    public String getProvinceId() {
        return provinceId;
    }

    /**
     * 设置 省编码 字段:channel_customer_rel_regist.province_id
     *
     * @param provinceId the value for channel_customer_rel_regist.province_id, 省编码
     */
    public void setProvinceId(String provinceId) {
        this.provinceId = provinceId;
    }

    /**
     * 获取 省名称 字段:channel_customer_rel_regist.province_name
     *
     * @return channel_customer_rel_regist.province_name, 省名称
     */
    public String getProvinceName() {
        return provinceName;
    }

    /**
     * 设置 省名称 字段:channel_customer_rel_regist.province_name
     *
     * @param provinceName the value for channel_customer_rel_regist.province_name, 省名称
     */
    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
    }

    /**
     * 获取 市编码 字段:channel_customer_rel_regist.city_id
     *
     * @return channel_customer_rel_regist.city_id, 市编码
     */
    public String getCityId() {
        return cityId;
    }

    /**
     * 设置 市编码 字段:channel_customer_rel_regist.city_id
     *
     * @param cityId the value for channel_customer_rel_regist.city_id, 市编码
     */
    public void setCityId(String cityId) {
        this.cityId = cityId;
    }

    /**
     * 获取 市名称 字段:channel_customer_rel_regist.city_name
     *
     * @return channel_customer_rel_regist.city_name, 市名称
     */
    public String getCityName() {
        return cityName;
    }

    /**
     * 设置 市名称 字段:channel_customer_rel_regist.city_name
     *
     * @param cityName the value for channel_customer_rel_regist.city_name, 市名称
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /**
     * 获取 区县编码 字段:channel_customer_rel_regist.county_id
     *
     * @return channel_customer_rel_regist.county_id, 区县编码
     */
    public String getCountyId() {
        return countyId;
    }

    /**
     * 设置 区县编码 字段:channel_customer_rel_regist.county_id
     *
     * @param countyId the value for channel_customer_rel_regist.county_id, 区县编码
     */
    public void setCountyId(String countyId) {
        this.countyId = countyId;
    }

    /**
     * 获取 区县名称 字段:channel_customer_rel_regist.county_name
     *
     * @return channel_customer_rel_regist.county_name, 区县名称
     */
    public String getCountyName() {
        return countyName;
    }

    /**
     * 设置 区县名称 字段:channel_customer_rel_regist.county_name
     *
     * @param countyName the value for channel_customer_rel_regist.county_name, 区县名称
     */
    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    /**
     * 获取 产品编码 字段:channel_customer_rel_regist.product_id
     *
     * @return channel_customer_rel_regist.product_id, 产品编码
     */
    public String getProductId() {
        return productId;
    }

    /**
     * 设置 产品编码 字段:channel_customer_rel_regist.product_id
     *
     * @param productId the value for channel_customer_rel_regist.product_id, 产品编码
     */
    public void setProductId(String productId) {
        this.productId = productId;
    }

    /**
     * 获取 产品名称 字段:channel_customer_rel_regist.product_name
     *
     * @return channel_customer_rel_regist.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:channel_customer_rel_regist.product_name
     *
     * @param productName the value for channel_customer_rel_regist.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 登记数量 字段:channel_customer_rel_regist.regist_num
     *
     * @return channel_customer_rel_regist.regist_num, 登记数量
     */
    public Integer getRegistNum() {
        return registNum;
    }

    /**
     * 设置 登记数量 字段:channel_customer_rel_regist.regist_num
     *
     * @param registNum the value for channel_customer_rel_regist.regist_num, 登记数量
     */
    public void setRegistNum(Integer registNum) {
        this.registNum = registNum;
    }

    /**
     * 获取 结算价(分) 字段:channel_customer_rel_regist.settlement_price
     *
     * @return channel_customer_rel_regist.settlement_price, 结算价(分)
     */
    public BigDecimal getSettlementPrice() {
        if (this.settlementPrice != null) {
            return (this.settlementPrice.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.settlementPrice;
    }

    /**
     * 设置 结算价(分) 字段:channel_customer_rel_regist.settlement_price
     *
     * @param settlementPrice the value for channel_customer_rel_regist.settlement_price, 结算价(分)
     */
    public void setSettlementPrice(BigDecimal settlementPrice) {
        this.settlementPrice = settlementPrice;
    }

    /**
     * 获取 预计产生费用(分) 字段:channel_customer_rel_regist.plan_amount
     *
     * @return channel_customer_rel_regist.plan_amount, 预计产生费用(分)
     */
    public BigDecimal getPlanAmount() {
        if (this.planAmount != null) {
            return (this.planAmount.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.planAmount;
    }

    /**
     * 设置 预计产生费用(分) 字段:channel_customer_rel_regist.plan_amount
     *
     * @param planAmount the value for channel_customer_rel_regist.plan_amount, 预计产生费用(分)
     */
    public void setPlanAmount(BigDecimal planAmount) {
        this.planAmount = planAmount;
    }

    /**
     * 获取 厂方承担金额 字段:channel_customer_rel_regist.company_amount
     *
     * @return channel_customer_rel_regist.company_amount, 厂方承担金额
     */
    public BigDecimal getCompanyAmount() {
        if (this.companyAmount != null) {
            return (this.companyAmount.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.companyAmount;
    }

    /**
     * 设置 厂方承担金额 字段:channel_customer_rel_regist.company_amount
     *
     * @param companyAmount the value for channel_customer_rel_regist.company_amount, 厂方承担金额
     */
    public void setCompanyAmount(BigDecimal companyAmount) {
        this.companyAmount = companyAmount;
    }

    /**
     * 获取 厂方承担比例 字段:channel_customer_rel_regist.company_scale
     *
     * @return channel_customer_rel_regist.company_scale, 厂方承担比例
     */
    public Double getCompanyScale() {
        return companyScale;
    }

    /**
     * 设置 厂方承担比例 字段:channel_customer_rel_regist.company_scale
     *
     * @param companyScale the value for channel_customer_rel_regist.company_scale, 厂方承担比例
     */
    public void setCompanyScale(Double companyScale) {
        this.companyScale = companyScale;
    }


    /**
     * 获取 日期 字段:channel_customer_rel_regist.gmt_date
     *
     * @return channel_customer_rel_regist.gmt_date, 日期
     */
    public Date getGmtDate() {
        return gmtDate;
    }

    /**
     * 设置 日期 字段:channel_customer_rel_regist.gmt_date
     *
     * @param gmtDate the value for channel_customer_rel_regist.gmt_date, 日期
     */
    public void setGmtDate(Date gmtDate) {
        this.gmtDate = gmtDate;
    }

    /**
     * 获取 时间范围 字段:channel_customer_rel_regist.range_date
     *
     * @return channel_customer_rel_regist.range_date, 时间范围
     */
    public String getRangeDate() {
        return rangeDate;
    }

    /**
     * 设置 时间范围 字段:channel_customer_rel_regist.range_date
     *
     * @param rangeDate the value for channel_customer_rel_regist.range_date, 时间范围
     */
    public void setRangeDate(String rangeDate) {
        this.rangeDate = rangeDate;
    }

    /**
     * 获取 单位名称 字段:channel_customer_rel_regist.company_name
     *
     * @return channel_customer_rel_regist.company_name, 单位名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 设置 单位名称 字段:channel_customer_rel_regist.company_name
     *
     * @param companyName the value for channel_customer_rel_regist.company_name, 单位名称
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * 获取 单位地址 字段:channel_customer_rel_regist.company_address
     *
     * @return channel_customer_rel_regist.company_address, 单位地址
     */
    public String getCompanyAddress() {
        return companyAddress;
    }

    /**
     * 设置 单位地址 字段:channel_customer_rel_regist.company_address
     *
     * @param companyAddress the value for channel_customer_rel_regist.company_address, 单位地址
     */
    public void setCompanyAddress(String companyAddress) {
        this.companyAddress = companyAddress;
    }

    /**
     * 获取 酒店包厢 字段:channel_customer_rel_regist.hotel_box
     *
     * @return channel_customer_rel_regist.hotel_box, 酒店包厢
     */
    public String getHotelBox() {
        return hotelBox;
    }

    /**
     * 设置 酒店包厢 字段:channel_customer_rel_regist.hotel_box
     *
     * @param hotelBox the value for channel_customer_rel_regist.hotel_box, 酒店包厢
     */
    public void setHotelBox(String hotelBox) {
        this.hotelBox = hotelBox;
    }

    /**
     * 获取 会议名称 字段:channel_customer_rel_regist.Meeting_name
     *
     * @return channel_customer_rel_regist.Meeting_name, 会议名称
     */
    public String getMeetingName() {
        return meetingName;
    }

    /**
     * 设置 会议名称 字段:channel_customer_rel_regist.Meeting_name
     *
     * @param meetingName the value for channel_customer_rel_regist.Meeting_name, 会议名称
     */
    public void setMeetingName(String meetingName) {
        this.meetingName = meetingName;
    }

    /**
     * 获取 场地名称 字段:channel_customer_rel_regist.field_name
     *
     * @return channel_customer_rel_regist.field_name, 场地名称
     */
    public String getFieldName() {
        return fieldName;
    }

    /**
     * 设置 场地名称 字段:channel_customer_rel_regist.field_name
     *
     * @param fieldName the value for channel_customer_rel_regist.field_name, 场地名称
     */
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    /**
     * 获取 场地电话 字段:channel_customer_rel_regist.field_tel
     *
     * @return channel_customer_rel_regist.field_tel, 场地电话
     */
    public String getFieldTel() {
        return fieldTel;
    }

    /**
     * 设置 场地电话 字段:channel_customer_rel_regist.field_tel
     *
     * @param fieldTel the value for channel_customer_rel_regist.field_tel, 场地电话
     */
    public void setFieldTel(String fieldTel) {
        this.fieldTel = fieldTel;
    }

    /**
     * 获取 联系人 字段:channel_customer_rel_regist.contacts_name
     *
     * @return channel_customer_rel_regist.contacts_name, 联系人
     */
    public String getContactsName() {
        return contactsName;
    }

    /**
     * 设置 联系人 字段:channel_customer_rel_regist.contacts_name
     *
     * @param contactsName the value for channel_customer_rel_regist.contacts_name, 联系人
     */
    public void setContactsName(String contactsName) {
        this.contactsName = contactsName;
    }

    /**
     * 获取 联系人电话 字段:channel_customer_rel_regist.contacts_tel
     *
     * @return channel_customer_rel_regist.contacts_tel, 联系人电话
     */
    public String getContactsTel() {
        return contactsTel;
    }

    /**
     * 设置 联系人电话 字段:channel_customer_rel_regist.contacts_tel
     *
     * @param contactsTel the value for channel_customer_rel_regist.contacts_tel, 联系人电话
     */
    public void setContactsTel(String contactsTel) {
        this.contactsTel = contactsTel;
    }

    /**
     * 获取 预计到会人数 字段:channel_customer_rel_regist.plan_attendance
     *
     * @return channel_customer_rel_regist.plan_attendance, 预计到会人数
     */
    public String getPlanAttendance() {
        return planAttendance;
    }

    /**
     * 设置 预计到会人数 字段:channel_customer_rel_regist.plan_attendance
     *
     * @param planAttendance the value for channel_customer_rel_regist.plan_attendance, 预计到会人数
     */
    public void setPlanAttendance(String planAttendance) {
        this.planAttendance = planAttendance;
    }

    /**
     * 获取 预计餐费 字段:channel_customer_rel_regist.plan_meals
     *
     * @return channel_customer_rel_regist.plan_meals, 预计餐费
     */
    public BigDecimal getPlanMeals() {
        if (this.planMeals != null) {
            return (this.planMeals.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.planMeals;
    }

    /**
     * 设置 预计餐费 字段:channel_customer_rel_regist.plan_meals
     *
     * @param planMeals the value for channel_customer_rel_regist.plan_meals, 预计餐费
     */
    public void setPlanMeals(BigDecimal planMeals) {
        this.planMeals = planMeals;
    }

    /**
     * 获取 用酒量 字段:channel_customer_rel_regist.plan_wine_num
     *
     * @return channel_customer_rel_regist.plan_wine_num, 用酒量
     */
    public Integer getPlanWineNum() {
        return planWineNum;
    }

    /**
     * 设置 用酒量 字段:channel_customer_rel_regist.plan_wine_num
     *
     * @param planWineNum the value for channel_customer_rel_regist.plan_wine_num, 用酒量
     */
    public void setPlanWineNum(Integer planWineNum) {
        this.planWineNum = planWineNum;
    }

    /**
     * 获取 赠品名称及数量 字段:channel_customer_rel_regist.gift_name_num
     *
     * @return channel_customer_rel_regist.gift_name_num, 赠品名称及数量
     */
    public String getGiftNameNum() {
        return giftNameNum;
    }

    /**
     * 设置 赠品名称及数量 字段:channel_customer_rel_regist.gift_name_num
     *
     * @param giftNameNum the value for channel_customer_rel_regist.gift_name_num, 赠品名称及数量
     */
    public void setGiftNameNum(String giftNameNum) {
        this.giftNameNum = giftNameNum;
    }

    /**
     * 获取 备注 字段:channel_customer_rel_regist.notes
     *
     * @return channel_customer_rel_regist.notes, 备注
     */
    public String getNotes() {
        return notes;
    }

    /**
     * 设置 备注 字段:channel_customer_rel_regist.notes
     *
     * @param notes the value for channel_customer_rel_regist.notes, 备注
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.item_no
     *
     * @return channel_customer_rel_regist.item_no,
     */
    public String  getItemNo() {
        return itemNo;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.item_no
     *
     * @param itemNo the value for channel_customer_rel_regist.item_no,
     */
    public void setItemNo(String  itemNo) {
        this.itemNo = itemNo;
    }

    /**
     * 获取 行项目余额 字段:channel_customer_rel_regist.item_balance
     *
     * @return channel_customer_rel_regist.item_balance, 行项目余额
     */
    public BigDecimal getItemBalance() {
        if (this.itemBalance != null) {
            return (this.itemBalance.divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
        }
        return this.itemBalance;
    }

    /**
     * 设置 行项目余额 字段:channel_customer_rel_regist.item_balance
     *
     * @param itemBalance the value for channel_customer_rel_regist.item_balance, 行项目余额
     */
    public void setItemBalance(BigDecimal itemBalance) {
        this.itemBalance = itemBalance;
    }

    /**
     * 获取 督查意见 字段:channel_customer_rel_regist.audit_notes
     *
     * @return channel_customer_rel_regist.audit_notes, 督查意见
     */
    public String getAuditNotes() {
        return auditNotes;
    }

    /**
     * 设置 督查意见 字段:channel_customer_rel_regist.audit_notes
     *
     * @param auditNotes the value for channel_customer_rel_regist.audit_notes, 督查意见
     */
    public void setAuditNotes(String auditNotes) {
        this.auditNotes = auditNotes;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.create_id
     *
     * @return channel_customer_rel_regist.create_id,
     */
    public String getCreateId() {
        return createId;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.create_id
     *
     * @param createId the value for channel_customer_rel_regist.create_id,
     */
    public void setCreateId(String createId) {
        this.createId = createId;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.create_name
     *
     * @return channel_customer_rel_regist.create_name,
     */
    public String getCreateName() {
        return createName;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.create_name
     *
     * @param createName the value for channel_customer_rel_regist.create_name,
     */
    public void setCreateName(String createName) {
        this.createName = createName;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.create_date
     *
     * @return channel_customer_rel_regist.create_date,
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.create_date
     *
     * @param createDate the value for channel_customer_rel_regist.create_date,
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.modify_id
     *
     * @return channel_customer_rel_regist.modify_id,
     */
    public String getModifyId() {
        return modifyId;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.modify_id
     *
     * @param modifyId the value for channel_customer_rel_regist.modify_id,
     */
    public void setModifyId(String modifyId) {
        this.modifyId = modifyId;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.modify_name
     *
     * @return channel_customer_rel_regist.modify_name,
     */
    public String getModifyName() {
        return modifyName;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.modify_name
     *
     * @param modifyName the value for channel_customer_rel_regist.modify_name,
     */
    public void setModifyName(String modifyName) {
        this.modifyName = modifyName;
    }

    /**
     * 获取  字段:channel_customer_rel_regist.modify_date
     *
     * @return channel_customer_rel_regist.modify_date,
     */
    public Date getModifyDate() {
        return modifyDate;
    }

    /**
     * 设置  字段:channel_customer_rel_regist.modify_date
     *
     * @param modifyDate the value for channel_customer_rel_regist.modify_date,
     */
    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    /**
     * 获取 是否是宴会通 （0:不是 ，1:是） 字段:channel_customer_rel_regist.is_feast
     *
     * @return channel_customer_rel_regist.is_feast, 是否是宴会通 （0:不是 ，1:是）
     */
    public Integer getIsFeast() {
        return isFeast;
    }

    /**
     * 设置 是否是宴会通 （0:不是 ，1:是） 字段:channel_customer_rel_regist.is_feast
     *
     * @param isFeast the value for channel_customer_rel_regist.is_feast, 是否是宴会通 （0:不是 ，1:是）
     */
    public void setIsFeast(Integer isFeast) {
        this.isFeast = isFeast;
    }

}


//~ Formatted by Jindent --- http://www.jindent.com
