package com.chinayanghe.tpm.cost.vo.in;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * Sap向中如推送销量数据对象
 * 数据库表：sale_limit_detail
 */
public class SapSyncInfoVo implements Serializable {

	 /**
     * 
     * 表字段 : sap_sync_data.id
     */
    private Long id;

    /**
     * 销售发票
     * 表字段 : sap_sync_data.sale_invoice
     */
    private String saleInvoice;

    /**
     * 发票行项目
     * 表字段 : sap_sync_data.invoice_item_no
     */
    private String invoiceItemNo;

    /**
     * 打印凭证号
     * 表字段 : sap_sync_data.print_no
     */
    private String printNo;

    /**
     * 开票类型
     * 表字段 : sap_sync_data.invoice_type
     */
    private String invoiceType;

    /**
     * 会计凭证号
     * 表字段 : sap_sync_data.account_no
     */
    private String accountNo;

    /**
     * 发票类型编码
     * 表字段 : sap_sync_data.invoice_type_code
     */
    private String invoiceTypeCode;

    /**
     * 发票类型描述
     * 表字段 : sap_sync_data.invoice_type_desc
     */
    private String invoiceTypeDesc;

    /**
     * 创建人
     * 表字段 : sap_sync_data.create_user
     */
    private String createUser;

    /**
     * 销售订单
     * 表字段 : sap_sync_data.sale_order_no
     */
    private String saleOrderNo;

    /**
     * SAP销售订单状态
     * 表字段 : sap_sync_data.sap_sale_order_state
     */
    private String sapSaleOrderState;

    /**
     * 订单创建日期
     * 表字段 : sap_sync_data.order_create_date
     */
    private Date orderCreateDate;

    /**
     * 基础量确认
     * 表字段 : sap_sync_data.basic_comfirm
     */
    private String basicComfirm;

    /**
     * 经销商编码
     * 表字段 : sap_sync_data.dealer_no
     */
    private String dealerNo;

    /**
     * 经销商名称
     * 表字段 : sap_sync_data.dealer_name
     */
    private String dealerName;

    /**
     * 一级经销商
     * 表字段 : sap_sync_data.main_dealer_no
     */
    private String mainDealerNo;

    /**
     * 一级经销商名称
     * 表字段 : sap_sync_data.main_dealer_name
     */
    private String mainDealerName;

    /**
     * 新江苏编号
     * 表字段 : sap_sync_data.new_js_no
     */
    private String newJsNo;

    /**
     * 新江苏市场名称
     * 表字段 : sap_sync_data.new_js_name
     */
    private String newJsName;

    /**
     * 营销中心
     * 表字段 : sap_sync_data.market_center
     */
    private String marketCenter;

    /**
     * 大区
     * 表字段 : sap_sync_data.big_area
     */
    private String bigArea;

    /**
     * 销售组织SD编码
     * 表字段 : sap_sync_data.sale_org_code
     */
    private String saleOrgCode;

    /**
     * 销售组织描述
     * 表字段 : sap_sync_data.sale_org_desc
     */
    private String saleOrgDesc;

    /**
     * 分销渠道描述
     * 表字段 : sap_sync_data.sub_sale_chanel_desc
     */
    private String subSaleChanelDesc;

    /**
     * 产品组描述
     * 表字段 : sap_sync_data.product_desc
     */
    private String productDesc;

    /**
     * 销售办公室描述
     * 表字段 : sap_sync_data.sale_office_desc
     */
    private String saleOfficeDesc;

    /**
     * 省
     * 表字段 : sap_sync_data.provice
     */
    private String provice;

    /**
     * 市
     * 表字段 : sap_sync_data.city
     */
    private String city;

    /**
     * 县
     * 表字段 : sap_sync_data.contry
     */
    private String contry;

    /**
     * 乡镇
     * 表字段 : sap_sync_data.town
     */
    private String town;

    /**
     * 发票过账日期
     * 表字段 : sap_sync_data.invoice_acount_date
     */
    private Date invoiceAcountDate;

    /**
     * 金税发票编号
     * 表字段 : sap_sync_data.gold_invoice_no
     */
    private String goldInvoiceNo;

    /**
     * 公司代码
     * 表字段 : sap_sync_data.company_no
     */
    private String companyNo;

    /**
     * 公司名称
     * 表字段 : sap_sync_data.company_name
     */
    private String companyName;

    /**
     * 会计年度
     * 表字段 : sap_sync_data.account_year
     */
    private String accountYear;

    /**
     * 会计期间
     * 表字段 : sap_sync_data.account_term
     */
    private String accountTerm;

    /**
     * 物料编码
     * 表字段 : sap_sync_data.product_no
     */
    private String productNo;

    /**
     * 产品名称
     * 表字段 : sap_sync_data.product_name
     */
    private String productName;

    /**
     * 产品规格
     * 表字段 : sap_sync_data.product_ specification
     */
    private String productSpecification;

    /**
     * 产品渠道
     * 表字段 : sap_sync_data.product_chanel
     */
    private String productChanel;

    /**
     * 品类
     * 表字段 : sap_sync_data.product_category
     */
    private String productCategory;

    /**
     * 品牌
     * 表字段 : sap_sync_data.product_brand
     */
    private String productBrand;

    /**
     * 系列
     * 表字段 : sap_sync_data.product_set
     */
    private String productSet;

    /**
     * 大类
     * 表字段 : sap_sync_data.product_big_category
     */
    private String productBigCategory;

    /**
     * 小类
     * 表字段 : sap_sync_data.product_small_category
     */
    private String productSmallCategory;

    /**
     * 个性化标志
     * 表字段 : sap_sync_data.sepecial_flag
     */
    private String sepecialFlag;

    /**
     * 单位
     * 表字段 : sap_sync_data.product_unit
     */
    private String productUnit;

    /**
     * 货币
     * 表字段 : sap_sync_data.currency
     */
    private String currency;

    /**
     * 开票数量
     * 表字段 : sap_sync_data.invoice_num
     */
    private BigDecimal invoiceNum;

    /**
     * 开票数量(箱)
     * 表字段 : sap_sync_data.invoice_num_box
     */
    private BigDecimal invoiceNumBox;

    /**
     * 出厂单价
     * 表字段 : sap_sync_data.basic_price
     */
    private BigDecimal basicPrice;

    /**
     * 结算单价
     * 表字段 : sap_sync_data.amount_price
     */
    private BigDecimal amountPrice;

    /**
     * 结算金额
     * 表字段 : sap_sync_data.amount
     */
    private BigDecimal amount;

    /**
     * 实际开票单价
     * 表字段 : sap_sync_data.real_amount_price
     */
    private BigDecimal realAmountPrice;

    /**
     * 无税金额
     * 表字段 : sap_sync_data.no_invoice_amount
     */
    private BigDecimal noInvoiceAmount;

    /**
     * 税额
     * 表字段 : sap_sync_data.invoice_amount
     */
    private BigDecimal invoiceAmount;

    /**
     * 开票金额
     * 表字段 : sap_sync_data.invoice_total_amount
     */
    private BigDecimal invoiceTotalAmount;

    /**
     * 折扣折让
     * 表字段 : sap_sync_data.discount_amount
     */
    private BigDecimal discountAmount;

    /**
     * 统筹客情费3.13始
     * 表字段 : sap_sync_data.tc_guest_amount
     */
    private BigDecimal tcGuestAmount;

    /**
     * 客情费
     * 表字段 : sap_sync_data.guest_amount
     */
    private BigDecimal guestAmount;

    /**
     * 保证金
     * 表字段 : sap_sync_data.deposit
     */
    private BigDecimal deposit;

    /**
     * 礼品基金
     * 表字段 : sap_sync_data.gift_amount
     */
    private BigDecimal giftAmount;

    /**
     * 月返
     * 表字段 : sap_sync_data.month_amount
     */
    private BigDecimal monthAmount;

    /**
     * 季返
     * 表字段 : sap_sync_data.season_amount
     */
    private BigDecimal seasonAmount;

    /**
     * 半年返
     * 表字段 : sap_sync_data.half_year_amount
     */
    private BigDecimal halfYearAmount;

    /**
     * 年返
     * 表字段 : sap_sync_data.year_amount
     */
    private BigDecimal yearAmount;

    /**
     * 保证金(固定)批返
     * 表字段 : sap_sync_data.deposit_batch
     */
    private BigDecimal depositBatch;

    /**
     * 保证金(固定)月返
     * 表字段 : sap_sync_data.deposit_month_batch
     */
    private BigDecimal depositMonthBatch;

    /**
     * 保证金(固定)季返
     * 表字段 : sap_sync_data.deposit_season_batch
     */
    private BigDecimal depositSeasonBatch;

    /**
     * 保证金(固定)半年返
     * 表字段 : sap_sync_data.deposit_half_year_batch
     */
    private BigDecimal depositHalfYearBatch;

    /**
     * 保证金(固定)年返
     * 表字段 : sap_sync_data.deposit_year_batch
     */
    private BigDecimal depositYearBatch;

    /**
     * 客情基金
     * 表字段 : sap_sync_data.guest_basic
     */
    private BigDecimal guestBasic;

    /**
     * 宴请基金
     * 表字段 : sap_sync_data.comsumer_basic
     */
    private BigDecimal comsumerBasic;

    /**
     * 打假基金
     * 表字段 : sap_sync_data.crack_basic
     */
    private BigDecimal crackBasic;

    /**
     * 外勤业务人员
     * 表字段 : sap_sync_data.out_business
     */
    private String outBusiness;

    /**
     * 获取  字段:sap_sync_data.id
     *
     * @return sap_sync_data.id, 
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置  字段:sap_sync_data.id
     *
     * @param id the value for sap_sync_data.id, 
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取 销售发票 字段:sap_sync_data.sale_invoice
     *
     * @return sap_sync_data.sale_invoice, 销售发票
     */
    public String getSaleInvoice() {
        return saleInvoice;
    }

    /**
     * 设置 销售发票 字段:sap_sync_data.sale_invoice
     *
     * @param saleInvoice the value for sap_sync_data.sale_invoice, 销售发票
     */
    public void setSaleInvoice(String saleInvoice) {
        this.saleInvoice = saleInvoice;
    }

    /**
     * 获取 发票行项目 字段:sap_sync_data.invoice_item_no
     *
     * @return sap_sync_data.invoice_item_no, 发票行项目
     */
    public String getInvoiceItemNo() {
        return invoiceItemNo;
    }

    /**
     * 设置 发票行项目 字段:sap_sync_data.invoice_item_no
     *
     * @param invoiceItemNo the value for sap_sync_data.invoice_item_no, 发票行项目
     */
    public void setInvoiceItemNo(String invoiceItemNo) {
        this.invoiceItemNo = invoiceItemNo;
    }

    /**
     * 获取 打印凭证号 字段:sap_sync_data.print_no
     *
     * @return sap_sync_data.print_no, 打印凭证号
     */
    public String getPrintNo() {
        return printNo;
    }

    /**
     * 设置 打印凭证号 字段:sap_sync_data.print_no
     *
     * @param printNo the value for sap_sync_data.print_no, 打印凭证号
     */
    public void setPrintNo(String printNo) {
        this.printNo = printNo;
    }

    /**
     * 获取 开票类型 字段:sap_sync_data.invoice_type
     *
     * @return sap_sync_data.invoice_type, 开票类型
     */
    public String getInvoiceType() {
        return invoiceType;
    }

    /**
     * 设置 开票类型 字段:sap_sync_data.invoice_type
     *
     * @param invoiceType the value for sap_sync_data.invoice_type, 开票类型
     */
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    /**
     * 获取 会计凭证号 字段:sap_sync_data.account_no
     *
     * @return sap_sync_data.account_no, 会计凭证号
     */
    public String getAccountNo() {
        return accountNo;
    }

    /**
     * 设置 会计凭证号 字段:sap_sync_data.account_no
     *
     * @param accountNo the value for sap_sync_data.account_no, 会计凭证号
     */
    public void setAccountNo(String accountNo) {
        this.accountNo = accountNo;
    }

    /**
     * 获取 发票类型编码 字段:sap_sync_data.invoice_type_code
     *
     * @return sap_sync_data.invoice_type_code, 发票类型编码
     */
    public String getInvoiceTypeCode() {
        return invoiceTypeCode;
    }

    /**
     * 设置 发票类型编码 字段:sap_sync_data.invoice_type_code
     *
     * @param invoiceTypeCode the value for sap_sync_data.invoice_type_code, 发票类型编码
     */
    public void setInvoiceTypeCode(String invoiceTypeCode) {
        this.invoiceTypeCode = invoiceTypeCode;
    }

    /**
     * 获取 发票类型描述 字段:sap_sync_data.invoice_type_desc
     *
     * @return sap_sync_data.invoice_type_desc, 发票类型描述
     */
    public String getInvoiceTypeDesc() {
        return invoiceTypeDesc;
    }

    /**
     * 设置 发票类型描述 字段:sap_sync_data.invoice_type_desc
     *
     * @param invoiceTypeDesc the value for sap_sync_data.invoice_type_desc, 发票类型描述
     */
    public void setInvoiceTypeDesc(String invoiceTypeDesc) {
        this.invoiceTypeDesc = invoiceTypeDesc;
    }

    /**
     * 获取 创建人 字段:sap_sync_data.create_user
     *
     * @return sap_sync_data.create_user, 创建人
     */
    public String getCreateUser() {
        return createUser;
    }

    /**
     * 设置 创建人 字段:sap_sync_data.create_user
     *
     * @param createUser the value for sap_sync_data.create_user, 创建人
     */
    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    /**
     * 获取 销售订单 字段:sap_sync_data.sale_order_no
     *
     * @return sap_sync_data.sale_order_no, 销售订单
     */
    public String getSaleOrderNo() {
        return saleOrderNo;
    }

    /**
     * 设置 销售订单 字段:sap_sync_data.sale_order_no
     *
     * @param saleOrderNo the value for sap_sync_data.sale_order_no, 销售订单
     */
    public void setSaleOrderNo(String saleOrderNo) {
        this.saleOrderNo = saleOrderNo;
    }

    /**
     * 获取 SAP销售订单状态 字段:sap_sync_data.sap_sale_order_state
     *
     * @return sap_sync_data.sap_sale_order_state, SAP销售订单状态
     */
    public String getSapSaleOrderState() {
        return sapSaleOrderState;
    }

    /**
     * 设置 SAP销售订单状态 字段:sap_sync_data.sap_sale_order_state
     *
     * @param sapSaleOrderState the value for sap_sync_data.sap_sale_order_state, SAP销售订单状态
     */
    public void setSapSaleOrderState(String sapSaleOrderState) {
        this.sapSaleOrderState = sapSaleOrderState;
    }

    /**
     * 获取 订单创建日期 字段:sap_sync_data.order_create_date
     *
     * @return sap_sync_data.order_create_date, 订单创建日期
     */
    public Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 设置 订单创建日期 字段:sap_sync_data.order_create_date
     *
     * @param orderCreateDate the value for sap_sync_data.order_create_date, 订单创建日期
     */
    public void setOrderCreateDate(Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }

    /**
     * 获取 基础量确认 字段:sap_sync_data.basic_comfirm
     *
     * @return sap_sync_data.basic_comfirm, 基础量确认
     */
    public String getBasicComfirm() {
        return basicComfirm;
    }

    /**
     * 设置 基础量确认 字段:sap_sync_data.basic_comfirm
     *
     * @param basicComfirm the value for sap_sync_data.basic_comfirm, 基础量确认
     */
    public void setBasicComfirm(String basicComfirm) {
        this.basicComfirm = basicComfirm;
    }

    /**
     * 获取 经销商编码 字段:sap_sync_data.dealer_no
     *
     * @return sap_sync_data.dealer_no, 经销商编码
     */
    public String getDealerNo() {
        return dealerNo;
    }

    /**
     * 设置 经销商编码 字段:sap_sync_data.dealer_no
     *
     * @param dealerNo the value for sap_sync_data.dealer_no, 经销商编码
     */
    public void setDealerNo(String dealerNo) {
        this.dealerNo = dealerNo;
    }

    /**
     * 获取 经销商名称 字段:sap_sync_data.dealer_name
     *
     * @return sap_sync_data.dealer_name, 经销商名称
     */
    public String getDealerName() {
        return dealerName;
    }

    /**
     * 设置 经销商名称 字段:sap_sync_data.dealer_name
     *
     * @param dealerName the value for sap_sync_data.dealer_name, 经销商名称
     */
    public void setDealerName(String dealerName) {
        this.dealerName = dealerName;
    }

    /**
     * 获取 一级经销商 字段:sap_sync_data.main_dealer_no
     *
     * @return sap_sync_data.main_dealer_no, 一级经销商
     */
    public String getMainDealerNo() {
        return mainDealerNo;
    }

    /**
     * 设置 一级经销商 字段:sap_sync_data.main_dealer_no
     *
     * @param mainDealerNo the value for sap_sync_data.main_dealer_no, 一级经销商
     */
    public void setMainDealerNo(String mainDealerNo) {
        this.mainDealerNo = mainDealerNo;
    }

    /**
     * 获取 一级经销商名称 字段:sap_sync_data.main_dealer_name
     *
     * @return sap_sync_data.main_dealer_name, 一级经销商名称
     */
    public String getMainDealerName() {
        return mainDealerName;
    }

    /**
     * 设置 一级经销商名称 字段:sap_sync_data.main_dealer_name
     *
     * @param mainDealerName the value for sap_sync_data.main_dealer_name, 一级经销商名称
     */
    public void setMainDealerName(String mainDealerName) {
        this.mainDealerName = mainDealerName;
    }

    /**
     * 获取 新江苏编号 字段:sap_sync_data.new_js_no
     *
     * @return sap_sync_data.new_js_no, 新江苏编号
     */
    public String getNewJsNo() {
        return newJsNo;
    }

    /**
     * 设置 新江苏编号 字段:sap_sync_data.new_js_no
     *
     * @param newJsNo the value for sap_sync_data.new_js_no, 新江苏编号
     */
    public void setNewJsNo(String newJsNo) {
        this.newJsNo = newJsNo;
    }

    /**
     * 获取 新江苏市场名称 字段:sap_sync_data.new_js_name
     *
     * @return sap_sync_data.new_js_name, 新江苏市场名称
     */
    public String getNewJsName() {
        return newJsName;
    }

    /**
     * 设置 新江苏市场名称 字段:sap_sync_data.new_js_name
     *
     * @param newJsName the value for sap_sync_data.new_js_name, 新江苏市场名称
     */
    public void setNewJsName(String newJsName) {
        this.newJsName = newJsName;
    }

    /**
     * 获取 营销中心 字段:sap_sync_data.market_center
     *
     * @return sap_sync_data.market_center, 营销中心
     */
    public String getMarketCenter() {
        return marketCenter;
    }

    /**
     * 设置 营销中心 字段:sap_sync_data.market_center
     *
     * @param marketCenter the value for sap_sync_data.market_center, 营销中心
     */
    public void setMarketCenter(String marketCenter) {
        this.marketCenter = marketCenter;
    }

    /**
     * 获取 大区 字段:sap_sync_data.big_area
     *
     * @return sap_sync_data.big_area, 大区
     */
    public String getBigArea() {
        return bigArea;
    }

    /**
     * 设置 大区 字段:sap_sync_data.big_area
     *
     * @param bigArea the value for sap_sync_data.big_area, 大区
     */
    public void setBigArea(String bigArea) {
        this.bigArea = bigArea;
    }

    /**
     * 获取 销售组织SD编码 字段:sap_sync_data.sale_org_code
     *
     * @return sap_sync_data.sale_org_code, 销售组织SD编码
     */
    public String getSaleOrgCode() {
        return saleOrgCode;
    }

    /**
     * 设置 销售组织SD编码 字段:sap_sync_data.sale_org_code
     *
     * @param saleOrgCode the value for sap_sync_data.sale_org_code, 销售组织SD编码
     */
    public void setSaleOrgCode(String saleOrgCode) {
        this.saleOrgCode = saleOrgCode;
    }

    /**
     * 获取 销售组织描述 字段:sap_sync_data.sale_org_desc
     *
     * @return sap_sync_data.sale_org_desc, 销售组织描述
     */
    public String getSaleOrgDesc() {
        return saleOrgDesc;
    }

    /**
     * 设置 销售组织描述 字段:sap_sync_data.sale_org_desc
     *
     * @param saleOrgDesc the value for sap_sync_data.sale_org_desc, 销售组织描述
     */
    public void setSaleOrgDesc(String saleOrgDesc) {
        this.saleOrgDesc = saleOrgDesc;
    }

    /**
     * 获取 分销渠道描述 字段:sap_sync_data.sub_sale_chanel_desc
     *
     * @return sap_sync_data.sub_sale_chanel_desc, 分销渠道描述
     */
    public String getSubSaleChanelDesc() {
        return subSaleChanelDesc;
    }

    /**
     * 设置 分销渠道描述 字段:sap_sync_data.sub_sale_chanel_desc
     *
     * @param subSaleChanelDesc the value for sap_sync_data.sub_sale_chanel_desc, 分销渠道描述
     */
    public void setSubSaleChanelDesc(String subSaleChanelDesc) {
        this.subSaleChanelDesc = subSaleChanelDesc;
    }

    /**
     * 获取 产品组描述 字段:sap_sync_data.product_desc
     *
     * @return sap_sync_data.product_desc, 产品组描述
     */
    public String getProductDesc() {
        return productDesc;
    }

    /**
     * 设置 产品组描述 字段:sap_sync_data.product_desc
     *
     * @param productDesc the value for sap_sync_data.product_desc, 产品组描述
     */
    public void setProductDesc(String productDesc) {
        this.productDesc = productDesc;
    }

    /**
     * 获取 销售办公室描述 字段:sap_sync_data.sale_office_desc
     *
     * @return sap_sync_data.sale_office_desc, 销售办公室描述
     */
    public String getSaleOfficeDesc() {
        return saleOfficeDesc;
    }

    /**
     * 设置 销售办公室描述 字段:sap_sync_data.sale_office_desc
     *
     * @param saleOfficeDesc the value for sap_sync_data.sale_office_desc, 销售办公室描述
     */
    public void setSaleOfficeDesc(String saleOfficeDesc) {
        this.saleOfficeDesc = saleOfficeDesc;
    }

    /**
     * 获取 省 字段:sap_sync_data.provice
     *
     * @return sap_sync_data.provice, 省
     */
    public String getProvice() {
        return provice;
    }

    /**
     * 设置 省 字段:sap_sync_data.provice
     *
     * @param provice the value for sap_sync_data.provice, 省
     */
    public void setProvice(String provice) {
        this.provice = provice;
    }

    /**
     * 获取 市 字段:sap_sync_data.city
     *
     * @return sap_sync_data.city, 市
     */
    public String getCity() {
        return city;
    }

    /**
     * 设置 市 字段:sap_sync_data.city
     *
     * @param city the value for sap_sync_data.city, 市
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * 获取 县 字段:sap_sync_data.contry
     *
     * @return sap_sync_data.contry, 县
     */
    public String getContry() {
        return contry;
    }

    /**
     * 设置 县 字段:sap_sync_data.contry
     *
     * @param contry the value for sap_sync_data.contry, 县
     */
    public void setContry(String contry) {
        this.contry = contry;
    }

    /**
     * 获取 乡镇 字段:sap_sync_data.town
     *
     * @return sap_sync_data.town, 乡镇
     */
    public String getTown() {
        return town;
    }

    /**
     * 设置 乡镇 字段:sap_sync_data.town
     *
     * @param town the value for sap_sync_data.town, 乡镇
     */
    public void setTown(String town) {
        this.town = town;
    }

    /**
     * 获取 发票过账日期 字段:sap_sync_data.invoice_acount_date
     *
     * @return sap_sync_data.invoice_acount_date, 发票过账日期
     */
    public Date getInvoiceAcountDate() {
        return invoiceAcountDate;
    }

    /**
     * 设置 发票过账日期 字段:sap_sync_data.invoice_acount_date
     *
     * @param invoiceAcountDate the value for sap_sync_data.invoice_acount_date, 发票过账日期
     */
    public void setInvoiceAcountDate(Date invoiceAcountDate) {
        this.invoiceAcountDate = invoiceAcountDate;
    }

    /**
     * 获取 金税发票编号 字段:sap_sync_data.gold_invoice_no
     *
     * @return sap_sync_data.gold_invoice_no, 金税发票编号
     */
    public String getGoldInvoiceNo() {
        return goldInvoiceNo;
    }

    /**
     * 设置 金税发票编号 字段:sap_sync_data.gold_invoice_no
     *
     * @param goldInvoiceNo the value for sap_sync_data.gold_invoice_no, 金税发票编号
     */
    public void setGoldInvoiceNo(String goldInvoiceNo) {
        this.goldInvoiceNo = goldInvoiceNo;
    }

    /**
     * 获取 公司代码 字段:sap_sync_data.company_no
     *
     * @return sap_sync_data.company_no, 公司代码
     */
    public String getCompanyNo() {
        return companyNo;
    }

    /**
     * 设置 公司代码 字段:sap_sync_data.company_no
     *
     * @param companyNo the value for sap_sync_data.company_no, 公司代码
     */
    public void setCompanyNo(String companyNo) {
        this.companyNo = companyNo;
    }

    /**
     * 获取 公司名称 字段:sap_sync_data.company_name
     *
     * @return sap_sync_data.company_name, 公司名称
     */
    public String getCompanyName() {
        return companyName;
    }

    /**
     * 设置 公司名称 字段:sap_sync_data.company_name
     *
     * @param companyName the value for sap_sync_data.company_name, 公司名称
     */
    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    /**
     * 获取 会计年度 字段:sap_sync_data.account_year
     *
     * @return sap_sync_data.account_year, 会计年度
     */
    public String getAccountYear() {
        return accountYear;
    }

    /**
     * 设置 会计年度 字段:sap_sync_data.account_year
     *
     * @param accountYear the value for sap_sync_data.account_year, 会计年度
     */
    public void setAccountYear(String accountYear) {
        this.accountYear = accountYear;
    }

    /**
     * 获取 会计期间 字段:sap_sync_data.account_term
     *
     * @return sap_sync_data.account_term, 会计期间
     */
    public String getAccountTerm() {
        return accountTerm;
    }

    /**
     * 设置 会计期间 字段:sap_sync_data.account_term
     *
     * @param accountTerm the value for sap_sync_data.account_term, 会计期间
     */
    public void setAccountTerm(String accountTerm) {
        this.accountTerm = accountTerm;
    }

    /**
     * 获取 物料编码 字段:sap_sync_data.product_no
     *
     * @return sap_sync_data.product_no, 物料编码
     */
    public String getProductNo() {
        return productNo;
    }

    /**
     * 设置 物料编码 字段:sap_sync_data.product_no
     *
     * @param productNo the value for sap_sync_data.product_no, 物料编码
     */
    public void setProductNo(String productNo) {
        this.productNo = productNo;
    }

    /**
     * 获取 产品名称 字段:sap_sync_data.product_name
     *
     * @return sap_sync_data.product_name, 产品名称
     */
    public String getProductName() {
        return productName;
    }

    /**
     * 设置 产品名称 字段:sap_sync_data.product_name
     *
     * @param productName the value for sap_sync_data.product_name, 产品名称
     */
    public void setProductName(String productName) {
        this.productName = productName;
    }

    /**
     * 获取 产品规格 字段:sap_sync_data.product_ specification
     *
     * @return sap_sync_data.product_ specification, 产品规格
     */
    public String getProductSpecification() {
        return productSpecification;
    }

    /**
     * 设置 产品规格 字段:sap_sync_data.product_ specification
     *
     * @param productSpecification the value for sap_sync_data.product_ specification, 产品规格
     */
    public void setProductSpecification(String productSpecification) {
        this.productSpecification = productSpecification;
    }

    /**
     * 获取 产品渠道 字段:sap_sync_data.product_chanel
     *
     * @return sap_sync_data.product_chanel, 产品渠道
     */
    public String getProductChanel() {
        return productChanel;
    }

    /**
     * 设置 产品渠道 字段:sap_sync_data.product_chanel
     *
     * @param productChanel the value for sap_sync_data.product_chanel, 产品渠道
     */
    public void setProductChanel(String productChanel) {
        this.productChanel = productChanel;
    }

    /**
     * 获取 品类 字段:sap_sync_data.product_category
     *
     * @return sap_sync_data.product_category, 品类
     */
    public String getProductCategory() {
        return productCategory;
    }

    /**
     * 设置 品类 字段:sap_sync_data.product_category
     *
     * @param productCategory the value for sap_sync_data.product_category, 品类
     */
    public void setProductCategory(String productCategory) {
        this.productCategory = productCategory;
    }

    /**
     * 获取 品牌 字段:sap_sync_data.product_brand
     *
     * @return sap_sync_data.product_brand, 品牌
     */
    public String getProductBrand() {
        return productBrand;
    }

    /**
     * 设置 品牌 字段:sap_sync_data.product_brand
     *
     * @param productBrand the value for sap_sync_data.product_brand, 品牌
     */
    public void setProductBrand(String productBrand) {
        this.productBrand = productBrand;
    }

    /**
     * 获取 系列 字段:sap_sync_data.product_set
     *
     * @return sap_sync_data.product_set, 系列
     */
    public String getProductSet() {
        return productSet;
    }

    /**
     * 设置 系列 字段:sap_sync_data.product_set
     *
     * @param productSet the value for sap_sync_data.product_set, 系列
     */
    public void setProductSet(String productSet) {
        this.productSet = productSet;
    }

    /**
     * 获取 大类 字段:sap_sync_data.product_big_category
     *
     * @return sap_sync_data.product_big_category, 大类
     */
    public String getProductBigCategory() {
        return productBigCategory;
    }

    /**
     * 设置 大类 字段:sap_sync_data.product_big_category
     *
     * @param productBigCategory the value for sap_sync_data.product_big_category, 大类
     */
    public void setProductBigCategory(String productBigCategory) {
        this.productBigCategory = productBigCategory;
    }

    /**
     * 获取 小类 字段:sap_sync_data.product_small_category
     *
     * @return sap_sync_data.product_small_category, 小类
     */
    public String getProductSmallCategory() {
        return productSmallCategory;
    }

    /**
     * 设置 小类 字段:sap_sync_data.product_small_category
     *
     * @param productSmallCategory the value for sap_sync_data.product_small_category, 小类
     */
    public void setProductSmallCategory(String productSmallCategory) {
        this.productSmallCategory = productSmallCategory;
    }

    /**
     * 获取 个性化标志 字段:sap_sync_data.sepecial_flag
     *
     * @return sap_sync_data.sepecial_flag, 个性化标志
     */
    public String getSepecialFlag() {
        return sepecialFlag;
    }

    /**
     * 设置 个性化标志 字段:sap_sync_data.sepecial_flag
     *
     * @param sepecialFlag the value for sap_sync_data.sepecial_flag, 个性化标志
     */
    public void setSepecialFlag(String sepecialFlag) {
        this.sepecialFlag = sepecialFlag;
    }

    /**
     * 获取 单位 字段:sap_sync_data.product_unit
     *
     * @return sap_sync_data.product_unit, 单位
     */
    public String getProductUnit() {
        return productUnit;
    }

    /**
     * 设置 单位 字段:sap_sync_data.product_unit
     *
     * @param productUnit the value for sap_sync_data.product_unit, 单位
     */
    public void setProductUnit(String productUnit) {
        this.productUnit = productUnit;
    }

    /**
     * 获取 货币 字段:sap_sync_data.currency
     *
     * @return sap_sync_data.currency, 货币
     */
    public String getCurrency() {
        return currency;
    }

    /**
     * 设置 货币 字段:sap_sync_data.currency
     *
     * @param currency the value for sap_sync_data.currency, 货币
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * 获取 开票数量 字段:sap_sync_data.invoice_num
     *
     * @return sap_sync_data.invoice_num, 开票数量
     */
    public BigDecimal getInvoiceNum() {
        return invoiceNum;
    }

    /**
     * 设置 开票数量 字段:sap_sync_data.invoice_num
     *
     * @param invoiceNum the value for sap_sync_data.invoice_num, 开票数量
     */
    public void setInvoiceNum(BigDecimal invoiceNum) {
        this.invoiceNum = invoiceNum;
    }

    /**
     * 获取 开票数量(箱) 字段:sap_sync_data.invoice_num_box
     *
     * @return sap_sync_data.invoice_num_box, 开票数量(箱)
     */
    public BigDecimal getInvoiceNumBox() {
        return invoiceNumBox;
    }

    /**
     * 设置 开票数量(箱) 字段:sap_sync_data.invoice_num_box
     *
     * @param invoiceNumBox the value for sap_sync_data.invoice_num_box, 开票数量(箱)
     */
    public void setInvoiceNumBox(BigDecimal invoiceNumBox) {
        this.invoiceNumBox = invoiceNumBox;
    }

    /**
     * 获取 出厂单价 字段:sap_sync_data.basic_price
     *
     * @return sap_sync_data.basic_price, 出厂单价
     */
    public BigDecimal getBasicPrice() {
        return basicPrice;
    }

    /**
     * 设置 出厂单价 字段:sap_sync_data.basic_price
     *
     * @param basicPrice the value for sap_sync_data.basic_price, 出厂单价
     */
    public void setBasicPrice(BigDecimal basicPrice) {
        this.basicPrice = basicPrice;
    }

    /**
     * 获取 结算单价 字段:sap_sync_data.amount_price
     *
     * @return sap_sync_data.amount_price, 结算单价
     */
    public BigDecimal getAmountPrice() {
        return amountPrice;
    }

    /**
     * 设置 结算单价 字段:sap_sync_data.amount_price
     *
     * @param amountPrice the value for sap_sync_data.amount_price, 结算单价
     */
    public void setAmountPrice(BigDecimal amountPrice) {
        this.amountPrice = amountPrice;
    }

    /**
     * 获取 结算金额 字段:sap_sync_data.amount
     *
     * @return sap_sync_data.amount, 结算金额
     */
    public BigDecimal getAmount() {
        return amount;
    }

    /**
     * 设置 结算金额 字段:sap_sync_data.amount
     *
     * @param amount the value for sap_sync_data.amount, 结算金额
     */
    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    /**
     * 获取 实际开票单价 字段:sap_sync_data.real_amount_price
     *
     * @return sap_sync_data.real_amount_price, 实际开票单价
     */
    public BigDecimal getRealAmountPrice() {
        return realAmountPrice;
    }

    /**
     * 设置 实际开票单价 字段:sap_sync_data.real_amount_price
     *
     * @param realAmountPrice the value for sap_sync_data.real_amount_price, 实际开票单价
     */
    public void setRealAmountPrice(BigDecimal realAmountPrice) {
        this.realAmountPrice = realAmountPrice;
    }

    /**
     * 获取 无税金额 字段:sap_sync_data.no_invoice_amount
     *
     * @return sap_sync_data.no_invoice_amount, 无税金额
     */
    public BigDecimal getNoInvoiceAmount() {
        return noInvoiceAmount;
    }

    /**
     * 设置 无税金额 字段:sap_sync_data.no_invoice_amount
     *
     * @param noInvoiceAmount the value for sap_sync_data.no_invoice_amount, 无税金额
     */
    public void setNoInvoiceAmount(BigDecimal noInvoiceAmount) {
        this.noInvoiceAmount = noInvoiceAmount;
    }

    /**
     * 获取 税额 字段:sap_sync_data.invoice_amount
     *
     * @return sap_sync_data.invoice_amount, 税额
     */
    public BigDecimal getInvoiceAmount() {
        return invoiceAmount;
    }

    /**
     * 设置 税额 字段:sap_sync_data.invoice_amount
     *
     * @param invoiceAmount the value for sap_sync_data.invoice_amount, 税额
     */
    public void setInvoiceAmount(BigDecimal invoiceAmount) {
        this.invoiceAmount = invoiceAmount;
    }

    /**
     * 获取 开票金额 字段:sap_sync_data.invoice_total_amount
     *
     * @return sap_sync_data.invoice_total_amount, 开票金额
     */
    public BigDecimal getInvoiceTotalAmount() {
        return invoiceTotalAmount;
    }

    /**
     * 设置 开票金额 字段:sap_sync_data.invoice_total_amount
     *
     * @param invoiceTotalAmount the value for sap_sync_data.invoice_total_amount, 开票金额
     */
    public void setInvoiceTotalAmount(BigDecimal invoiceTotalAmount) {
        this.invoiceTotalAmount = invoiceTotalAmount;
    }

    /**
     * 获取 折扣折让 字段:sap_sync_data.discount_amount
     *
     * @return sap_sync_data.discount_amount, 折扣折让
     */
    public BigDecimal getDiscountAmount() {
        return discountAmount;
    }

    /**
     * 设置 折扣折让 字段:sap_sync_data.discount_amount
     *
     * @param discountAmount the value for sap_sync_data.discount_amount, 折扣折让
     */
    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    /**
     * 获取 统筹客情费3.13始 字段:sap_sync_data.tc_guest_amount
     *
     * @return sap_sync_data.tc_guest_amount, 统筹客情费3.13始
     */
    public BigDecimal getTcGuestAmount() {
        return tcGuestAmount;
    }

    /**
     * 设置 统筹客情费3.13始 字段:sap_sync_data.tc_guest_amount
     *
     * @param tcGuestAmount the value for sap_sync_data.tc_guest_amount, 统筹客情费3.13始
     */
    public void setTcGuestAmount(BigDecimal tcGuestAmount) {
        this.tcGuestAmount = tcGuestAmount;
    }

    /**
     * 获取 客情费 字段:sap_sync_data.guest_amount
     *
     * @return sap_sync_data.guest_amount, 客情费
     */
    public BigDecimal getGuestAmount() {
        return guestAmount;
    }

    /**
     * 设置 客情费 字段:sap_sync_data.guest_amount
     *
     * @param guestAmount the value for sap_sync_data.guest_amount, 客情费
     */
    public void setGuestAmount(BigDecimal guestAmount) {
        this.guestAmount = guestAmount;
    }

    /**
     * 获取 保证金 字段:sap_sync_data.deposit
     *
     * @return sap_sync_data.deposit, 保证金
     */
    public BigDecimal getDeposit() {
        return deposit;
    }

    /**
     * 设置 保证金 字段:sap_sync_data.deposit
     *
     * @param deposit the value for sap_sync_data.deposit, 保证金
     */
    public void setDeposit(BigDecimal deposit) {
        this.deposit = deposit;
    }

    /**
     * 获取 礼品基金 字段:sap_sync_data.gift_amount
     *
     * @return sap_sync_data.gift_amount, 礼品基金
     */
    public BigDecimal getGiftAmount() {
        return giftAmount;
    }

    /**
     * 设置 礼品基金 字段:sap_sync_data.gift_amount
     *
     * @param giftAmount the value for sap_sync_data.gift_amount, 礼品基金
     */
    public void setGiftAmount(BigDecimal giftAmount) {
        this.giftAmount = giftAmount;
    }

    /**
     * 获取 月返 字段:sap_sync_data.month_amount
     *
     * @return sap_sync_data.month_amount, 月返
     */
    public BigDecimal getMonthAmount() {
        return monthAmount;
    }

    /**
     * 设置 月返 字段:sap_sync_data.month_amount
     *
     * @param monthAmount the value for sap_sync_data.month_amount, 月返
     */
    public void setMonthAmount(BigDecimal monthAmount) {
        this.monthAmount = monthAmount;
    }

    /**
     * 获取 季返 字段:sap_sync_data.season_amount
     *
     * @return sap_sync_data.season_amount, 季返
     */
    public BigDecimal getSeasonAmount() {
        return seasonAmount;
    }

    /**
     * 设置 季返 字段:sap_sync_data.season_amount
     *
     * @param seasonAmount the value for sap_sync_data.season_amount, 季返
     */
    public void setSeasonAmount(BigDecimal seasonAmount) {
        this.seasonAmount = seasonAmount;
    }

    /**
     * 获取 半年返 字段:sap_sync_data.half_year_amount
     *
     * @return sap_sync_data.half_year_amount, 半年返
     */
    public BigDecimal getHalfYearAmount() {
        return halfYearAmount;
    }

    /**
     * 设置 半年返 字段:sap_sync_data.half_year_amount
     *
     * @param halfYearAmount the value for sap_sync_data.half_year_amount, 半年返
     */
    public void setHalfYearAmount(BigDecimal halfYearAmount) {
        this.halfYearAmount = halfYearAmount;
    }

    /**
     * 获取 年返 字段:sap_sync_data.year_amount
     *
     * @return sap_sync_data.year_amount, 年返
     */
    public BigDecimal getYearAmount() {
        return yearAmount;
    }

    /**
     * 设置 年返 字段:sap_sync_data.year_amount
     *
     * @param yearAmount the value for sap_sync_data.year_amount, 年返
     */
    public void setYearAmount(BigDecimal yearAmount) {
        this.yearAmount = yearAmount;
    }

    /**
     * 获取 保证金(固定)批返 字段:sap_sync_data.deposit_batch
     *
     * @return sap_sync_data.deposit_batch, 保证金(固定)批返
     */
    public BigDecimal getDepositBatch() {
        return depositBatch;
    }

    /**
     * 设置 保证金(固定)批返 字段:sap_sync_data.deposit_batch
     *
     * @param depositBatch the value for sap_sync_data.deposit_batch, 保证金(固定)批返
     */
    public void setDepositBatch(BigDecimal depositBatch) {
        this.depositBatch = depositBatch;
    }

    /**
     * 获取 保证金(固定)月返 字段:sap_sync_data.deposit_month_batch
     *
     * @return sap_sync_data.deposit_month_batch, 保证金(固定)月返
     */
    public BigDecimal getDepositMonthBatch() {
        return depositMonthBatch;
    }

    /**
     * 设置 保证金(固定)月返 字段:sap_sync_data.deposit_month_batch
     *
     * @param depositMonthBatch the value for sap_sync_data.deposit_month_batch, 保证金(固定)月返
     */
    public void setDepositMonthBatch(BigDecimal depositMonthBatch) {
        this.depositMonthBatch = depositMonthBatch;
    }

    /**
     * 获取 保证金(固定)季返 字段:sap_sync_data.deposit_season_batch
     *
     * @return sap_sync_data.deposit_season_batch, 保证金(固定)季返
     */
    public BigDecimal getDepositSeasonBatch() {
        return depositSeasonBatch;
    }

    /**
     * 设置 保证金(固定)季返 字段:sap_sync_data.deposit_season_batch
     *
     * @param depositSeasonBatch the value for sap_sync_data.deposit_season_batch, 保证金(固定)季返
     */
    public void setDepositSeasonBatch(BigDecimal depositSeasonBatch) {
        this.depositSeasonBatch = depositSeasonBatch;
    }

    /**
     * 获取 保证金(固定)半年返 字段:sap_sync_data.deposit_half_year_batch
     *
     * @return sap_sync_data.deposit_half_year_batch, 保证金(固定)半年返
     */
    public BigDecimal getDepositHalfYearBatch() {
        return depositHalfYearBatch;
    }

    /**
     * 设置 保证金(固定)半年返 字段:sap_sync_data.deposit_half_year_batch
     *
     * @param depositHalfYearBatch the value for sap_sync_data.deposit_half_year_batch, 保证金(固定)半年返
     */
    public void setDepositHalfYearBatch(BigDecimal depositHalfYearBatch) {
        this.depositHalfYearBatch = depositHalfYearBatch;
    }

    /**
     * 获取 保证金(固定)年返 字段:sap_sync_data.deposit_year_batch
     *
     * @return sap_sync_data.deposit_year_batch, 保证金(固定)年返
     */
    public BigDecimal getDepositYearBatch() {
        return depositYearBatch;
    }

    /**
     * 设置 保证金(固定)年返 字段:sap_sync_data.deposit_year_batch
     *
     * @param depositYearBatch the value for sap_sync_data.deposit_year_batch, 保证金(固定)年返
     */
    public void setDepositYearBatch(BigDecimal depositYearBatch) {
        this.depositYearBatch = depositYearBatch;
    }

    /**
     * 获取 客情基金 字段:sap_sync_data.guest_basic
     *
     * @return sap_sync_data.guest_basic, 客情基金
     */
    public BigDecimal getGuestBasic() {
        return guestBasic;
    }

    /**
     * 设置 客情基金 字段:sap_sync_data.guest_basic
     *
     * @param guestBasic the value for sap_sync_data.guest_basic, 客情基金
     */
    public void setGuestBasic(BigDecimal guestBasic) {
        this.guestBasic = guestBasic;
    }

    /**
     * 获取 宴请基金 字段:sap_sync_data.comsumer_basic
     *
     * @return sap_sync_data.comsumer_basic, 宴请基金
     */
    public BigDecimal getComsumerBasic() {
        return comsumerBasic;
    }

    /**
     * 设置 宴请基金 字段:sap_sync_data.comsumer_basic
     *
     * @param comsumerBasic the value for sap_sync_data.comsumer_basic, 宴请基金
     */
    public void setComsumerBasic(BigDecimal comsumerBasic) {
        this.comsumerBasic = comsumerBasic;
    }

    /**
     * 获取 打假基金 字段:sap_sync_data.crack_basic
     *
     * @return sap_sync_data.crack_basic, 打假基金
     */
    public BigDecimal getCrackBasic() {
        return crackBasic;
    }

    /**
     * 设置 打假基金 字段:sap_sync_data.crack_basic
     *
     * @param crackBasic the value for sap_sync_data.crack_basic, 打假基金
     */
    public void setCrackBasic(BigDecimal crackBasic) {
        this.crackBasic = crackBasic;
    }

    /**
     * 获取 外勤业务人员 字段:sap_sync_data.out_business
     *
     * @return sap_sync_data.out_business, 外勤业务人员
     */
    public String getOutBusiness() {
        return outBusiness;
    }

    /**
     * 设置 外勤业务人员 字段:sap_sync_data.out_business
     *
     * @param outBusiness the value for sap_sync_data.out_business, 外勤业务人员
     */
    public void setOutBusiness(String outBusiness) {
        this.outBusiness = outBusiness;
    }
}