
package com.chinayanghe.tpm.cost.rpc;

import java.util.List;
import java.util.Map;

import com.chinayanghe.tpm.cost.vo.FormTypeEnum;

import cn.com.bizunited.cp.common.pagination.Page;

/**
 * 费用表单接口类
 * @author arthur
 *
 */
public interface CostMobileRpcService {

	final String ACTIVITYENUM_PRE="activity";
	/**
	 * 根据单号查询管理信息
	 * @param formNo  单号
	 * @param selectField 要查询的字段
	 */
	public Map<String,Object> getManageInfoMapInfo(String formNo,String selectField);
	
	/**
	 * 根据单号查询区域市场信息
	  * @param formNo  单号
	 * @param selectField 要查询的字段
	 * @param applyNo 申请单号
	 */
	public List<Map<String,Object>> getAreaMarketMapinfos(String formNo,String selectField,String applyNo);
	
	/**
	 * 根据单号查询财务申请信息
	 * @param formNo  单号
	 * @param selectField 要查询的字段
	 */
	public Map<String, Object> getFinanceApplyMapInfos(String formNo,String selectField);
	
	/**
	 * 根据单号查询财务审批信息
	 * @param formNo  单号
	 * @param selectField 要查询的字段
	 */
	public List<Map<String, Object>> getFinancePayMapInfos(String formNo,String selectField);
	
	/**
	 * 根据单号查询销量信息
	 * @param formNo  单号
	 * @param selectField 要查询的字段
	 */
	public List<Map<String, Object>> getSaleLimtMapInfos(String formNo,String selectField);
    
    /**
     * 明细分页信息
     * @param  page  当前页
     * @param  rows  每页条数
     * @param  formNo  单号
     * @param  formNo  单号
     * @param tableName 表名
     * @param selectField 要查询的字段
     * @param queryKey where 条件
     * @return 返回分页后的数据信息
     */
    public Page<Map<String,Object>> findActivityBaseInfoMapPage(int page,int rows, String formNo,
    		String tableName,String selectField,String queryKey);
  
    
    
    
    /**
     * 查询工作流节点的配置信息
     * @param  节点id
     * @param  单子类型
     * @return  返回配置信息json
     */
    public String  getActivityNodeConfig(String activityCode,FormTypeEnum formType);
    	
    
    
}
