
/**
 * @Description:
 * @ClassName: com.biz.orderDocker.handler.AdapterLoggerHandler
 * @author: Omar(OmarZhang)
 * @date: 2016年5月17日 下午9:22:05
 */
package com.chinayanghe.tpm.cost.common.handler;

import cn.com.bizunited.cp.common.utils.JsonUtils;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

/**
 * 日志适配器处理信息  接口数据的日志处理器
 * @Description:
 * @ClassName: com.biz.orderDocker.handler.LoggerAdapterHandler
 * @author: Omar(OmarZhang)
 * @date: 2016年5月17日 下午9:22:23
 *
 */
@Component("appendOptLoggerHandler")
public class AppendOptLoggerHandler {
    private static Logger logger = Logger.getLogger(AppendOptLoggerHandler.class);

    /**
     * 日志处理
     * @Title: executeLogToElasticSearch
     * @param jsonValue
     * @author: Omar(OmarZhang)
     * @param e
     * @date: 2016年5月17日 下午9:23:18
     */
    public void error(String jsonValue, Exception e) {
        logger.error(jsonValue + ",{\"erro\":\"" + e.getMessage() + "\"}");
    }

    // 日志保存JSON对象
    public void info(Object o) {
        logger.info(JsonUtils.toJson(o));
    }

    public void info(String jsonValue) {
        logger.info(jsonValue);
    }

    // 日志保存JSON对象和信息
    public void info(Object o, String msg) {
        logger.info(new StringBuffer(JsonUtils.toJson(o)).append(",{\"msg\":\"").append(msg).append("\"}"));
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
