
/**
 * @Description:
 * @ClassName: com.biz.orderDocker.handler.AdapterLoggerHandler
 * @author: Omar(OmarZhang)
 * @date: 2016年5月17日 下午9:22:05
 */
package com.chinayanghe.tpm.cost.common.handler;

import cn.com.bizunited.cp.common.es.ElasticSearchManager;
import com.chinayanghe.tpm.cost.constants.GlobalErrorMsgs;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * ES工具
 * @Description:
 *
 */
@Component("elasticSearchHandler")
public class ElasticSearchHandler {
    @Autowired
    private ElasticSearchManager elasticSearchManager;

    /**
     * 插入数据到ES
     * @param index
     * @param type
     * @param id documentid
     * @param json  json数据
     * @return
     * @throws Exception
     */
    public int insertDate2Es(String index, String type, String id, String json) throws Exception {
        Client             client         = elasticSearchManager.getClient();    // 获取ES连接
        BulkRequestBuilder requestBuilder = client.prepareBulk();
        IndexRequest       indexRequest   = new IndexRequest(index, type, id);

        // 数据转JSON
        indexRequest = indexRequest.source(json);
        requestBuilder.add(indexRequest);

        BulkResponse       responses     = requestBuilder.execute().get();
        BulkItemResponse[] itemResponses = responses.getItems();

        if ((itemResponses == null) || (itemResponses.length == 0) || StringUtils.isEmpty(itemResponses[0].getId())) {
            throw new RuntimeException(GlobalErrorMsgs.SYSTEM_ERROR.getMsg());
        }

        return itemResponses.length;
    }

    /**
     * 更新数据到ES
     * @param index
     * @param type
     * @param id
     * @param json
     * @return
     * @throws Exception
     */
    public int updateDate2Es(String index, String type, String id, String json) throws Exception {
        Client               client  = elasticSearchManager.getClient();    // 获取ES连接
        UpdateRequestBuilder builder = client.prepareUpdate(index, type, id);

        builder.setDoc(json);

        UpdateResponse response = builder.execute().get();

        if (response == null) {
            throw new RuntimeException(GlobalErrorMsgs.SYSTEM_ERROR.getMsg());
        }

        return 1;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
