package com.chinayanghe.tpm.cost.constants;

import org.springframework.util.Base64Utils;

/**
 * @ClassName: com.chinayanghe.tpm.cost.constants.swagger
 * Created by OmarZhang on 2017/5/14 15:36.
 */
public final class Constants {

    /** 流程标识*/
    public static final String DEFAULT_ACTIVITI_PROCESS_MARK = "processMark";
    
    
    /**更新金额时的redis分布式锁的key 前缀**/
    public static final String ACTIVITY_BASEINF_AMT_REDIST_KEY="cost:activitybaseinfo:amtopt:";



    /**
     * 消费者宴席推广申请
     */
    public static final String CONSUMER_APPLY_CODE = "211801";

    /**
     * 来宾接待活动类型编码
     */
    public static final String GUEST_RECEIVE_CODE = "212501";

    /**
     * 操作类型 插入数据
     */
    public static final String OPT_TYPE_SAVE = "insert";

    /**
     * 操作类型 更新数据
     */
    public static final String OPT_TYPE_EDIT = "update";

    /**
     * 个人品鉴活动类型编码
     */
    public static final String PERSONAL_REVIEW_CODE = "211001";

    /**
     * 个人品鉴活动类型名称
     */
    public static final String PERSONAL_REVIEW_NAME = "个人品鉴";
    /**
     * 终端进场类型编码
     */
    public static final String TERMINAL_APPROACH_CODE = "211201";

    /**
     * 终端进场类型名称
     */
    public static final String TERMINAL_APPROACH_NAME = "终端进场";

    /**
     *  表单特殊类型(合同鉴审类型的表单标识)
     */
    public static final String PACTAUDIT_FORM_TYPE = "pactAudit";

    /**
     * 终端关键联系人标识
     */
    public static final String TERMINAL_LINKMAN_TYPE = "01";

    /**
     * 样品酒领用一级类型名称
     */
    public static final String SAMPLE_GAIN_NAME = "业务用酒";

    /**
     * 样品酒领用二级活动编码
     */
    public static final String SAMPLE_GAIN_SECOND_CODE = "212301";

    /**
     * 样品酒领用二级活动申请名称
     */
    public static final String SAMPLE_GAIN_SECOND_APPLY_NAME = "样品酒领用申请";


    /**
     * 渠道劳务支出活动类型名称
     */
    public static final String CHANNEL_LABOR_NAME = "渠道劳务支出";

    /**
     * 渠道劳务支出二级编码
     */
    public static final String CHANNEL_LABOR_SECOND_CODE = "210401";

    /**
     * 区域点上事件营销二级名称
     */
    public static final String AREA_POINT_EVENT_SECOND_APPLY_NAME = "区域点上事件营销申请";

    /**
     * 区域点上事件营销二级名称
     */
    public static final String AREA_POINT_EVENT_SECOND_REGIST_NAME = "区域点上事件营销登记";

    /**
     * 区域点上事件营销二级名称
     */
    public static final String AREA_POINT_EVENT_SECOND_PAY_NAME = "区域点上事件营销核报";

    /**
     * 区域点上事件营销编码
     */
    public static final String AREA_POINT_EVENT_SECOND_CODE = "210301";

    /**
     * 渠道客情维系活动类型名称
     */
    public static final String CHANNEL_CUSTOMER_NAME = "渠道客情维系";

    /**
     * 渠道客情维系二级编码
     */
    public static final String CHANNEL_CUSTOMER_SECOND_CODE = "210701";

    /**
     * 部队慰问二级活动编码
     */
    public static final String TROOP_CARE_SECOND_CODE = "211003";
    /**
     * 部队慰问二级活动类型名称
     */
    public static final String TROOP_CARE_SECOND_NAME = "部队慰问申请";
    /**
     * 葡萄酒广告二级活动编码
     */
    public static final String GRAPE_WINE_ADVERT_SECOND_CODE = "210104";
    /**
     * 葡萄酒广告二级活动类型名称
     */
    public static final String GRAPE_WINE_ADVERT_SECOND_NAME = "葡萄酒广告申请";

    /**
     * 葡萄酒事件营销二级活动编码
     */
    public static final String GRAPE_WINE_MARTKTING_SECOND_CODE = "210303";
    /**
     * 葡萄酒事件营销二级活动类型名称
     */
    public static final String GRAPE_WINE_MARTKT_SECOND_NAME = "葡萄酒事件营销申请";


    /**
     * 葡萄酒赞助投入二级活动编码
     */
    public static final String GRAPE_WINE_SPONSOR_SECOND_CODE = "210202";
    /**
     * 葡萄酒赞助投入二级活动类型名称
     */
    public static final String GRAPE_WINE_SPONSOR_SECOND_NAME = "葡萄酒赞助投入申请";

    /**
     * 葡萄酒客情维系投入二级活动编码
     */
    public static final String GRAPE_WINE_CUSTOMERS_RELATION_SECOND_CODE = "210703";
    /**
     * 葡萄酒客情维系投入二级活动类型名称
     */
    public static final String GRAPE_WINE_CUSTOMERS_RELATION_SECOND_NAME = "葡萄酒客情维系投入申请";


    /** 财务部在组织框架中的代码 */
    public final static String DEPART_FINANCE = "100001";

    /**
     * 酒店个性化奖励
     */
    public static final String HOTEL_AWARD_CODE = "211301";

    /**
     * 渠道宣传费
     */
    public static final String MARKET_CHANNEL_CODE = "210901";

    /**
     * 全国面上广告
     */
    public static final String COUNTRY_PLANE_AD_CODE = "210101";

    /** 编码*/
    private static final CodeInterval ONE_CODE_INTERVAL = new CodeInterval(10000000L,19999999L);
    private static final CodeInterval TWO_CODE_INTERVAL = new CodeInterval(20000000L,29999999L);
    private static final CodeInterval THREE_CODE_INTERVAL = new CodeInterval(30000000L,39999999L);
    private static final CodeInterval FOUR_CODE_INTERVAL = new CodeInterval(40000000L,49999999L);

    /**
     * 终端进场类型编码
     */
    public static final String KA_BARCODE_CODE = "211401";

    /**
     * 终端进场类型名称
     */
    public static final String KA_BARCODE_NAME = "商超条码注册";
        /**
     * 生成编码code标识
     */
    public enum CodeType {

        /** 消费者申请 */
        CUSTOMER_APPLY_CODE("XG", IntervalType.ONE),
        CUSTOMER_REGIST_CODE("XG", IntervalType.TWO),
        CUSTOMER_PAY_CODE("XG", IntervalType.THREE),
        CUSTOMER_REPORTED_CODE("XG", IntervalType.FOUR),
        /** 专项费用 */
        CUSTOMER_SPECIAL_EXPENSES("ZX", IntervalType.THREE),
        /**个人品鉴*/
        PERSONAL_REVIEW_APPLY("PJ", IntervalType.ONE),
        PERSONAL_REVIEW_PAY("PJ", IntervalType.THREE),

        WELLDONE_APPLY_CODE("DB", IntervalType.ONE),
        WELLDONE_REGIST_CODE("DB", IntervalType.TWO),
        WELLDONE_PAY_CODE("DB", IntervalType.THREE),
        /** 合同鉴审*/
        PACTAUDIT_APPLY("PA", IntervalType.ONE),
        /** 样品酒领用*/
        SAMPLEGAIN_APPLY("YP", IntervalType.ONE),
        /** 区域点上捐赠*/
        AREAPOINT_APPLY_SPONSOR("JZ", IntervalType.ONE),
        AREAPOINT_REGIST_SPONSOR("JZ", IntervalType.TWO),
        AREAPOINT_PAY_SPONSOR("JZ", IntervalType.THREE),
        AREAPOINT_REPORTED_SPONSOR("JZ", IntervalType.FOUR),
        /** 门头牌 */
        DOORPLATE_APPLY("MT" , IntervalType.ONE),
        DOORPLATE_REGIST("MT" , IntervalType.TWO),
        DOORPLATE_PAY("MT" , IntervalType.THREE),
        /** 门头牌合同鉴审 */
        DOORPLATE_AUDIT("MK" , IntervalType.ONE),
        /** 常规客情费用 */
        NORMAL_GUEST_FREES("CG", IntervalType.THREE),
        /** 渠道劳务支出申请 */
        CHANNEL_LABOR_CODE("LW", IntervalType.ONE),CHANNEL_LABOR_REGIST_CODE("LW", IntervalType.TWO),CHANNEL_LABOR_PAY_CODE("LW", IntervalType.THREE),
        /** 终端进场 */
        TERMINAL_APPROACH_APPLY_CODE("ZH", IntervalType.ONE),
        TERMINAL_APPROACH_REGIST_CODE("ZH", IntervalType.TWO),
        TERMINAL_APPROACH_PAY_CODE("ZH", IntervalType.THREE),

        /**客情维系**/
        CHANNEL_CUSTOMER_CODE("KW", IntervalType.ONE),
        /**渠道客情维系**/
        CHANNEL_CUSTOMER_APPLY_CODE("KW", IntervalType.ONE),
        CHANNEL_CUSTOMER_REGIST_CODE("KW", IntervalType.TWO),
        CHANNEL_CUSTOMER_REPORT_CODE("BK", IntervalType.FOUR),
        CHANNEL_CUSTOMER_PAY_CODE("KW", IntervalType.THREE),

        /**部队慰问*/
        TROOP_CARE_APPLY_CODE("BD", IntervalType.ONE),
        TROOP_CARE_REGIST_CODE("BD", IntervalType.TWO),
        TROOP_CARE_PAY_CODE("BD", IntervalType.THREE),
        /**葡萄酒事件营销*/
        GREAP_WINE_MARTKTING_APPLY_CODE("PY", IntervalType.ONE),
        GREAP_WINE_MARTKTING_REGIST_CODE("PY", IntervalType.TWO),
        GREAP_WINE_MARTKTING_PAY_CODE("PY", IntervalType.THREE),
        /**葡萄酒广告*/
        GREAP_WINE_ADVERT_APPLY_CODE("PG", IntervalType.ONE),
        GREAP_WINE_ADVERT_REGIST_CODE("PG", IntervalType.TWO),
        GREAP_WINE_ADVERT_PAY_CODE("PG", IntervalType.THREE),
        /**葡萄酒赞助投入*/
        GREAP_WINE_SPONSOR_APPLY_CODE("PZ", IntervalType.ONE),
        GREAP_WINE_SPONSOR_REGIST_CODE("PZ", IntervalType.TWO),
        GREAP_WINE_SPONSOR_PAY_CODE("PZ", IntervalType.THREE),
        /**葡萄酒客情维系投入*/
        GREAP_WINE_CUSTOMERS_RELATION_APPLY_CODE("PW", IntervalType.ONE),
        GREAP_WINE_CUSTOMERS_RELATION_REGIST_CODE("PW", IntervalType.TWO),
        GREAP_WINE_CUSTOMERS_RELATION_PAY_CODE("PW", IntervalType.THREE),

        /** 个性化促销品采购 */
        PERSONALIZED_PROMOTION_APPLY("GX", IntervalType.ONE),
        /**	酒店个性化奖励*/
    	HOTEL_AWARD_APPLY("JG", IntervalType.ONE),HOTEL_AWARD_REGIST("JG", IntervalType.TWO),HOTEL_AWARD_PAY("JG", IntervalType.THREE),
    	/** 个性化奖卡延期 */
    	PERSONAL_AWARD_DELAY_APPLY("PD", IntervalType.ONE),
    	/**	渠道宣传费*/
    	MARKET_CHANNEL_APPLY("ZS", IntervalType.ONE),MARKET_CHANNEL_REGIST("ZS", IntervalType.TWO),
    	MARKET_CHANNEL_PAY("ZS", IntervalType.THREE),MARKET_CHANNEL_REPORTED("ZS", IntervalType.FOUR),
    	 /**销量控制**/
        SALELIMITSEQ("SEQ", IntervalType.ONE),
        /**旅游服务*/
        TRAVEL_SERVICE("LV", IntervalType.ONE),
        /**专卖店支持*/
        EXCLUSIVE_STORE_APPLY("ZZ", IntervalType.ONE),EXCLUSIVE_STORE_REGIST("ZZ", IntervalType.TWO),EXCLUSIVE_STORE_PAY("ZZ", IntervalType.THREE),
        /**区域面上广告MG*/
        AREA_PLANT_AD_APPLY("MG", IntervalType.ONE), AREA_PLANT_AD_REGIST("MG", IntervalType.TWO), AREA_PLANT_AD_PAY("MG", IntervalType.THREE),
        /**  区域面上事件营销 */
        AREA_PLANE_EVENT_APPLY("MY" , IntervalType.ONE),
        AREA_PLANE_EVENT_REGIST("MY" , IntervalType.ONE),
        AREA_PLANE_EVENT_PAY("MY" , IntervalType.ONE),
        /** 单位赠酒 */
        COMPANY_GIFT_WINE_APPLY("DW" , IntervalType.ONE),
        COMPANY_GIFT_WINE_PAY("DW" , IntervalType.THREE),
        /**区域点上广告DG*/
        AREA_POINT_AD_APPLY("DG", IntervalType.ONE),AREA_POINT_AD_REGIST("DG", IntervalType.TWO),AREA_POINT_AD_PAY("DG", IntervalType.THREE),
        AREA_POINT_EVENT_APPLY("DY", IntervalType.ONE),AREA_POINT_EVENT_REGIST("DY", IntervalType.TWO),AREA_POINT_EVENT_PAY("DY", IntervalType.THREE),
        /** 商超进场 */
        KA_BARCODE_APPLY_CODE("DM", IntervalType.ONE),
        KA_BARCODE_REGIST_CODE("DM", IntervalType.TWO),
        KA_BARCODE_PAY_CODE("DM", IntervalType.THREE),
        /**全国面上广告QG*/
        COUNTRY_PLANE_AD_APPLY("QG", IntervalType.ONE),COUNTRY_PLANE_AD_REGIST("QG", IntervalType.TWO),COUNTRY_PLANE_AD_PAY("QG", IntervalType.THREE),
        /**来宾接待LB*/
        GUEST_RECEIVE_APPLY("LB", IntervalType.ONE), GUEST_RECEIVE_PAY("LB", IntervalType.THREE),
        /**常规促销品*/
        NORMAL_PROMOTION_APPLY("CL", IntervalType.ONE),NORMAL_PROMOTION_REGIST("CL", IntervalType.TWO),
        NORMAL_PROMOTION_PAY("CL", IntervalType.THREE)
        ;


        private String code;
        /** 区间*/
        private IntervalType intervalType;

        CodeType(String code, IntervalType intervalType) {
            this.code = code;
            this.intervalType = intervalType;
        }

        public String getCode() {
            return this.code;
        }

        public IntervalType getIntervalType() {
            return intervalType;
        }

        /**
         * 获取唯一标识
         * @return
         */
        public String formatMark() {
            String code = this.getCode();
            String intervalType = this.getIntervalType().getFormatString();
            return Base64Utils.encodeToString((code.concat("_").concat(intervalType)).getBytes());
        }

        /**
         * 获取唯一标识
         * @return
         */
        public byte[] formatMarkByte() {
            return formatMark().getBytes();
        }

    }

    public enum IntervalType{
        ONE(ONE_CODE_INTERVAL),
        TWO(TWO_CODE_INTERVAL),
        THREE(THREE_CODE_INTERVAL),
        FOUR(FOUR_CODE_INTERVAL);

        private CodeInterval codeInterval;

        IntervalType (CodeInterval codeInterval) {
            this.codeInterval = codeInterval;
        }

        public CodeInterval getCodeInterval() {
            return codeInterval;
        }

        public void setCodeInterval(CodeInterval codeInterval) {
            this.codeInterval = codeInterval;
        }
        public String getFormatString() {
            return this.codeInterval.toString();
        }
    }
}

//~ Formatted by Jindent --- http://www.jindent.com
